/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.menu.handlers;

import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.check.ISyntaxProblemListener;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import java.util.Collection;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditSwitchSyntaxCheckCommandState
extends State
implements IWindowListener,
IPageListener,
IPartListener,
ISyntaxProblemListener {
    private IWorkbench workbench = PlatformUI.getWorkbench();
    private IWorkbenchWindow activeWindow;
    private IWorkbenchPage activePage;
    private ICheckMgr activeCheckMgr;

    public EditSwitchSyntaxCheckCommandState() {
        this.workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null) {
            this.windowActivated(window);
        }
        this.update();
    }

    public void dispose() {
        if (this.activeWindow != null) {
            this.windowDeactivated(this.activeWindow);
        }
        this.workbench.removeWindowListener((IWindowListener)this);
        this.workbench = null;
        super.dispose();
    }

    public void windowActivated(IWorkbenchWindow window) {
        IWorkbenchPage page;
        if (window != this.activeWindow) {
            this.activeWindow = window;
            this.activeWindow.addPageListener((IPageListener)this);
        }
        if ((page = this.activeWindow.getActivePage()) != null) {
            this.pageActivated(page);
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        if (this.activePage != null) {
            this.pageClosed(this.activePage);
        }
        if (this.activeWindow != null) {
            assert (window == this.activeWindow);
            this.activeWindow.removePageListener((IPageListener)this);
        }
        this.activeWindow = null;
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.activePage != page) {
            if (this.activePage != null) {
                this.pageClosed(this.activePage);
            }
            this.activePage = page;
            this.activePage.addPartListener((IPartListener)this);
            IWorkbenchPart part = this.activePage.getActivePart();
            if (part != null) {
                this.partActivated(part);
            }
        }
    }

    public void pageClosed(IWorkbenchPage page) {
        if (this.activePage == page) {
            this.checkMgrDeactivated();
            this.activePage.removePartListener((IPartListener)this);
            this.activePage = null;
        }
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partActivated(IWorkbenchPart part) {
        ICheckMgr checkMgr = (ICheckMgr)part.getAdapter(ICheckMgr.class);
        this.checkMgrActivated(checkMgr);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.checkMgrDeactivated();
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void checkMgrActivated(ICheckMgr checkMgr) {
        this.checkMgrDeactivated();
        this.activeCheckMgr = checkMgr;
        if (this.activeCheckMgr != null) {
            this.activeCheckMgr.registerSyntaxProblemListener(this);
            this.update();
        }
    }

    private void checkMgrDeactivated() {
        if (this.activeCheckMgr != null) {
            this.activeCheckMgr.unregisterSyntaxProblemListener(this);
            this.activeCheckMgr = null;
            this.update();
        }
    }

    @Override
    public void syntaxProblemListChanged(Collection<? extends ISyntaxProblem> allSyntaxProblems) {
        this.update();
    }

    private void update() {
        boolean syntaxCheckEnabled = this.activeCheckMgr != null ? this.activeCheckMgr.isSyntaxCheckEnabled() : false;
        this.setValue(syntaxCheckEnabled);
    }
}

