/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.inputinterpreter;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.commands.CMChangePlanElementDescription;
import com.arcway.planagent.planeditor.commands.CMDeletePlanElements;
import com.arcway.planagent.planeditor.commands.CMMoveFigureStructure;
import com.arcway.planagent.planeditor.commands.CMMoveGraphicalSupplementStructure;
import com.arcway.planagent.planeditor.commands.CMMovePlanElementStructure;
import com.arcway.planagent.planeditor.commands.CMOpenPlanElement;
import com.arcway.planagent.planeditor.commands.CMRenamePlanElement;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.commands.Command;

public class IIUtilities {
    public static List getFilteredPMItems(List<PEPlanEditPart> pEPlanEditParts, Class expectedPMType) {
        ArrayList<Object> filteredItems = new ArrayList<Object>(pEPlanEditParts.size());
        for (PEPlanEditPart currentItem : pEPlanEditParts) {
            assert (currentItem instanceof PEPlanEditPart) : "item is not an instance of PEPlanEditPart";
            Object model = currentItem.getModel();
            boolean toAdd = true;
            if (expectedPMType != null) {
                toAdd = expectedPMType.isInstance(model);
            }
            if (!toAdd) continue;
            filteredItems.add(model);
        }
        return filteredItems;
    }

    public static List<PEPlanElement> getRelatedPEPlanElements(List<? extends PEPlanEditPart> pEPlanEditParts, Class<? extends IPMPlanElementRO> expectedPMType) {
        Set<PEPlanElement> unsortedPEPlanElementsSet = IIUtilities.getRelatedPEPlanElements(pEPlanEditParts);
        ArrayList<PEPlanElement> sortedAndFilteredPEPlanElements = new ArrayList<PEPlanElement>(unsortedPEPlanElementsSet.size());
        for (PEPlanEditPart pEPlanEditPart : pEPlanEditParts) {
            PEPlanElement relatedPlanElement = IIUtilities.getRelatedPEPlanElement(pEPlanEditPart);
            if (relatedPlanElement == null || !unsortedPEPlanElementsSet.remove(relatedPlanElement)) continue;
            Object modelObject = relatedPlanElement.getModel();
            boolean toAdd = true;
            if (expectedPMType != null) {
                toAdd &= expectedPMType.isInstance(modelObject);
            }
            if (!toAdd) continue;
            sortedAndFilteredPEPlanElements.add(relatedPlanElement);
        }
        return sortedAndFilteredPEPlanElements;
    }

    public static List<PMPlanElement> getRelatedPMPlanElements(List<? extends PEPlanEditPart> pEPlanEditParts, Class expectedPMType) {
        Set<PEPlanElement> pEPlanElements = IIUtilities.getRelatedPEPlanElements(pEPlanEditParts);
        ArrayList<PMPlanElement> pMPlanElements = new ArrayList<PMPlanElement>(pEPlanElements.size());
        for (PEPlanElement planEditPart : pEPlanElements) {
            Object modelObject = planEditPart.getModel();
            boolean toAdd = true;
            if (expectedPMType != null) {
                toAdd &= expectedPMType.isInstance(modelObject);
            }
            if (!toAdd) continue;
            pMPlanElements.add((PMPlanElement)modelObject);
        }
        return pMPlanElements;
    }

    private static Set<PEPlanElement> getRelatedPEPlanElements(List<? extends PEPlanEditPart> pEPlanEditParts) {
        HashSet<PEPlanElement> pEPlanElements = new HashSet<PEPlanElement>(pEPlanEditParts.size());
        for (PEPlanEditPart pEPlanEditPart : pEPlanEditParts) {
            PEPlanElement relatedPlanElement = IIUtilities.getRelatedPEPlanElement(pEPlanEditPart);
            if (relatedPlanElement == null) continue;
            pEPlanElements.add(relatedPlanElement);
        }
        return pEPlanElements;
    }

    private static PEPlanElement getRelatedPEPlanElement(PEPlanEditPart planEditPart) {
        PEPlanElement relatedPlanElement;
        if (planEditPart instanceof PEPlanElement) {
            relatedPlanElement = (PEPlanElement)planEditPart;
        } else if (planEditPart instanceof PEFigure) {
            PEFigure pEFigure = (PEFigure)planEditPart;
            PEPlanElement planElement = pEFigure.getPEPlanElement();
            relatedPlanElement = planElement.getEditFigure() == pEFigure ? planElement : null;
        } else if (planEditPart instanceof PEGraphicalSupplement) {
            PEPlanElement planElement;
            PEGraphicalSupplement pEFigure = (PEGraphicalSupplement)planEditPart;
            relatedPlanElement = planElement = pEFigure.getPEPlanElement();
        } else {
            relatedPlanElement = null;
        }
        return relatedPlanElement;
    }

    public static Command createCMMoveCommand(List pePlanEditParts, GeoVector translation, boolean moveChildrenAlso, ICommandContext commandContext) {
        TransactionCommand cmd = null;
        List pmPlanElements = IIUtilities.getFilteredPMItems(pePlanEditParts, IPMPlanElementRO.class);
        List pmFigures = IIUtilities.getFilteredPMItems(pePlanEditParts, IPMFigureRO.class);
        List pmSupplements = IIUtilities.getFilteredPMItems(pePlanEditParts, IPMGraphicalSupplementRO.class);
        if (pmPlanElements.size() > 0) {
            cmd = new CMMovePlanElementStructure(pmPlanElements, translation, moveChildrenAlso, commandContext);
        } else if (pmFigures.size() > 0) {
            cmd = new CMMoveFigureStructure(pmFigures, translation, moveChildrenAlso, commandContext);
        } else if (pmSupplements.size() > 0) {
            cmd = new CMMoveGraphicalSupplementStructure(pmSupplements, translation, commandContext);
        }
        return cmd;
    }

    public static Command createCMDeleteCommand(List<PEPlanEditPart> pePlanEditParts, int deletionMode, ICommandContext commandContext) {
        List<PMPlanElement> pMItems = IIUtilities.getRelatedPMPlanElements(pePlanEditParts, null);
        CMDeletePlanElements returnCommand = new CMDeletePlanElements(pMItems, deletionMode, commandContext);
        return returnCommand;
    }

    public static Command createCMRenameCommand(PEPlanElement editPart, ICommandContext commandContext) {
        ArrayList<PEPlanElement> editPartList = new ArrayList<PEPlanElement>(1);
        editPartList.add(editPart);
        List<PMPlanElement> pmPlanElements = IIUtilities.getRelatedPMPlanElements(editPartList, IPMPlanElementRO.class);
        if (pmPlanElements.isEmpty()) {
            return null;
        }
        IPMPlanElementRO planModel = (IPMPlanElementRO)pmPlanElements.get(0);
        return new CMRenamePlanElement(planModel, editPart.getRenameTransaction(commandContext.getActionParameters()), commandContext);
    }

    public static Command createCMChangeDescriptionCommand(PEPlanElement editPart, ICommandContext commandContext) {
        ArrayList<PEPlanElement> editPartList = new ArrayList<PEPlanElement>(1);
        editPartList.add(editPart);
        List<PMPlanElement> pmPlanElements = IIUtilities.getRelatedPMPlanElements(editPartList, IPMPlanElementRO.class);
        if (pmPlanElements.isEmpty()) {
            return null;
        }
        IPMPlanElementRO planModel = (IPMPlanElementRO)pmPlanElements.get(0);
        return new CMChangePlanElementDescription(planModel, editPart.getChangeDescriptionTransaction(commandContext.getActionParameters()), commandContext);
    }

    public static Command createCMOpenCommand(PEPlanElement editPart, ICommandContext commandContext) {
        ArrayList<PEPlanElement> editPartList = new ArrayList<PEPlanElement>(1);
        editPartList.add(editPart);
        List<PMPlanElement> pmPlanElements = IIUtilities.getRelatedPMPlanElements(editPartList, IPMPlanElementRO.class);
        if (pmPlanElements.isEmpty()) {
            return null;
        }
        IPMPlanElementRO planModel = (IPMPlanElementRO)pmPlanElements.get(0);
        return new CMOpenPlanElement(planModel, commandContext);
    }
}

