/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.planagent.planeditor.figures.FigureTransformation;
import com.arcway.planagent.planeditor.figures.PFPlan;
import com.arcway.planagent.planeditor.handles.EXDontKnowHowToFixException;
import com.arcway.planagent.planeditor.handles.PFHandleFigure;
import com.arcway.planagent.planview.view.IViewPartMgr;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;

public abstract class TransformingHandleLocator
implements Locator {
    private final IViewPartMgr viewPartMgr;
    private final PFPlan planFigure;
    private Transformation transformationPlanToHandle;

    protected TransformingHandleLocator(IViewPartMgr viewPartMgr, PFPlan planFigure) {
        assert (viewPartMgr != null) : "viewManager is null";
        assert (planFigure != null) : "planFigure is null";
        this.viewPartMgr = viewPartMgr;
        this.planFigure = planFigure;
    }

    public void relocate(IFigure target) {
        TransformationAffiliate transformationPlanToCanvas = this.viewPartMgr.getTransformationPlan2Canvas();
        FigureTransformation transformationCanvasToHandle = new FigureTransformation((IFigure)this.planFigure, true, target, false);
        this.transformationPlanToHandle = transformationPlanToCanvas.transform((Transformation)transformationCanvasToHandle);
        if (target instanceof PFHandleFigure) {
            PFHandleFigure abstractHandleFigure = (PFHandleFigure)target;
            abstractHandleFigure.setBounds(abstractHandleFigure.getOuterBoundsInDraw2DFigureCoordinates());
        }
    }

    protected abstract Points getReferencePointsInPlanCoordinates();

    protected GeoVector getReferencePointOffsetInHandleCoordinates() {
        return GeoVector.NULL;
    }

    public final Points getReferencePointsInHandleCoordinates() {
        Points pointsInPlanCoordinates = this.getReferencePointsInPlanCoordinates();
        GeoVector offsetInHandleCoordinates = this.getReferencePointOffsetInHandleCoordinates();
        Points pointsInHandleCoordinates = new Points(pointsInPlanCoordinates.size());
        for (Point point : pointsInPlanCoordinates) {
            Transformation plan2HandleTransformation = this.getTransformationPlan2Handle();
            if (plan2HandleTransformation != null) {
                Point pointInHandleCoordinates = point.transform(plan2HandleTransformation);
                pointInHandleCoordinates = pointInHandleCoordinates.movePoint(offsetInHandleCoordinates);
                pointsInHandleCoordinates.add(pointInHandleCoordinates);
                continue;
            }
            throw new EXDontKnowHowToFixException("try to get reference points from uninitialized handle");
        }
        return pointsInHandleCoordinates;
    }

    private Transformation getTransformationPlan2Handle() {
        return this.transformationPlanToHandle;
    }
}

