/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planeditor.handles.PVHandleView;
import com.arcway.planagent.planeditor.handles.TransformingHandleLocator;

public class PVHandleViewColoredOutline
extends PVHandleView {
    private final boolean closedDraw;
    private Color lineColor;
    private LineStyle lineStyle;
    private double lineWidth;

    protected PVHandleViewColoredOutline(TransformingHandleLocator locator, boolean closedDraw, double lineWidth, Color lineColor, LineStyle lineStyle) {
        super(locator);
        this.closedDraw = closedDraw;
        this.setLineWidth(lineWidth);
        this.setLineColor(lineColor);
        this.setLineStyle(lineStyle);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineStyle(LineStyle style) {
        this.lineStyle = style;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void drawFigure(Device device) {
        Points referencePoints = this.getReferencePoints();
        Corners corners = new Corners();
        for (Point p : referencePoints) {
            corners.add((Point)new Corner(p, 0.0));
        }
        if (this.closedDraw) {
            device.polygon(corners, this.getLineWidth(), this.getLineColor(), this.getLineStyle());
        } else {
            device.polyline(corners, this.getLineWidth(), this.getLineColor(), this.getLineStyle());
        }
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        return false;
    }
}

