/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.planagent.planeditor.handles.PVHandleView;
import com.arcway.planagent.planeditor.handles.TransformingHandleLocator;

public class PVHandleViewColoredLine
extends PVHandleView {
    public static final double DEFAULT_HANDLE_WIDTH = 2.1;
    public static final double DEFAULT_HANDLE_LENGTH = 10.0;
    private FillColor fillColor;
    private FillStyle fillStyle;
    private double width;
    private double length;

    protected PVHandleViewColoredLine(TransformingHandleLocator locator, double width, double length, FillColor fillColor, FillStyle fillStyle) {
        super(locator);
        this.setWidth(width);
        this.setLength(length);
        this.setFillColor(fillColor);
        this.setFillStyle(fillStyle);
    }

    protected FillColor getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(FillColor color) {
        assert (color != null) : "color is null";
        this.fillColor = new FillColor(color);
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle style) {
        this.fillStyle = style;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void drawFigure(Device device) {
        Points referencePoints = this.getReferencePoints();
        Point referencePointStart = referencePoints.get(0);
        Point referencePointEnd = referencePoints.get(1);
        GeoVector directionLength = new GeoVector(referencePointStart, referencePointEnd).scaleToLength(this.getLength());
        GeoVector directionWidthHalf = directionLength.turn90().scaleToLength(this.getWidth() / 2.0);
        Point p1 = referencePointStart.movePoint(directionWidthHalf);
        Point p2 = referencePointStart.movePoint(directionLength).movePoint(directionWidthHalf);
        Point p3 = referencePointStart.movePoint(directionLength).movePoint(directionWidthHalf.turn180());
        Point p4 = referencePointStart.movePoint(directionWidthHalf.turn180());
        Corners corners = new Corners();
        corners.add((Point)new Corner(p1, 0.0));
        corners.add((Point)new Corner(p2, 0.0));
        corners.add((Point)new Corner(p3, 0.0));
        corners.add((Point)new Corner(p4, 0.0));
        device.polygon(corners, this.getFillColor(), this.getFillStyle());
    }
}

