/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class HandleTemplate {
    private final IPMPlanRO plan;
    private final IOffscreenBitmap image;
    private final Label toolTip;
    private final int standardControlFlowLength;

    public HandleTemplate(IStreamResource plan, IStreamResource image, String toolTip, int standardControlFlowLength) {
        this.plan = HandleTemplate.loadPlan(plan);
        this.image = HandleTemplate.loadImage(image);
        this.toolTip = new Label(" " + toolTip + " ");
        this.standardControlFlowLength = standardControlFlowLength;
    }

    public List<IPMPointRO> duplicatePlanAndFindPointsToAnchor() throws EXPlanCreationException, IllegalArgumentException {
        HashMap uidMap = new HashMap();
        PMPlan planCopy = ((PMPlan)this.plan).getCopy(null, uidMap);
        return HandleTemplate.findPointsToAnchor((IPMPlanRO)planCopy);
    }

    private static List<IPMPointRO> findPointsToAnchor(IPMPlanRO plan) throws IllegalArgumentException {
        ArrayList<IPMPointRO> pointsToAnchor = new ArrayList<IPMPointRO>();
        int i = 0;
        while (i < plan.getPlanElementCount()) {
            IPMPlanElementRO potentialControlFlow = plan.getPlanElementRO(i);
            int j = 0;
            while (j < potentialControlFlow.getFigureCount()) {
                IPMFigureRO potentialLine = potentialControlFlow.getFigureRO(j);
                IPMPointListRO pointList = potentialLine.getPointListRO();
                if (pointList.getPointCount() > pointList.getLineCount()) {
                    IPMPointRO potentialAnchorPoint = pointList.getPointRO(0);
                    if (potentialAnchorPoint.getAnchoringRO() == null) {
                        if (pointsToAnchor.size() == 0 || potentialAnchorPoint.getPosition().equalsPoint(((IPMPointRO)pointsToAnchor.get(0)).getPosition())) {
                            pointsToAnchor.add(potentialAnchorPoint);
                        } else if (potentialAnchorPoint.getPosition().y < ((IPMPointRO)pointsToAnchor.get((int)0)).getPosition().y) {
                            pointsToAnchor.clear();
                            pointsToAnchor.add(potentialAnchorPoint);
                        }
                    }
                    if ((potentialAnchorPoint = pointList.getPointRO(pointList.getPointCount() - 1)).getAnchoringRO() == null) {
                        if (pointsToAnchor.size() == 0 || potentialAnchorPoint.getPosition().equalsPoint(((IPMPointRO)pointsToAnchor.get(0)).getPosition())) {
                            pointsToAnchor.add(potentialAnchorPoint);
                        } else if (potentialAnchorPoint.getPosition().y < ((IPMPointRO)pointsToAnchor.get((int)0)).getPosition().y) {
                            pointsToAnchor.clear();
                            pointsToAnchor.add(potentialAnchorPoint);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (pointsToAnchor.size() == 0) {
            throw new IllegalArgumentException("plan structure template has no point to anchor");
        }
        return pointsToAnchor;
    }

    private static IOffscreenBitmap loadImage(IStreamResource templateRes) {
        Image tmpImage = ImageCache.getImage((Display)Display.getCurrent(), (IStreamResource)templateRes);
        return new SWTOffscreenBitmap(tmpImage, false, null);
    }

    private static IPMPlanRO loadPlan(IStreamResource templateRes) {
        PlanModelMgr pmmgr = new PlanModelMgr();
        try {
            InputStream templateResIs = templateRes.toInputStream();
            try {
                pmmgr.load(templateResIs);
            }
            finally {
                if (templateResIs != null) {
                    FileHelper.closeInputStream((InputStream)templateResIs);
                }
            }
        }
        catch (EXPlanCreationException e) {
            return null;
        }
        catch (JvmExternalResourceInteractionException e) {
            return null;
        }
        PMPlan tmpPlan = pmmgr.getPlan();
        return tmpPlan;
    }

    public IPMPlanRO getPlan() {
        return this.plan;
    }

    public IOffscreenBitmap getImage() {
        return this.image;
    }

    public Label getToolTip() {
        return this.toolTip;
    }

    public int getStandardControlFlowLength() {
        return this.standardControlFlowLength;
    }
}

