/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.commands.CMMoveFigureStructure;
import com.arcway.planagent.planeditor.commands.CMMoveGraphicalSupplementStructure;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.handles.AbstractHandle;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import de.plans.lib.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandlePointMovePlanObject
extends AbstractHandle
implements IHandlePoint {
    private static final Logger logger = Logger.getLogger(HandlePointMovePlanObject.class);
    PEPlanObject planObject;

    public HandlePointMovePlanObject(PEPlanObject planObject, EditMgr viewManager, FeedbackManager feedbackManager, int type) {
        super((EditPart)planObject, viewManager, feedbackManager, type);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("HandlePoint(PEPlanObject planObject = " + planObject + ", ViewMgr viewManager = " + viewManager + ", FeedbackManager feedbackManager = " + feedbackManager + ", IPMPlanObjectRO planObject = " + planObject + ", int type = " + type + ") - start"));
        }
        assert (planObject != null);
        this.planObject = planObject;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"HandlePoint(EditPart, ViewMgr, FeedbackManager, IPMPointRO, int) - end");
        }
    }

    @Override
    public com.arcway.lib.geometry.Point getPosition() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getPosition() - start");
        }
        com.arcway.lib.geometry.Point returnPoint = this.planObject.getPMPointList().getPoints().getBounds().center();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getPosition() - end - return value = " + returnPoint));
        }
        return returnPoint;
    }

    @Override
    public Command getCommand(Request request) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getCommand(Request request = " + request + ") - start"));
        }
        if (request instanceof RQDragNDropHandle) {
            RQDragNDropHandle requestDnD = (RQDragNDropHandle)request;
            Point fromScreen = requestDnD.getFrom();
            Point toScreen = requestDnD.getTo();
            com.arcway.lib.geometry.Point from = this.transformToPlanCoordinates(fromScreen);
            com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
            GeoVector translation = new GeoVector(from, to);
            PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
            ArrayList<PEPlanEditPart> pEPlanObjects = new ArrayList<PEPlanEditPart>(1);
            pEPlanObjects.add(this.planObject);
            List pMPlanObjects = IIUtilities.getFilteredPMItems(pEPlanObjects, null);
            TransactionCommand returnCommand = this.planObject instanceof PEFigure ? new CMMoveFigureStructure(pMPlanObjects, translation, false, pEPlanEditPart.getCommandContext()) : (this.planObject instanceof PEGraphicalSupplement ? new CMMoveGraphicalSupplementStructure(pMPlanObjects, translation, pEPlanEditPart.getCommandContext()) : null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("getCommand(Request) - end - return value = " + (Object)((Object)returnCommand)));
            }
            return returnCommand;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getCommand(Request) - end - return value = " + null));
        }
        return null;
    }

    @Override
    public GeoVector getDirection() {
        return null;
    }

    @Override
    public int getCommandType(String requestType) {
        int commandType = 1;
        if ("drag handle".equals(requestType)) {
            commandType = 5;
        }
        return commandType;
    }

    @Override
    public GeoVector getOffsetInPixels() {
        return GeoVector.NULL;
    }
}

