/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planeditor.commands.CMMovePoint;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.handles.HandlePoint;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class HandlePointDiagonal
extends HandlePoint {
    public HandlePointDiagonal(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMPointRO point, int type) {
        super(editPart, viewManager, feedbackManager, point, type);
    }

    public HandlePointDiagonal(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMPointRO point, int type, int forceForce) {
        super(editPart, viewManager, feedbackManager, point, type, forceForce);
    }

    @Override
    public Command createHandleMoveCommand(RQDragNDropHandle request) {
        Point from = this.transformToPlanCoordinates(request.getFrom());
        Point to = this.transformToPlanCoordinates(request.getTo());
        GeoVector translation = new GeoVector(from, to);
        double absolutMovement = Math.min(Math.abs(translation.x), Math.abs(translation.y));
        double xMovement = translation.x < 0.0 ? absolutMovement * -1.0 : absolutMovement;
        double yMovement = translation.y < 0.0 ? absolutMovement * -1.0 : absolutMovement;
        translation = new GeoVector(xMovement, yMovement);
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        CMMovePoint returnCommand = new CMMovePoint(translation, this.getIPMPointRO(), pEPlanEditPart.getCommandContext());
        return returnCommand;
    }
}

