/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.CMCreatePlanElementStructureByShortcutHandle;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.commands.RQSelectionByClickHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.handles.AbstractHandle;
import com.arcway.planagent.planeditor.handles.HandlePointCreatePlanElementStructureStorage;
import com.arcway.planagent.planeditor.handles.HandleTemplate;
import com.arcway.planagent.planeditor.handles.IHandlePointWithImageAndToolTip;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithLineShapeOutlineRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOptionalShadowRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithPlaneOutlineAndNameSupplementRO;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.transactions.TAMovePoints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandlePointCreatePlanElementStructure
extends AbstractHandle
implements IHandlePointWithImageAndToolTip {
    private static final int DISTANCE_BETWEEN_PLANELEMENTS = 10;
    private static final ILogger logger = Logger.getLogger(HandlePointCreatePlanElementStructure.class);
    private final HandleTemplate template;
    private com.arcway.lib.geometry.Point whereToAnchor = null;
    private com.arcway.lib.geometry.Point position;
    private GeoVector offsetInPixels;
    private Direction direction;
    private final boolean allowMultipleAnchoringsForClickEvent;

    public HandlePointCreatePlanElementStructure(PEPlanElement editPart, EditMgr viewManager, FeedbackManager feedbackManager, HandleTemplate template, boolean allowMultipleAnchoringsForClickEvent) {
        super((EditPart)editPart, viewManager, feedbackManager, 3);
        assert (template != null) : "template object is null";
        this.template = template;
        this.allowMultipleAnchoringsForClickEvent = allowMultipleAnchoringsForClickEvent;
    }

    private PEPlanElement getPEPlanElement() {
        return (PEPlanElement)this.getEditPart();
    }

    @Override
    public int getCommandType(String requestType) {
        return Integer.MIN_VALUE;
    }

    @Override
    public Command getCommand(Request request) {
        CMCreatePlanElementStructureByShortcutHandle command;
        block15: {
            if (request instanceof RQSelectionByClickHandle || request instanceof RQDragNDropHandle) {
                if (this.whereToAnchor == null) {
                    this.whereToAnchor = this.findPointWhereToAnchor(this.direction);
                }
                boolean createCommand = false;
                if (request instanceof RQSelectionByClickHandle) {
                    List<IPMAnchoringRO> anchorings = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement((IPMPlanElementRO)this.getPEPlanElement().getPMPlanElement(), false);
                    int anchorCountAtWhereToAnchor = HandlePointCreatePlanElementStructure.getAnchorCountAtPoint(anchorings, this.whereToAnchor);
                    if (anchorCountAtWhereToAnchor > 0 && this.allowMultipleAnchoringsForClickEvent) {
                        com.arcway.lib.geometry.Point whereToAnchorTurned180;
                        int anchorCountAtWhereToAnchorTurned180;
                        if ((this.direction.equalsDirection(Direction.ANGLE_0) || this.direction.equalsDirection(Direction.ANGLE_180)) && anchorCountAtWhereToAnchor > (anchorCountAtWhereToAnchorTurned180 = HandlePointCreatePlanElementStructure.getAnchorCountAtPoint(anchorings, whereToAnchorTurned180 = this.findPointWhereToAnchor(this.direction.turn180())))) {
                            this.direction = this.direction.turn180();
                            this.whereToAnchor = whereToAnchorTurned180;
                        }
                        createCommand = true;
                    } else {
                        createCommand = anchorCountAtWhereToAnchor <= 0 || this.allowMultipleAnchoringsForClickEvent;
                    }
                } else {
                    createCommand = true;
                }
                if (createCommand) {
                    try {
                        List<IPMPointRO> pointsToAnchorInDuplicatedTemplate = this.template.duplicatePlanAndFindPointsToAnchor();
                        if (pointsToAnchorInDuplicatedTemplate.size() > 0) {
                            IPMPointRO pointToAnchorInDuplicatedTemplate = pointsToAnchorInDuplicatedTemplate.get(0);
                            IPMPlanRO templatePlan = pointToAnchorInDuplicatedTemplate.getPlanElementRO().getPlanRO();
                            this.adaptGeometryOfTemplatePlan(templatePlan);
                            GeoVector translation = new GeoVector(pointToAnchorInDuplicatedTemplate.getPosition(), this.whereToAnchor);
                            ArrayList<IPMPlanElementRO> peToMove = new ArrayList<IPMPlanElementRO>();
                            Rectangle peToMoveOuterBounds = HandlePointCreatePlanElementStructure.calculatePlanElementsToMoveOuterBounds(pointsToAnchorInDuplicatedTemplate, peToMove);
                            GeoVector distanceToDestinationInTargetPlan = this.getDistanceToDestinationInTargetPlan(request, translation, peToMoveOuterBounds);
                            boolean snap = true;
                            if (request instanceof RQSelectionByClickHandle) {
                                snap = false;
                            }
                            command = new CMCreatePlanElementStructureByShortcutHandle((IPMPlanRW)templatePlan, translation, this.getPEPlanElement().getPMPlanElement().getPlanRW(), Collections.emptyList(), null, this.getPEPlanElement().getCommandContext(), distanceToDestinationInTargetPlan, peToMove, snap);
                            break block15;
                        }
                        command = null;
                    }
                    catch (EXPlanCreationException e) {
                        logger.error("copy of plan structure template couldn't be created", (Throwable)e);
                        command = null;
                    }
                    catch (IllegalArgumentException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        command = null;
                    }
                } else {
                    command = null;
                }
            } else {
                command = null;
            }
        }
        return command;
    }

    private GeoVector getDistanceToDestinationInTargetPlan(Request request, GeoVector translation, Rectangle peToMoveOuterBounds) {
        com.arcway.lib.geometry.Point destinationInTargetPlanCoordinates;
        com.arcway.lib.geometry.Point peToMoveOuterCenter;
        assert (request instanceof RQSelectionByClickHandle || request instanceof RQDragNDropHandle) : "wrong request";
        if (request instanceof RQSelectionByClickHandle) {
            if (this.direction.equalsDirection(Direction.ANGLE_0)) {
                peToMoveOuterCenter = peToMoveOuterBounds != null ? (this.allowMultipleAnchoringsForClickEvent ? peToMoveOuterBounds.upperLeft : new com.arcway.lib.geometry.Point(peToMoveOuterBounds.upperLeft.x, peToMoveOuterBounds.center().y)) : com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)this.whereToAnchor);
                List<IPMAnchoringRO> anchoringsFromOutgoingEdges = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement((IPMPlanElementRO)this.getPEPlanElement().getPMPlanElement(), false);
                if (HandlePointCreatePlanElementStructure.getAnchorCountAtPoint(anchoringsFromOutgoingEdges, this.whereToAnchor) == 0) {
                    destinationInTargetPlanCoordinates = this.allowMultipleAnchoringsForClickEvent ? new com.arcway.lib.geometry.Point(this.whereToAnchor.x, this.whereToAnchor.y + (double)this.template.getStandardControlFlowLength()) : new com.arcway.lib.geometry.Point(this.whereToAnchor.x + (double)this.template.getStandardControlFlowLength() + 10.0, this.whereToAnchor.y);
                } else {
                    com.arcway.lib.geometry.Point furthestConnectedPoint = this.findFurthestConnectedPoint(anchoringsFromOutgoingEdges);
                    destinationInTargetPlanCoordinates = furthestConnectedPoint.movePoint(new GeoVector(10.0, this.direction));
                }
            } else if (this.direction.equalsDirection(Direction.ANGLE_90)) {
                peToMoveOuterCenter = peToMoveOuterBounds != null ? new com.arcway.lib.geometry.Point(peToMoveOuterBounds.center().x, peToMoveOuterBounds.lowerRight.y) : com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)this.whereToAnchor);
                destinationInTargetPlanCoordinates = new com.arcway.lib.geometry.Point(this.whereToAnchor.x, this.whereToAnchor.y - (double)this.template.getStandardControlFlowLength());
            } else if (this.direction.equalsDirection(Direction.ANGLE_180)) {
                peToMoveOuterCenter = peToMoveOuterBounds != null ? new com.arcway.lib.geometry.Point(peToMoveOuterBounds.lowerRight.x, peToMoveOuterBounds.upperLeft.y) : com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)this.whereToAnchor);
                List<IPMAnchoringRO> anchoringsFromOutgoingEdges = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement((IPMPlanElementRO)this.getPEPlanElement().getPMPlanElement(), false);
                if (HandlePointCreatePlanElementStructure.getAnchorCountAtPoint(anchoringsFromOutgoingEdges, this.whereToAnchor) == 0) {
                    destinationInTargetPlanCoordinates = new com.arcway.lib.geometry.Point(this.whereToAnchor.x, this.whereToAnchor.y + (double)this.template.getStandardControlFlowLength());
                } else {
                    com.arcway.lib.geometry.Point furthestConnectedPoint = this.findFurthestConnectedPoint(anchoringsFromOutgoingEdges);
                    destinationInTargetPlanCoordinates = furthestConnectedPoint.movePoint(new GeoVector(10.0, this.direction));
                }
            } else {
                assert (this.direction.equalsDirection(Direction.ANGLE_270));
                peToMoveOuterCenter = peToMoveOuterBounds != null ? new com.arcway.lib.geometry.Point(peToMoveOuterBounds.center().x, peToMoveOuterBounds.upperLeft.y) : com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)this.whereToAnchor);
                destinationInTargetPlanCoordinates = new com.arcway.lib.geometry.Point(this.whereToAnchor.x, this.whereToAnchor.y + (double)this.template.getStandardControlFlowLength());
            }
        } else {
            assert (request instanceof RQDragNDropHandle);
            peToMoveOuterCenter = peToMoveOuterBounds != null ? peToMoveOuterBounds.center() : com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)this.whereToAnchor);
            RQDragNDropHandle requestDnD = (RQDragNDropHandle)request;
            Point mouseInScreenCoordinates = requestDnD.getTo();
            destinationInTargetPlanCoordinates = this.transformToPlanCoordinates(mouseInScreenCoordinates);
        }
        return GeoVector.sub((GeoVector)new GeoVector(peToMoveOuterCenter, destinationInTargetPlanCoordinates), (GeoVector)translation);
    }

    private com.arcway.lib.geometry.Point findFurthestConnectedPoint(List<IPMAnchoringRO> anchoringsFromOutgoingEdges) {
        assert (anchoringsFromOutgoingEdges != null && anchoringsFromOutgoingEdges.size() > 0) : "list of anchorings must not be empty";
        com.arcway.lib.geometry.Point furthestConnectedPoint = null;
        for (IPMAnchoringRO anchoringRO : anchoringsFromOutgoingEdges) {
            com.arcway.lib.geometry.Point newPoint;
            IPMFigureRO figureRO = anchoringRO.getAnchoringSource().getAnchoringFigure();
            IPMPointRO startPoint = figureRO.getPointListRO().getPointRO(0);
            IPMPointRO endPoint = figureRO.getPointListRO().getPointRO(figureRO.getPointListRO().getPointCount() - 1);
            IPMAnchoringPointRO anchoringRO2 = startPoint.getAnchoringRO();
            com.arcway.lib.geometry.Point potentialFurthestConnectedPoint = null;
            if (anchoringRO.equals(anchoringRO2)) {
                anchoringRO2 = endPoint.getAnchoringRO();
                if (anchoringRO2 == null) {
                    potentialFurthestConnectedPoint = endPoint.getPosition();
                }
            } else if (anchoringRO2 == null) {
                potentialFurthestConnectedPoint = startPoint.getPosition();
            }
            if (anchoringRO2 == null) {
                if (potentialFurthestConnectedPoint == null) continue;
                if (this.direction.equalsDirection(Direction.ANGLE_0)) {
                    if (furthestConnectedPoint != null && !(furthestConnectedPoint.x < potentialFurthestConnectedPoint.x)) continue;
                    furthestConnectedPoint = potentialFurthestConnectedPoint;
                    continue;
                }
                if (this.direction.equalsDirection(Direction.ANGLE_90)) {
                    if (furthestConnectedPoint != null && !(furthestConnectedPoint.y > potentialFurthestConnectedPoint.y)) continue;
                    furthestConnectedPoint = potentialFurthestConnectedPoint;
                    continue;
                }
                if (this.direction.equalsDirection(Direction.ANGLE_180)) {
                    if (furthestConnectedPoint != null && !(furthestConnectedPoint.x > potentialFurthestConnectedPoint.x)) continue;
                    furthestConnectedPoint = potentialFurthestConnectedPoint;
                    continue;
                }
                if (!this.direction.equalsDirection(Direction.ANGLE_270) || furthestConnectedPoint != null && !(furthestConnectedPoint.y < potentialFurthestConnectedPoint.y)) continue;
                furthestConnectedPoint = potentialFurthestConnectedPoint;
                continue;
            }
            IPMFigureRO figureRO2 = anchoringRO2.getAnchoringDestination().getAnchoringFigure();
            Rectangle rectangle = figureRO2.getPointListRO().getPoints().getBounds();
            if (this.direction.equalsDirection(Direction.ANGLE_0)) {
                newPoint = new com.arcway.lib.geometry.Point(rectangle.lowerRight.x, rectangle.upperLeft.y);
                if (furthestConnectedPoint != null && !(furthestConnectedPoint.x < newPoint.x)) continue;
                furthestConnectedPoint = newPoint;
                continue;
            }
            if (this.direction.equalsDirection(Direction.ANGLE_90)) {
                newPoint = new com.arcway.lib.geometry.Point(rectangle.center().x, rectangle.upperLeft.y);
                if (furthestConnectedPoint != null && !(furthestConnectedPoint.y > newPoint.y)) continue;
                furthestConnectedPoint = newPoint;
                continue;
            }
            if (this.direction.equalsDirection(Direction.ANGLE_180)) {
                newPoint = com.arcway.lib.geometry.Point.getAsPoint((com.arcway.lib.geometry.Point)rectangle.upperLeft);
                if (furthestConnectedPoint != null && !(furthestConnectedPoint.x > newPoint.x)) continue;
                furthestConnectedPoint = newPoint;
                continue;
            }
            if (!this.direction.equalsDirection(Direction.ANGLE_270)) continue;
            newPoint = new com.arcway.lib.geometry.Point(rectangle.center().x, rectangle.lowerRight.y);
            if (furthestConnectedPoint != null && !(furthestConnectedPoint.y < newPoint.y)) continue;
            furthestConnectedPoint = newPoint;
        }
        return furthestConnectedPoint;
    }

    private void adaptGeometryOfTemplatePlan(IPMPlanRO templatePlan) {
        Rectangle sourceOutline;
        HashMap<IPMPointRW, GeoVector> geometryAdaptations = new HashMap<IPMPointRW, GeoVector>();
        List<IPMPlanElementWithPlaneOutlineAndNameSupplementRO> geometryAdaptees = HandlePointCreatePlanElementStructure.getGeometryAdapteesFromTemplate(templatePlan);
        if (geometryAdaptees.size() == 1 && (sourceOutline = this.getRelevantOutline((IPMPlanElementRO)this.getPEPlanElement().getPMPlanElement())) != null) {
            for (IPMPlanElementWithPlaneOutlineAndNameSupplementRO adaptee : geometryAdaptees) {
                geometryAdaptations.putAll(HandlePointCreatePlanElementStructure.calculateGeometryAdaptations(sourceOutline, adaptee));
            }
            ActionParameters actionParameters = this.getEditDomain().getActionParameters();
            TAMovePoints geometryAdaptionTransaction = new TAMovePoints((IPMPlanRW)templatePlan, geometryAdaptations, actionParameters);
            if (geometryAdaptionTransaction.isValid()) {
                geometryAdaptionTransaction.dodo();
            }
        }
    }

    private static int getAnchorCountAtPoint(List<IPMAnchoringRO> anchorings, com.arcway.lib.geometry.Point point) {
        int anchorCount = 0;
        for (IPMAnchoringRO anchoring : anchorings) {
            IPMPointRO sourcePoint;
            IAnchoringSource source = anchoring.getAnchoringSource();
            if (!(source instanceof IPMPointRO) || !point.equalsPoint((sourcePoint = (IPMPointRO)source).getPosition())) continue;
            ++anchorCount;
        }
        return anchorCount;
    }

    private static List<IPMAnchoringRO> getAnchoringsFromPlanElement(IPMPlanElementRO planElement) {
        ArrayList<IPMAnchoringRO> listOfAllAnchoringsFromPlanElement = new ArrayList<IPMAnchoringRO>();
        int i = 0;
        while (i < planElement.getFigureCount()) {
            IPMFigureRO figure = planElement.getFigureRO(i);
            int j = 0;
            while (j < figure.getAnchoringCount()) {
                IPMAnchoringPointToFigureRO anchoringRO = figure.getAnchoringRO(j);
                listOfAllAnchoringsFromPlanElement.add((IPMAnchoringRO)anchoringRO);
                ++j;
            }
            if (figure instanceof IPMFigureLineShapeRO) {
                IPMPointListRO pointList = figure.getPointListRO();
                int j2 = 0;
                while (j2 < pointList.getPointCount()) {
                    IPMPointRO point = pointList.getPointRO(j2);
                    IPMAnchoringPointRO anchoringRO = point.getAnchoringRO();
                    if (anchoringRO != null) {
                        listOfAllAnchoringsFromPlanElement.add((IPMAnchoringRO)anchoringRO);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return listOfAllAnchoringsFromPlanElement;
    }

    private static List<IPMAnchoringRO> getAnchoringsFromPlanElement(IPMPlanElementRO planElement, boolean forIncomingEdges) {
        List<IPMAnchoringRO> listOfAllAnchoringsFromPlanElement = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement(planElement);
        ArrayList<IPMAnchoringRO> anchoringsFromOutgoingEdges = new ArrayList<IPMAnchoringRO>();
        anchoringsFromOutgoingEdges.addAll(listOfAllAnchoringsFromPlanElement);
        ArrayList<IPMAnchoringRO> anchoringsFromIncomingEdges = new ArrayList<IPMAnchoringRO>();
        for (IPMAnchoringRO anchoring : listOfAllAnchoringsFromPlanElement) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (figure.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO) {
                IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)figure.getPlanElementRO()).getOutlineFigureLineShapeRO();
                IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
                IPMPointListRO edgePoints = edge.getPointListRO();
                IPMPointRO startPoint = edgePoints.getPointRO(0);
                IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
                if (startPoint.equals(anchorPoint) && (edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle().getType() == 3 || edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle().getType() == 2)) {
                    anchoringsFromIncomingEdges.add(anchoring);
                    anchoringsFromOutgoingEdges.remove(anchoring);
                    continue;
                }
                if (!endPoint.equals(anchorPoint) || edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle().getType() != 3 && edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle().getType() != 2) continue;
                anchoringsFromIncomingEdges.add(anchoring);
                anchoringsFromOutgoingEdges.remove(anchoring);
                continue;
            }
            anchoringsFromOutgoingEdges.remove(anchoring);
        }
        if (forIncomingEdges) {
            return anchoringsFromIncomingEdges;
        }
        return anchoringsFromOutgoingEdges;
    }

    private static Rectangle calculatePlanElementsToMoveOuterBounds(List<IPMPointRO> pointsToAnchorInDuplicatedTemplate, List<IPMPlanElementRO> peToMove) {
        HashSet<IPMPlanElementRO> anchoringControlFlows = new HashSet<IPMPlanElementRO>();
        IPMPlanRO templatePlan = pointsToAnchorInDuplicatedTemplate.get(0).getPlanElementRO().getPlanRO();
        for (IPMPointRO point : pointsToAnchorInDuplicatedTemplate) {
            anchoringControlFlows.add(point.getPlanElementRO());
        }
        Rectangle peToMoveOuterBounds = null;
        int i = 0;
        while (i < templatePlan.getPlanElementCount()) {
            IPMPlanElementRO pe = templatePlan.getPlanElementRO(i);
            if (!anchoringControlFlows.contains(pe)) {
                peToMove.add(pe);
                Rectangle outerbounds = pe.calculatePointUnion();
                if (outerbounds != null) {
                    peToMoveOuterBounds = peToMoveOuterBounds == null ? outerbounds : peToMoveOuterBounds.union(outerbounds);
                }
            }
            ++i;
        }
        return peToMoveOuterBounds;
    }

    private static Map<IPMPointRW, GeoVector> calculateGeometryAdaptations(Rectangle sourceBounds, IPMPlanElementWithPlaneOutlineAndNameSupplementRO adaptee) {
        Dimension sourceDimension;
        IPMFigureRO adapteeFigure = adaptee.getOutlineFigureRO();
        HashMap<IPMPointRW, GeoVector> adaptations = new HashMap<IPMPointRW, GeoVector>();
        IPMPointListRO adapteePointList = adapteeFigure.getPointListRO();
        Rectangle adapteeBounds = adapteePointList.getPoints().getBounds();
        Dimension adapteeDimension = new Dimension(adapteeBounds.w(), adapteeBounds.h());
        if (!adapteeDimension.equalsDimension(sourceDimension = new Dimension(sourceBounds.w(), sourceBounds.h()))) {
            HashSet<Integer> listOfDirectionsInWhichTheAnchoringEdgesLie = new HashSet<Integer>();
            List<IPMAnchoringRO> anchorings = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement((IPMPlanElementRO)adaptee);
            for (IPMAnchoringRO anchoringRO : anchorings) {
                IPMAnchoringPointToFigureRO anchoringPointToFigure = (IPMAnchoringPointToFigureRO)anchoringRO;
                IAnchoringSourcePoint anchoringSourcePoint = anchoringPointToFigure.getAnchoringSourcePoint();
                com.arcway.lib.geometry.Point anchoringPoint = anchoringSourcePoint.getAnchoringSourcePosition();
                IPMPointListRO anchoringEdgePointList = anchoringSourcePoint.getAnchoringFigure().getPointListRO();
                com.arcway.lib.geometry.Point neighbourPoint = null;
                int i = anchoringEdgePointList.getFirstPointIndex((IPMPointRO)anchoringSourcePoint);
                neighbourPoint = anchoringSourcePoint.equals(anchoringEdgePointList.getPointRO(0)) ? anchoringEdgePointList.getPointRO(i + 1).getPosition() : anchoringEdgePointList.getPointRO(i - 1).getPosition();
                GeoVector vector = new GeoVector(anchoringPoint, neighbourPoint);
                Direction directionInWhichTheAnchoringEdgeLies = vector.getDirection();
                if (directionInWhichTheAnchoringEdgeLies.equalsDirection(Direction.ANGLE_0)) {
                    listOfDirectionsInWhichTheAnchoringEdgesLie.add(0);
                    continue;
                }
                if (directionInWhichTheAnchoringEdgeLies.equalsDirection(Direction.ANGLE_90)) {
                    listOfDirectionsInWhichTheAnchoringEdgesLie.add(90);
                    continue;
                }
                if (directionInWhichTheAnchoringEdgeLies.equalsDirection(Direction.ANGLE_180)) {
                    listOfDirectionsInWhichTheAnchoringEdgesLie.add(180);
                    continue;
                }
                if (!directionInWhichTheAnchoringEdgeLies.equalsDirection(Direction.ANGLE_270)) continue;
                listOfDirectionsInWhichTheAnchoringEdgesLie.add(270);
            }
            if (listOfDirectionsInWhichTheAnchoringEdgesLie.size() == 1) {
                com.arcway.lib.geometry.Point ur;
                com.arcway.lib.geometry.Point sourceLR;
                com.arcway.lib.geometry.Point lr;
                IPMPointRO point;
                com.arcway.lib.geometry.Point sourceUL;
                com.arcway.lib.geometry.Point ll;
                com.arcway.lib.geometry.Point ul;
                IPMPointRW point1 = null;
                IPMPointRW point2 = null;
                GeoVector point1Translation = null;
                GeoVector point2Translation = null;
                if (listOfDirectionsInWhichTheAnchoringEdgesLie.contains(0)) {
                    ul = adapteeBounds.upperLeft;
                    ll = new com.arcway.lib.geometry.Point(adapteeBounds.upperLeft.x, adapteeBounds.lowerRight.y);
                    sourceUL = sourceBounds.upperLeft;
                    com.arcway.lib.geometry.Point sourceLL = new com.arcway.lib.geometry.Point(sourceBounds.upperLeft.x, sourceBounds.lowerRight.y);
                    int i = 0;
                    while (i < adapteePointList.getPointCount()) {
                        point = adapteePointList.getPointRO(i);
                        com.arcway.lib.geometry.Point pointPos = point.getPosition();
                        if (pointPos.equalsPoint(ul)) {
                            point1 = (IPMPointRW)point;
                        } else if (pointPos.equalsPoint(ll)) {
                            point2 = (IPMPointRW)point;
                        }
                        ++i;
                    }
                    if (point1 == null || point2 == null) {
                        return Collections.emptyMap();
                    }
                    com.arcway.lib.geometry.Point rightCenter = new com.arcway.lib.geometry.Point(adapteeBounds.lowerRight.x, adapteeBounds.center().y);
                    com.arcway.lib.geometry.Point sourceRightCenter = new com.arcway.lib.geometry.Point(sourceBounds.lowerRight.x, sourceBounds.center().y);
                    adapteeBounds = adapteeBounds.move(new GeoVector(rightCenter, sourceRightCenter));
                    ul = adapteeBounds.upperLeft;
                    ll = new com.arcway.lib.geometry.Point(adapteeBounds.upperLeft.x, adapteeBounds.lowerRight.y);
                    ll = ll.movePoint(new GeoVector(ul, new com.arcway.lib.geometry.Point(sourceUL.x, ul.y)));
                    point1Translation = new GeoVector(ul, sourceUL);
                    point2Translation = new GeoVector(ll, sourceLL);
                } else if (listOfDirectionsInWhichTheAnchoringEdgesLie.contains(90)) {
                    lr = adapteeBounds.lowerRight;
                    ll = new com.arcway.lib.geometry.Point(adapteeBounds.upperLeft.x, adapteeBounds.lowerRight.y);
                    sourceLR = sourceBounds.lowerRight;
                    com.arcway.lib.geometry.Point sourceLL = new com.arcway.lib.geometry.Point(sourceBounds.upperLeft.x, sourceBounds.lowerRight.y);
                    int i = 0;
                    while (i < adapteePointList.getPointCount()) {
                        point = adapteePointList.getPointRO(i);
                        com.arcway.lib.geometry.Point pointPos = point.getPosition();
                        if (pointPos.equalsPoint(ll)) {
                            point1 = (IPMPointRW)point;
                        } else if (pointPos.equalsPoint(lr)) {
                            point2 = (IPMPointRW)point;
                        }
                        ++i;
                    }
                    if (point1 == null || point2 == null) {
                        return Collections.emptyMap();
                    }
                    com.arcway.lib.geometry.Point upperCenter = new com.arcway.lib.geometry.Point(adapteeBounds.center().x, adapteeBounds.upperLeft.y);
                    com.arcway.lib.geometry.Point sourceUpperCenter = new com.arcway.lib.geometry.Point(sourceBounds.center().x, sourceBounds.upperLeft.y);
                    adapteeBounds = adapteeBounds.move(new GeoVector(upperCenter, sourceUpperCenter));
                    lr = adapteeBounds.lowerRight;
                    ll = new com.arcway.lib.geometry.Point(adapteeBounds.upperLeft.x, adapteeBounds.lowerRight.y);
                    lr = lr.movePoint(new GeoVector(ll, new com.arcway.lib.geometry.Point(ll.x, sourceLL.y)));
                    point1Translation = new GeoVector(ll, sourceLL);
                    point2Translation = new GeoVector(lr, sourceLR);
                } else if (listOfDirectionsInWhichTheAnchoringEdgesLie.contains(180)) {
                    lr = adapteeBounds.lowerRight;
                    ur = new com.arcway.lib.geometry.Point(adapteeBounds.lowerRight.x, adapteeBounds.upperLeft.y);
                    sourceLR = sourceBounds.lowerRight;
                    com.arcway.lib.geometry.Point sourceUR = new com.arcway.lib.geometry.Point(sourceBounds.lowerRight.x, sourceBounds.upperLeft.y);
                    int i = 0;
                    while (i < adapteePointList.getPointCount()) {
                        point = adapteePointList.getPointRO(i);
                        com.arcway.lib.geometry.Point pointPos = point.getPosition();
                        if (pointPos.equalsPoint(ur)) {
                            point1 = (IPMPointRW)point;
                        } else if (pointPos.equalsPoint(lr)) {
                            point2 = (IPMPointRW)point;
                        }
                        ++i;
                    }
                    if (point1 == null || point2 == null) {
                        return Collections.emptyMap();
                    }
                    com.arcway.lib.geometry.Point leftCenter = new com.arcway.lib.geometry.Point(adapteeBounds.upperLeft.x, adapteeBounds.center().y);
                    com.arcway.lib.geometry.Point sourceLeftCenter = new com.arcway.lib.geometry.Point(sourceBounds.upperLeft.x, sourceBounds.center().y);
                    adapteeBounds = adapteeBounds.move(new GeoVector(leftCenter, sourceLeftCenter));
                    lr = adapteeBounds.lowerRight;
                    ur = new com.arcway.lib.geometry.Point(adapteeBounds.lowerRight.x, adapteeBounds.upperLeft.y);
                    lr = lr.movePoint(new GeoVector(ur, new com.arcway.lib.geometry.Point(sourceUR.x, ur.y)));
                    point1Translation = new GeoVector(ur, sourceUR);
                    point2Translation = new GeoVector(lr, sourceLR);
                } else if (listOfDirectionsInWhichTheAnchoringEdgesLie.contains(270)) {
                    ul = adapteeBounds.upperLeft;
                    ur = new com.arcway.lib.geometry.Point(adapteeBounds.lowerRight.x, adapteeBounds.upperLeft.y);
                    sourceUL = sourceBounds.upperLeft;
                    com.arcway.lib.geometry.Point sourceUR = new com.arcway.lib.geometry.Point(sourceBounds.lowerRight.x, sourceBounds.upperLeft.y);
                    int i = 0;
                    while (i < adapteePointList.getPointCount()) {
                        point = adapteePointList.getPointRO(i);
                        com.arcway.lib.geometry.Point pointPos = point.getPosition();
                        if (pointPos.equalsPoint(ul)) {
                            point1 = (IPMPointRW)point;
                        } else if (pointPos.equalsPoint(ur)) {
                            point2 = (IPMPointRW)point;
                        }
                        ++i;
                    }
                    if (point1 == null || point2 == null) {
                        return Collections.emptyMap();
                    }
                    com.arcway.lib.geometry.Point lowerCenter = new com.arcway.lib.geometry.Point(adapteeBounds.center().x, adapteeBounds.lowerRight.y);
                    com.arcway.lib.geometry.Point sourceLowerCenter = new com.arcway.lib.geometry.Point(sourceBounds.center().x, sourceBounds.lowerRight.y);
                    adapteeBounds = adapteeBounds.move(new GeoVector(lowerCenter, sourceLowerCenter));
                    ul = adapteeBounds.upperLeft;
                    ur = new com.arcway.lib.geometry.Point(adapteeBounds.lowerRight.x, adapteeBounds.upperLeft.y);
                    ur = ur.movePoint(new GeoVector(ul, new com.arcway.lib.geometry.Point(ul.x, sourceUL.y)));
                    point1Translation = new GeoVector(ul, sourceUL);
                    point2Translation = new GeoVector(ur, sourceUR);
                }
                adaptations.put(point1, point1Translation);
                adaptations.put(point2, point2Translation);
            }
        }
        return adaptations;
    }

    private Rectangle getRelevantOutline(IPMPlanElementRO planElement) {
        HandlePointCreatePlanElementStructureStorage storage = new HandlePointCreatePlanElementStructureStorage();
        return this.getRelevantOutline(planElement, -1, null, storage);
    }

    private Rectangle getRelevantOutline(IPMPlanElementRO planElement, int currentDepth, Rectangle nearestRelevantOutline, HandlePointCreatePlanElementStructureStorage storage) {
        IPMPlanElementWithPlaneOutlineAndNameSupplementRO relevantPlanElement;
        int newCurrentDepth = currentDepth + 1;
        if (storage.getMinimalDepth() != -1 && newCurrentDepth >= storage.getMinimalDepth()) {
            return nearestRelevantOutline;
        }
        if (planElement instanceof IPMPlanElementWithPlaneOutlineAndNameSupplementRO && (relevantPlanElement = (IPMPlanElementWithPlaneOutlineAndNameSupplementRO)planElement).hasRelevantGeometryAdaption()) {
            if (relevantPlanElement instanceof IPMPlanElementWithOptionalShadowRO) {
                IPMPlanElementWithOptionalShadowRO planElementWithOptionalShadow = (IPMPlanElementWithOptionalShadowRO)relevantPlanElement;
                if (planElementWithOptionalShadow.getShadowFigures().equals(Collections.emptyList())) {
                    PMFigure outlineFigure = (PMFigure)relevantPlanElement.getOutlineFigureRO();
                    storage.setMinimalDepth(newCurrentDepth);
                    return outlineFigure.getPointUnionWithoutChildren();
                }
            } else {
                PMFigure outlineFigure = (PMFigure)relevantPlanElement.getOutlineFigureRO();
                storage.setMinimalDepth(newCurrentDepth);
                return outlineFigure.getPointUnionWithoutChildren();
            }
        }
        Rectangle relevantOutline = nearestRelevantOutline;
        List<IPMAnchoringRO> anchorings = HandlePointCreatePlanElementStructure.getAnchoringsFromPlanElement(planElement, true);
        int i = 0;
        while (i < anchorings.size()) {
            IPMAnchoringRO arcAnchoring = anchorings.get(i++);
            IPMPlanElementRO anchoringControlFlow = arcAnchoring.getAnchoringSource().getAnchoringFigure().getPlanElementRO();
            IPMAnchoringPointRO rootAnchoring = null;
            int j = 0;
            while (j < anchoringControlFlow.getFigureCount()) {
                IPMFigureRO figure = anchoringControlFlow.getFigureRO(j);
                IPMPointListRO pointList = figure.getPointListRO();
                int k = 0;
                while (k < pointList.getPointCount()) {
                    IPMPointRO point = pointList.getPointRO(k);
                    IPMAnchoringPointRO anchoringRO = point.getAnchoringRO();
                    if (anchoringRO != null && !anchoringRO.equals(arcAnchoring)) {
                        rootAnchoring = anchoringRO;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            if (rootAnchoring == null) continue;
            IPMPlanElementRO alternativeSource = rootAnchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
            relevantOutline = this.getRelevantOutline(alternativeSource, newCurrentDepth, relevantOutline, storage);
        }
        return relevantOutline;
    }

    private static List<IPMPlanElementWithPlaneOutlineAndNameSupplementRO> getGeometryAdapteesFromTemplate(IPMPlanRO templatePlan) {
        ArrayList<IPMPlanElementWithPlaneOutlineAndNameSupplementRO> adaptees = new ArrayList<IPMPlanElementWithPlaneOutlineAndNameSupplementRO>();
        int i = 0;
        while (i < templatePlan.getPlanElementCount()) {
            IPMPlanElementWithPlaneOutlineAndNameSupplementRO pe;
            IPMPlanElementRO potentialAdaptee = templatePlan.getPlanElementRO(i);
            if (potentialAdaptee instanceof IPMPlanElementWithPlaneOutlineAndNameSupplementRO && (pe = (IPMPlanElementWithPlaneOutlineAndNameSupplementRO)potentialAdaptee).hasRelevantGeometryAdaption()) {
                adaptees.add(pe);
            }
            ++i;
        }
        return adaptees;
    }

    private com.arcway.lib.geometry.Point findPointWhereToAnchor(Direction dir) {
        PMPlanElement targetPlanElement = this.getPEPlanElement().getPMPlanElement();
        Line anchorLine = null;
        com.arcway.lib.geometry.Point tmpWhereToAnchor = null;
        int i = 0;
        while (i < targetPlanElement.getFigureCount()) {
            IPMFigureRO figure = targetPlanElement.getFigureRO(i);
            IPMPointListRO pointList = figure.getPointListRO();
            int j = 0;
            while (j < pointList.getLineCount()) {
                IPMLineRO planLine = pointList.getLineRO(j);
                Line line = new Line(planLine.getPoint1stRO().getPosition(), planLine.getPoint2ndRO().getPosition());
                if (!line.isZeroLengthLine()) {
                    com.arcway.lib.geometry.Point potentialAnchorPoint = line.getCenter();
                    if (tmpWhereToAnchor == null || dir.equalsDirection(Direction.ANGLE_0) && tmpWhereToAnchor.x < potentialAnchorPoint.x || dir.equalsDirection(Direction.ANGLE_90) && tmpWhereToAnchor.y > potentialAnchorPoint.y || dir.equalsDirection(Direction.ANGLE_180) && tmpWhereToAnchor.x > potentialAnchorPoint.x || dir.equalsDirection(Direction.ANGLE_270) && tmpWhereToAnchor.y < potentialAnchorPoint.y) {
                        tmpWhereToAnchor = potentialAnchorPoint;
                        anchorLine = line;
                    } else if (dir.equalsDirection(Direction.ANGLE_0) && tmpWhereToAnchor.x == potentialAnchorPoint.x || dir.equalsDirection(Direction.ANGLE_90) && tmpWhereToAnchor.y == potentialAnchorPoint.y || dir.equalsDirection(Direction.ANGLE_180) && tmpWhereToAnchor.x == potentialAnchorPoint.x || dir.equalsDirection(Direction.ANGLE_270) && tmpWhereToAnchor.y == potentialAnchorPoint.y) {
                        if (anchorLine != null && line.arcLength() > anchorLine.arcLength()) {
                            tmpWhereToAnchor = potentialAnchorPoint;
                            anchorLine = line;
                        } else if (anchorLine != null && line.arcLength() == anchorLine.arcLength() && (potentialAnchorPoint.x > tmpWhereToAnchor.x || potentialAnchorPoint.y > tmpWhereToAnchor.y)) {
                            tmpWhereToAnchor = potentialAnchorPoint;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return tmpWhereToAnchor;
    }

    @Override
    public com.arcway.lib.geometry.Point getPosition() {
        return this.position;
    }

    @Override
    public GeoVector getOffsetInPixels() {
        return this.offsetInPixels;
    }

    @Override
    public GeoVector getDirection() {
        return null;
    }

    void setPosition(com.arcway.lib.geometry.Point position, GeoVector offsetInPixels) {
        this.position = position;
        this.offsetInPixels = offsetInPixels;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public IOffscreenBitmap getImage() {
        return this.template.getImage();
    }

    @Override
    public Label getToolTip() {
        return this.template.getToolTip();
    }
}

