/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Sector;
import com.arcway.planagent.planeditor.commands.CMDeleteEndHandle;
import com.arcway.planagent.planeditor.commands.CMDeleteForcedCornerHandle;
import com.arcway.planagent.planeditor.commands.CMDeleteUnforcedCornerHandle;
import com.arcway.planagent.planeditor.commands.CMDuplicateEndHandle;
import com.arcway.planagent.planeditor.commands.CMDuplicateForcedCornerHandle;
import com.arcway.planagent.planeditor.commands.CMDuplicateUnforcedCornerHandle;
import com.arcway.planagent.planeditor.commands.CMMovePoint;
import com.arcway.planagent.planeditor.commands.RQDelete;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.handles.HandlePointNOP;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandlePoint
extends HandlePointNOP {
    private final Integer forceForce;

    public HandlePoint(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMPointRO point, int type) {
        super(editPart, viewManager, feedbackManager, point, type);
        this.forceForce = null;
    }

    public HandlePoint(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMPointRO point, int type, int forceForce) {
        super(editPart, viewManager, feedbackManager, point, type);
        this.forceForce = forceForce;
    }

    @Override
    public Command getCommand(Request request) {
        Command returnCommand = null;
        if (request instanceof RQDragNDropHandle) {
            returnCommand = !((RQDragNDropHandle)request).getCopy() ? this.createHandleMoveCommand((RQDragNDropHandle)request) : this.createHandleCopyCommand(request);
        } else if (request instanceof RQDelete) {
            returnCommand = this.createDeletePointCommand();
        }
        return returnCommand;
    }

    private Command createDeletePointCommand() {
        Command returnCommand = null;
        IPMLineRO firstLine = this.getIPMPointRO().getLine1stRO();
        IPMLineRO secondLine = this.getIPMPointRO().getLine2ndRO();
        if (this.getIPMPointRO().getPlanObjectRO() instanceof IPMFigureRO) {
            if (firstLine != null && secondLine != null) {
                returnCommand = firstLine.getForce() == 1 || secondLine.getForce() == 1 ? this.createHandleDeleteCommandForUnforcedCornerHandles() : this.createHandleDeleteCommandForForcedCornerHandles();
            } else if (firstLine != null || secondLine != null) {
                returnCommand = this.createHandleDeleteCommandForEndHandles();
            }
        }
        return returnCommand;
    }

    private Command createHandleDeleteCommandForUnforcedCornerHandles() {
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDeleteUnforcedCornerHandle(this.getIPMPointRO(), pEPlanEditPart.getCommandContext());
    }

    private Command createHandleDeleteCommandForForcedCornerHandles() {
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDeleteForcedCornerHandle(this.getIPMPointRO(), pEPlanEditPart.getCommandContext());
    }

    private Command createHandleDeleteCommandForEndHandles() {
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDeleteEndHandle(this.getIPMPointRO(), pEPlanEditPart.getCommandContext());
    }

    protected Command createHandleMoveCommand(RQDragNDropHandle request) {
        Point fromScreen = request.getFrom();
        Point toScreen = request.getTo();
        com.arcway.lib.geometry.Point from = this.transformToPlanCoordinates(fromScreen);
        com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
        GeoVector translation = new GeoVector(from, to);
        if (this.forceForce != null) {
            if (this.forceForce == 2) {
                translation = new GeoVector(translation.x, 0.0);
            } else if (this.forceForce == 3) {
                translation = new GeoVector(0.0, translation.y);
            }
        }
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        CMMovePoint returnCommand = new CMMovePoint(translation, this.getIPMPointRO(), pEPlanEditPart.getCommandContext());
        return returnCommand;
    }

    private Command createHandleCopyCommandForEndHandles(RQDragNDropHandle rq) {
        Point toScreen = rq.getTo();
        com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDuplicateEndHandle(this.getIPMPointRO(), to, pEPlanEditPart.getCommandContext());
    }

    private Command createHandleCopyCommandForForcedCornerHandles(RQDragNDropHandle rq) {
        IPMPointRO verticalPoint;
        IPMLineRO verticalLine;
        IPMPointRO horizontalPoint;
        IPMLineRO horizontalLine;
        Point toScreen = rq.getTo();
        com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
        IPMLineRO firstLine = this.getIPMPointRO().getLine1stRO();
        IPMLineRO secondLine = this.getIPMPointRO().getLine2ndRO();
        IPMPointRO firstPoint = firstLine.getPoint1stRO();
        IPMPointRO secondPoint = secondLine.getPoint2ndRO();
        IPMLineRO lineToSplit = null;
        IPMPointRO fixPoint = null;
        com.arcway.lib.geometry.Point newPosition = to;
        if (firstLine.getForce() == 2) {
            horizontalLine = firstLine;
            horizontalPoint = firstPoint;
            verticalLine = secondLine;
            verticalPoint = secondPoint;
        } else {
            horizontalLine = secondLine;
            horizontalPoint = secondPoint;
            verticalLine = firstLine;
            verticalPoint = firstPoint;
        }
        GeoVector vectorHorizontal = new GeoVector(this.getIPMPointRO().getPosition(), horizontalPoint.getPosition());
        GeoVector vectorVertical = new GeoVector(this.getIPMPointRO().getPosition(), verticalPoint.getPosition());
        if (vectorHorizontal.abs() < 1.0E-10 || vectorVertical.abs() < 1.0E-10) {
            return null;
        }
        GeoVector fourtyFive = GeoVector.add((GeoVector)vectorHorizontal.scaleToLength(1.0), (GeoVector)vectorVertical.scaleToLength(1.0)).turn180();
        GeoVector invHorizontal = vectorHorizontal.turn180();
        GeoVector invVertical = vectorVertical.turn180();
        Sector ninetyInside = new Sector(this.getIPMPointRO().getPosition(), vectorHorizontal.getDirection(), vectorVertical.getDirection());
        Sector backVertical = new Sector(this.getIPMPointRO().getPosition(), vectorVertical.getDirection(), invHorizontal.getDirection());
        Sector moreHorizontal = new Sector(this.getIPMPointRO().getPosition(), invHorizontal.getDirection(), fourtyFive.getDirection());
        Sector moreVertical = new Sector(this.getIPMPointRO().getPosition(), fourtyFive.getDirection(), invVertical.getDirection());
        Sector backHorizontal = new Sector(this.getIPMPointRO().getPosition(), invVertical.getDirection(), vectorHorizontal.getDirection());
        if (ninetyInside.isInside(newPosition)) {
            lineToSplit = horizontalLine;
            fixPoint = horizontalPoint;
        } else if (moreHorizontal.isInside(newPosition)) {
            lineToSplit = horizontalLine;
            fixPoint = this.getIPMPointRO();
        } else if (moreVertical.isInside(newPosition)) {
            lineToSplit = verticalLine;
            fixPoint = this.getIPMPointRO();
        } else if (backVertical.isInside(newPosition)) {
            lineToSplit = horizontalLine;
            fixPoint = horizontalPoint;
        } else if (backHorizontal.isInside(newPosition)) {
            lineToSplit = horizontalLine;
            fixPoint = horizontalPoint;
        } else assert (false) : " point is not in any of the sectors, but sectors should sum to 360\u00b0";
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDuplicateForcedCornerHandle(lineToSplit, fixPoint, newPosition, pEPlanEditPart.getCommandContext());
    }

    private Command createHandleCopyCommandForUnforcedCornerHandles(RQDragNDropHandle rq) {
        Point toScreen = rq.getTo();
        com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
        IPMLineRO lineToPass = null;
        IPMPointRO fixedPoint = null;
        com.arcway.lib.geometry.Point newPosition = to;
        IPMLineRO firstLine = this.getIPMPointRO().getLine1stRO();
        IPMLineRO secondLine = this.getIPMPointRO().getLine2ndRO();
        IPMPointRO firstPoint = firstLine.getPoint1stRO();
        IPMPointRO secondPoint = secondLine.getPoint2ndRO();
        GeoVector firstVector = new GeoVector(this.getIPMPointRO().getPosition(), firstPoint.getPosition());
        GeoVector secondVector = new GeoVector(this.getIPMPointRO().getPosition(), secondPoint.getPosition());
        if (Math.abs(firstVector.abs()) < 1.0E-10 || Math.abs(secondVector.abs()) < 1.0E-10) {
            return null;
        }
        GeoVector half = GeoVector.add((GeoVector)firstVector, (GeoVector)secondVector);
        Sector oneOne = new Sector(this.getIPMPointRO().getPosition(), firstVector.getDirection(), half.turn180().getDirection());
        Sector twoOne = new Sector(this.getIPMPointRO().getPosition(), half.turn180().getDirection(), secondVector.getDirection());
        Sector oneTwo = new Sector(this.getIPMPointRO().getPosition(), secondVector.getDirection(), half.getDirection());
        Sector twoTwo = new Sector(this.getIPMPointRO().getPosition(), half.getDirection(), firstVector.getDirection());
        if (oneTwo.isInside(newPosition) || twoOne.isInside(newPosition)) {
            lineToPass = secondLine;
            fixedPoint = secondPoint;
        } else if (oneOne.isInside(newPosition) || twoTwo.isInside(newPosition)) {
            lineToPass = firstLine;
            fixedPoint = firstPoint;
        } else assert (false) : " point is not in any of the sectors, but sectors should sum to 360\u00b0";
        PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
        return new CMDuplicateUnforcedCornerHandle(lineToPass, fixedPoint, newPosition, pEPlanEditPart.getCommandContext());
    }

    private Command createHandleCopyCommand(Request request) {
        Command returnCommand = null;
        if (this.getIPMPointRO().getPlanObjectRO() instanceof IPMFigureRO) {
            RQDragNDropHandle requestDnD = (RQDragNDropHandle)request;
            IPMLineRO firstLine = this.getIPMPointRO().getLine1stRO();
            IPMLineRO secondLine = this.getIPMPointRO().getLine2ndRO();
            if (firstLine != null && secondLine != null) {
                returnCommand = firstLine.getForce() == 1 || secondLine.getForce() == 1 ? this.createHandleCopyCommandForUnforcedCornerHandles(requestDnD) : this.createHandleCopyCommandForForcedCornerHandles(requestDnD);
            } else if (firstLine != null || secondLine != null) {
                returnCommand = this.createHandleCopyCommandForEndHandles(requestDnD);
            }
        }
        return returnCommand;
    }

    @Override
    public GeoVector getDirection() {
        return null;
    }

    @Override
    public int getCommandType(String requestType) {
        int commandType = 1;
        if ("drag handle".equals(requestType)) {
            commandType = 5;
            IPMLineRO line1st = this.getIPMPointRO().getLine1stRO();
            IPMLineRO line2nd = this.getIPMPointRO().getLine2ndRO();
            if (line1st != null && line2nd != null) {
                if (this.forceForce == null) {
                    int lineForce1st = line1st.getForce();
                    int lineForce2nd = line2nd.getForce();
                    if (lineForce1st != 1 && lineForce2nd != 1) {
                        com.arcway.lib.geometry.Point v1Start = this.getIPMPointRO().getPosition();
                        com.arcway.lib.geometry.Point v1End = line1st.getPoint1stRO().getPosition();
                        com.arcway.lib.geometry.Point v2Start = this.getIPMPointRO().getPosition();
                        com.arcway.lib.geometry.Point v2End = line2nd.getPoint2ndRO().getPosition();
                        if (GeoVector.getDistance((com.arcway.lib.geometry.Point)v1Start, (com.arcway.lib.geometry.Point)v1End) > 1.0E-10 && GeoVector.getDistance((com.arcway.lib.geometry.Point)v2Start, (com.arcway.lib.geometry.Point)v2End) > 1.0E-10) {
                            double angleSum = GeoVector.getDifferenceVectorAngle((com.arcway.lib.geometry.Point)v1Start, (com.arcway.lib.geometry.Point)v1End) + GeoVector.getDifferenceVectorAngle((com.arcway.lib.geometry.Point)v2Start, (com.arcway.lib.geometry.Point)v2End);
                            double angle = angleSum / 2.0;
                            if (90.0 < angle && angle < 180.0) {
                                commandType = 9;
                            } else if (0.0 < angle && angle < 90.0) {
                                commandType = 10;
                            } else if (-90.0 < angle && angle < 0.0) {
                                commandType = 9;
                            } else if (-180.0 < angle && angle < -90.0) {
                                commandType = 10;
                            }
                        }
                    }
                } else {
                    int lineForce = this.forceForce;
                    if (lineForce == 2) {
                        commandType = 7;
                    } else if (lineForce == 3) {
                        commandType = 8;
                    }
                }
            } else if (line1st != null || line2nd != null) {
                commandType = 5;
            }
        } else if ("copy handle".equals(requestType) && this.getIPMPointRO().getPlanObjectRO() instanceof IPMFigureRO) {
            commandType = 3;
        }
        return commandType;
    }
}

