/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.handles.AbstractHandle;
import com.arcway.planagent.planeditor.handles.IHandleOutline;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandleOutline
extends AbstractHandle
implements IHandleOutline {
    private final boolean closedDraw;
    private final Points pointList;

    public HandleOutline(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMPointListRO pointList, boolean closedDraw, int type) {
        this(editPart, viewManager, feedbackManager, pointList.getPoints(), closedDraw, type);
    }

    public HandleOutline(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, Points pointList, boolean closedDraw, int type) {
        super(editPart, viewManager, feedbackManager, type);
        assert (pointList != null) : "pointList is null";
        this.pointList = pointList;
        this.closedDraw = closedDraw;
    }

    @Override
    public Points getPosition() {
        return this.pointList;
    }

    @Override
    public boolean isClosedDraw() {
        return this.closedDraw;
    }

    @Override
    public Command getCommand(Request request) {
        Command cmd = null;
        if (request instanceof RQDragNDropHandle) {
            RQDragNDropHandle dndreq = (RQDragNDropHandle)request;
            Point fromScreen = dndreq.getFrom();
            Point toScreen = dndreq.getTo();
            com.arcway.lib.geometry.Point start = this.transformToPlanCoordinates(fromScreen);
            com.arcway.lib.geometry.Point end = this.transformToPlanCoordinates(toScreen);
            GeoVector translation = new GeoVector(start, end);
            List elements = dndreq.getElements();
            ICommandContext commandContext = ((PEPlanElement)this.getEditPart()).getCommandContext();
            cmd = IIUtilities.createCMMoveCommand(elements, translation, dndreq.getMoveChildrenAlso(), commandContext);
        }
        return cmd;
    }

    @Override
    public int getCommandType(String requestType) {
        int commandType = 1;
        if ("drag handle".equals(requestType)) {
            commandType = 5;
        }
        return commandType;
    }
}

