/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.commands.CMMoveLine;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.handles.HandleLineNOP;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandleLine
extends HandleLineNOP {
    private final Integer forceForce;

    public HandleLine(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMLineRO line, int type) {
        super(editPart, viewManager, feedbackManager, line, type);
        this.forceForce = null;
    }

    public HandleLine(EditPart editPart, EditMgr viewManager, FeedbackManager feedbackManager, IPMLineRO line, int type, int forceForce) {
        super(editPart, viewManager, feedbackManager, line, type);
        this.forceForce = forceForce;
    }

    @Override
    public Command getCommand(Request request) {
        if (request instanceof RQDragNDropHandle) {
            RQDragNDropHandle requestDnD = (RQDragNDropHandle)request;
            Point fromScreen = requestDnD.getFrom();
            Point toScreen = requestDnD.getTo();
            com.arcway.lib.geometry.Point from = this.transformToPlanCoordinates(fromScreen);
            com.arcway.lib.geometry.Point to = this.transformToPlanCoordinates(toScreen);
            GeoVector translation = new GeoVector(from, to);
            if (this.forceForce == null) {
                if (this.getIPMLineRO().getForce() == 2) {
                    translation = new GeoVector(0.0, translation.y);
                } else if (this.getIPMLineRO().getForce() == 3) {
                    translation = new GeoVector(translation.x, 0.0);
                }
            } else if (this.forceForce == 2) {
                translation = new GeoVector(0.0, translation.y);
            } else if (this.forceForce == 3) {
                translation = new GeoVector(translation.x, 0.0);
            }
            PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)this.getEditPart();
            return new CMMoveLine(translation, this.getIPMLineRO(), pEPlanEditPart.getCommandContext());
        }
        return null;
    }

    @Override
    public int getCommandType(String requestType) {
        int commandType = 1;
        if ("drag handle".equals(requestType)) {
            int force = this.forceForce == null ? this.getIPMLineRO().getForce() : this.forceForce.intValue();
            if (force == 1) {
                IPMLineRO line1st = this.getIPMLineRO().getPoint1stRO().getLine1stRO();
                IPMLineRO line2nd = this.getIPMLineRO().getPoint2ndRO().getLine2ndRO();
                if (line1st != null && line2nd != null && line1st.getForce() == line2nd.getForce()) {
                    switch (line1st.getForce()) {
                        case 2: {
                            force = 3;
                            break;
                        }
                        case 3: {
                            force = 2;
                        }
                    }
                }
            }
            switch (force) {
                case 2: {
                    commandType = 8;
                    break;
                }
                case 3: {
                    commandType = 7;
                    break;
                }
                default: {
                    commandType = 5;
                }
            }
        }
        return commandType;
    }
}

