/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.Utilities;
import com.arcway.planagent.planeditor.handles.IHandleFigureConstructionKit;
import de.plans.lib.util.Logger;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.editparts.LayerManager;

public abstract class AbstractHandleToggler
extends EditPartListener.Stub {
    private static final Logger logger = Logger.getLogger(AbstractHandleToggler.class);
    private final IHandleFigureConstructionKit constructionKit;
    private final HashMap handles = new HashMap();

    protected AbstractHandleToggler(IHandleFigureConstructionKit constructionKit) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("AbstractHandleToggler(IHandleFigureConstructionKit constructionKit = " + constructionKit + ") - start"));
        }
        assert (constructionKit != null) : "constructionKit is null";
        this.constructionKit = constructionKit;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"AbstractHandleToggler(IHandleFigureConstructionKit) - end");
        }
    }

    protected abstract boolean isItMyResponsbility();

    public void partActivated(EditPart editPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("partActivated(EditPart editPart = " + editPart + ") - start"));
        }
        this.selectedStateChanged(editPart);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"partActivated(EditPart) - end");
        }
    }

    public void partDeactivated(EditPart editPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("partDeactivated(EditPart editPart = " + editPart + ") - start"));
        }
        this.eraseExistingHandles(editPart);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"partDeactivated(EditPart) - end");
        }
    }

    public void selectedStateChanged(EditPart editPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("selectedStateChanged(EditPart editPart = " + editPart + ") - start"));
        }
        assert (editPart instanceof PEPlanEditPart) : "editPart is not a PEPlanEditPart";
        assert (editPart != null) : "editPart is null";
        if (!this.isItMyResponsbility()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"selectedStateChanged(EditPart) - end");
            }
            return;
        }
        this.eraseExistingHandles(editPart);
        if (editPart.getSelected() != 0) {
            IFigure handleLayer = this.getHandleLayer(editPart);
            PEPlanEditPart planEditPart = (PEPlanEditPart)editPart;
            List newHandles = this.constructionKit.createHandleFigures(planEditPart, this.getViewManager(planEditPart));
            this.addHandles(newHandles, handleLayer);
            this.handles.put(editPart, newHandles);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"selectedStateChanged(EditPart) - end");
        }
    }

    private void eraseExistingHandles(EditPart editPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("eraseExistingHandles(EditPart editPart = " + editPart + ") - start"));
        }
        List existingHandles = (List)this.handles.get(editPart);
        IFigure handleLayer = this.getHandleLayer(editPart);
        if (existingHandles != null) {
            this.removeHandles(existingHandles, handleLayer);
            existingHandles.clear();
        }
        this.handles.remove(editPart);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"eraseExistingHandles(EditPart) - end");
        }
    }

    private EditMgr getViewManager(PEPlanEditPart planEditPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getViewManager(PEPlanEditPart planEditPart = " + planEditPart + ") - start"));
        }
        assert (planEditPart != null) : "planEditPart is null";
        EditMgr returnViewMgr = ((PEPlan)Utilities.getEditPartAtLevel((EditPart)planEditPart, 0)).getViewMgr();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getViewManager(PEPlanEditPart) - end - return value = " + returnViewMgr));
        }
        return returnViewMgr;
    }

    private IFigure getHandleLayer(EditPart editPart) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getHandleLayer(EditPart editPart = " + editPart + ") - start"));
        }
        assert (editPart != null) : "editPart is null";
        IFigure returnIFigure = LayerManager.Helper.find((EditPart)editPart).getLayer((Object)"Handle Layer");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getHandleLayer(EditPart) - end - return value = " + returnIFigure));
        }
        return returnIFigure;
    }

    private void addHandles(List handles, IFigure layer) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addHandles(List handles = " + handles + ", IFigure layer = " + layer + ") - start"));
        }
        assert (handles != null) : "handles is null";
        assert (layer != null) : "layer is null";
        int i = 0;
        while (i < handles.size()) {
            layer.add((IFigure)handles.get(i));
            ++i;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"addHandles(List, IFigure) - end");
        }
    }

    private void removeHandles(List handles, IFigure layer) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("removeHandles(List handles = " + handles + ", IFigure layer = " + layer + ") - start"));
        }
        assert (handles != null) : "handles is null";
        assert (layer != null) : "layer is null";
        int i = 0;
        while (i < handles.size()) {
            layer.remove((IFigure)handles.get(i));
            ++i;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"removeHandles(List, IFigure) - end");
        }
    }
}

