/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.figures;

import com.arcway.planagent.planeditor.figures.PFViewFigure;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class PlanFigureLayoutManager
extends XYLayout {
    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = null;
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Rectangle r = this.getPreferredBounds(child);
            if (r != null && r.width == -1 && r.height == -1) {
                r = r.getResized(child.getPreferredSize());
            }
            if (rect == null) {
                rect = r;
                continue;
            }
            rect.union(r);
        }
        Dimension d = rect == null ? new Dimension() : rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public void layout(IFigure parent) {
        for (IFigure f : parent.getChildren()) {
            Rectangle bounds = this.getPreferredBounds(f);
            if (bounds == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize();
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            f.setBounds(bounds);
        }
    }

    private Rectangle getPreferredBounds(IFigure f) {
        Rectangle bounds = f instanceof PFViewFigure ? ((PFViewFigure)f).getOuterBoundsInDraw2DFigureCoordinates() : (Rectangle)this.getConstraint(f);
        return bounds;
    }
}

