/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.figures;

import com.arcway.lib.eclipse.gef.graphics.devicedrivers.DeviceDriverDraw2DGraphics;
import com.arcway.lib.eclipse.gef.graphics.devicedrivers.DeviceDriverDraw2DGraphicsFitter;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.planagent.planeditor.figures.PlanFigureLayoutManager;
import com.arcway.planagent.planeditor.handles.EXDontKnowHowToFixException;
import com.arcway.planagent.planeditor.pagebooks.overview.PATCHED_ScaledGraphics;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import de.plans.lib.util.Logger;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class PFViewFigure
extends Figure {
    private static final Logger logger = Logger.getLogger(PFViewFigure.class);
    private final PVPlanViewPart pVPlanViewPart;
    private boolean containsPointReturnsFalse = false;
    private static boolean exDontKnowHowToFix1Reported = false;
    private static boolean exDontKnowHowToFix2Reported = false;
    boolean flip = true;
    private static boolean exDontKnowHowToFix3Reported = false;

    public PFViewFigure(PVPlanViewPart pVPlanViewPart) {
        this.pVPlanViewPart = pVPlanViewPart;
    }

    protected void initialize() {
        this.setBorder((Border)new MarginBorder(-this.getHitTestingToleranceInDraw2DFigureCoordinates()));
        this.setLayoutManager((LayoutManager)new PlanFigureLayoutManager());
    }

    public PVPlanViewPart getPVPlanViewPart() {
        return this.pVPlanViewPart;
    }

    public void setContainsPointReturnsFalse(boolean b) {
        this.containsPointReturnsFalse = b;
    }

    public boolean containsPointReturnsFalse() {
        return this.containsPointReturnsFalse;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dimensionDraw2D;
        try {
            Rectangle boundsDraw2D = this.getOuterBoundsInDraw2DFigureCoordinates();
            dimensionDraw2D = new Dimension(boundsDraw2D.width, boundsDraw2D.height);
        }
        catch (EXDontKnowHowToFixException e) {
            if (!exDontKnowHowToFix1Reported) {
                logger.error((Object)"Exeption while PFViewFigure.getPreferredSize()", (Throwable)e);
                exDontKnowHowToFix1Reported = true;
            }
            dimensionDraw2D = null;
        }
        catch (Exception e) {
            logger.error((Object)"Exeption while PFViewFigure.getPreferredSize()", (Throwable)e);
            dimensionDraw2D = null;
        }
        return dimensionDraw2D;
    }

    public Rectangle getOuterBoundsInDraw2DFigureCoordinates() {
        return this.transformCanvas2Draw2DFigure(this.getOuterBoundsInCanvasCoordinates());
    }

    public com.arcway.lib.geometry.Rectangle getOuterBoundsInFigureCoordinates() {
        com.arcway.lib.geometry.Rectangle outerBoundsInCanvasCoordinates = this.getOuterBoundsInCanvasCoordinates();
        com.arcway.lib.geometry.Rectangle outerBoundsInFigureCoordinates = outerBoundsInCanvasCoordinates == null ? null : outerBoundsInCanvasCoordinates.transform(this.getTransformationCanvas2Draw2DFigure());
        return outerBoundsInFigureCoordinates;
    }

    protected com.arcway.lib.geometry.Rectangle getOuterBoundsInCanvasCoordinates() {
        com.arcway.lib.geometry.Rectangle thisBounds = this.getPVPlanViewPart().getOuterBoundsWithoutChildren();
        for (PFViewFigure child : this.getChildren()) {
            com.arcway.lib.geometry.Rectangle childBounds = child.getOuterBoundsInCanvasCoordinates();
            thisBounds = thisBounds == null ? childBounds : thisBounds.union(childBounds);
        }
        return thisBounds;
    }

    public boolean containsPoint(int x, int y) {
        boolean contains;
        try {
            if (this.containsPointReturnsFalse) {
                contains = false;
            } else {
                Rectangle boundsCopy = this.getBounds().getCopy();
                if (this.getBorder() != null) {
                    Insets insets = this.getBorder().getInsets((IFigure)this);
                    boundsCopy.crop(insets);
                }
                if (boundsCopy.contains(x, y)) {
                    TreeSearch search;
                    IFigure figure;
                    Point upperLeftView = this.transformDraw2DFigure2Canvas(x, y);
                    Point lowerRightView = this.transformDraw2DFigure2Canvas(x + 1, y + 1);
                    double tolerance = this.getHitTestingToleranceInCanvasCoordinates();
                    contains = this.getPVPlanViewPart().isInside(upperLeftView, tolerance) ? true : (this.getPVPlanViewPart().isInside(lowerRightView, tolerance) ? true : (figure = this.findDescendantAtExcluding(x, y, search = IdentitySearch.INSTANCE)) != null);
                } else {
                    contains = false;
                }
            }
        }
        catch (EXDontKnowHowToFixException e) {
            if (!exDontKnowHowToFix2Reported) {
                logger.error((Object)"Exeption while PFViewFigure.contains()", (Throwable)e);
                exDontKnowHowToFix2Reported = true;
            }
            contains = false;
        }
        catch (Exception e) {
            logger.error((Object)"Exeption while PFViewFigure.contains()", (Throwable)e);
            contains = false;
        }
        return contains;
    }

    protected void paintFigure(Graphics g) {
        try {
            if (g instanceof PATCHED_ScaledGraphics) {
                PATCHED_ScaledGraphics scaledGraphics = (PATCHED_ScaledGraphics)g;
                Graphics targetGraphics = scaledGraphics.graphics;
                double zoom = scaledGraphics.zoom;
                GeoVector translationAfterZoom = new GeoVector(scaledGraphics.fractionalX, scaledGraphics.fractionalY);
                targetGraphics.pushState();
                DeviceDriverDraw2DGraphics driver = new DeviceDriverDraw2DGraphics(targetGraphics);
                Transformation targetTrafo = this.getTransformationCanvas2Draw2DFigure();
                targetTrafo = targetTrafo.transform((Transformation)TransformationAffiliate.newTransformationScaling((double)zoom));
                targetTrafo = targetTrafo.transform((Transformation)TransformationAffiliate.newTransformationTranslation((GeoVector)translationAfterZoom));
                Device device = new Device((IDeviceDriver)driver, targetTrafo);
                this.getPVPlanViewPart().drawFigure(device);
                driver.dispose();
                targetGraphics.popState();
            } else {
                DeviceDriverDraw2DGraphics driver = new DeviceDriverDraw2DGraphics(g);
                Device device = new Device((IDeviceDriver)driver, this.getTransformationCanvas2Draw2DFigure());
                this.getPVPlanViewPart().drawFigure(device);
                driver.dispose();
            }
        }
        catch (EXDontKnowHowToFixException e) {
            if (!exDontKnowHowToFix3Reported) {
                logger.error((Object)"Exeption while PFViewFigure.paint()", (Throwable)e);
                exDontKnowHowToFix3Reported = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exeption while PFViewFigure.paint()", (Throwable)e);
        }
    }

    protected abstract double getHitTestingToleranceInCanvasCoordinates();

    protected abstract Transformation getTransformationCanvas2Draw2DFigure();

    protected abstract Transformation getTransformationDraw2DFigure2Canvas();

    private int getHitTestingToleranceInDraw2DFigureCoordinates() {
        double toleranceInCanvasCoordinates = this.getHitTestingToleranceInCanvasCoordinates();
        Point canvasPoint = new Point(toleranceInCanvasCoordinates, toleranceInCanvasCoordinates);
        Point viewPoint = canvasPoint.transform(this.getTransformationCanvas2Draw2DFigure());
        return (int)Math.round((viewPoint.x + viewPoint.y) / 2.0);
    }

    private Rectangle transformCanvas2Draw2DFigure(com.arcway.lib.geometry.Rectangle rectangleInCanvas) {
        Rectangle rectangleDraw2DFigure;
        if (rectangleInCanvas == null) {
            rectangleDraw2DFigure = null;
        } else {
            com.arcway.lib.geometry.Rectangle rectangleInDraw2D = rectangleInCanvas.transform(this.getTransformationCanvas2Draw2DFigure());
            rectangleDraw2DFigure = DeviceDriverDraw2DGraphicsFitter.convertBoundsToDraw2D((com.arcway.lib.geometry.Rectangle)rectangleInDraw2D);
        }
        return rectangleDraw2DFigure;
    }

    private Point transformDraw2DFigure2Canvas(int x, int y) {
        return new Point((double)x, (double)y).transform(this.getTransformationDraw2DFigure2Canvas());
    }

    static class IdentitySearch
    implements TreeSearch {
        static final TreeSearch INSTANCE = new IdentitySearch();

        IdentitySearch() {
        }

        public boolean accept(IFigure f) {
            return true;
        }

        public boolean prune(IFigure f) {
            return false;
        }
    }
}

