/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.EXPlanEditPartFactoryException;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.GraphicalSupplementFactoryDispatcher;
import com.arcway.planagent.planeditor.edit.IEditorSpecialEventHandler;
import com.arcway.planagent.planeditor.edit.PEArrow;
import com.arcway.planagent.planeditor.edit.PEDecorator;
import com.arcway.planagent.planeditor.edit.PEFigureDot;
import com.arcway.planagent.planeditor.edit.PEFigureLineShape;
import com.arcway.planagent.planeditor.edit.PEFigurePlane;
import com.arcway.planagent.planeditor.edit.PEMarker;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEProjection;
import com.arcway.planagent.planeditor.edit.PlanElementFactoryDispatcher;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planmodel.implementation.PMFigureDot;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PMGraphicalSupplement;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.nonpermanent.PMArrow;
import com.arcway.planagent.planmodel.nonpermanent.PMDecorator;
import com.arcway.planagent.planmodel.nonpermanent.PMMarker;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planview.outputupdater.POOutputUpdaterFactory;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class PlanEditPartFactory
implements EditPartFactory {
    private static final ILogger logger = Logger.getLogger(PlanEditPartFactory.class);
    private final EditMgr viewManager;
    private final ICommandContext commandContext;
    private final IInputContext inputContext;
    private final IEditorSpecialEventHandler specialEventHandler;
    private int mode;
    private final POOutputUpdaterFactory outputUpdaterFactory;

    public PlanEditPartFactory(int mode, EditMgr viewManager, IInputContext inputContext, ICommandContext commandContext, IEditorSpecialEventHandler specialEventHandler) {
        assert (viewManager != null) : "viewManager is null";
        assert (commandContext != null) : "commandContext is null";
        assert (inputContext != null) : "inputInterpreter is null";
        this.viewManager = viewManager;
        this.commandContext = commandContext;
        this.outputUpdaterFactory = new POOutputUpdaterFactory();
        this.inputContext = inputContext;
        this.specialEventHandler = specialEventHandler;
        this.setMode(mode);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        PEPlanEditPart newEditPart;
        if (model instanceof PMPlan) {
            newEditPart = new PEPlan(this.mode, this.viewManager, this.inputContext, this.commandContext, this.specialEventHandler);
        } else if (model instanceof PMPlanElement) {
            try {
                newEditPart = PlanElementFactoryDispatcher.getInstance().create((PMPlanElement)model);
            }
            catch (PlugInClassExtensionFactoryException e) {
                logger.error("Could not create PEPlanElement for " + model, (Throwable)e);
                newEditPart = null;
            }
            catch (CoreException e) {
                logger.error("Could not create PEPlanElement for " + model, (Throwable)e);
                newEditPart = null;
            }
            catch (EXPlanEditPartFactoryException e) {
                logger.error("Could not create PEPlanElement for " + model, (Throwable)e);
                newEditPart = null;
            }
        } else if (model instanceof PMFigurePlane) {
            newEditPart = new PEFigurePlane();
        } else if (model instanceof PMFigureLineShape) {
            newEditPart = new PEFigureLineShape();
        } else if (model instanceof PMFigureDot) {
            newEditPart = new PEFigureDot();
        } else if (model instanceof PMGraphicalSupplement) {
            try {
                newEditPart = GraphicalSupplementFactoryDispatcher.getInstance().create((PMGraphicalSupplement)model);
            }
            catch (PlugInClassExtensionFactoryException e) {
                logger.error("Could not create PEGraphicalSupplement for " + model, (Throwable)e);
                newEditPart = null;
            }
            catch (CoreException e) {
                logger.error("Could not create PEGraphicalSupplement for " + model, (Throwable)e);
                newEditPart = null;
            }
            catch (EXPlanEditPartFactoryException e) {
                logger.error("Could not create PEGraphicalSupplement for " + model, (Throwable)e);
                newEditPart = null;
            }
        } else if (model instanceof PMProjection) {
            newEditPart = new PEProjection();
        } else if (model instanceof PMMarker) {
            newEditPart = new PEMarker();
        } else if (model instanceof PMDecorator) {
            newEditPart = new PEDecorator();
        } else if (model instanceof PMArrow) {
            newEditPart = new PEArrow();
        } else {
            logger.error("Could not create EditPart for " + model);
            newEditPart = null;
        }
        if (newEditPart != null) {
            newEditPart.setModel(model);
            newEditPart.setOutputUpdater(this.outputUpdaterFactory.createOutputUpdater(model));
        }
        return newEditPart;
    }
}

