/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlanElement;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEFigureDot;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.handles.HandleLine;
import com.arcway.planagent.planeditor.handles.HandleOutline;
import com.arcway.planagent.planeditor.handles.HandlePoint;
import com.arcway.planagent.planeditor.handles.HandlePointMovePlanObject;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planeditor.inputinterpreter.EPOpenPlanElement;
import com.arcway.planagent.planeditor.inputinterpreter.EPPlanElementDropEditPolicy;
import com.arcway.planagent.planeditor.tools.ISingleChildEP;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeListener;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IAppearanceProvider;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.nonpermanent.PMDecorator;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.transactions.TANOP;
import com.arcway.planagent.planmodel.transactions.Transaction;
import com.arcway.planagent.planview.view.HighlightHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.widgets.Display;

public class PEPlanElement
extends PEPlanEditPart
implements IPlanEditorPlanElement,
IModelChangeListener,
ISingleChildEP,
IAppearanceProvider {
    private static final ILogger logger = Logger.getLogger(PEPlanElement.class);
    private static final double PROBLEM_HIGHLIGHT_CORONA_WIDTH = 0.3;
    private static final HighlightHint PROBLEM_HIGHLIGHT_UNKNOWN = new HighlightHint(Color.DARKGREEN, 0.3);
    private static final HighlightHint PROBLEM_HIGHLIGHT_HINT = new HighlightHint(Color.BLUE, 0.3);
    private static final HighlightHint PROBLEM_HIGHLIGHT_WARNING = new HighlightHint(Color.YELLOW, 0.3);
    private static final HighlightHint PROBLEM_HIGHLIGHT_ERROR = new HighlightHint(new Color(255, 100, 94), 0.3);
    private final ArrayList<ISyntaxProblem> problems = new ArrayList();
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
    private static final int MAX_LINES = 30;
    private static final int MAX_WIDTH = 300;
    private static boolean tooltipExceptionReported = false;
    private static final int TOOLTIPS_CACHE_MAX_ENTRIES = 1000;
    private static final Map<String, String> tooltipsCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(2002, 0.5f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    });

    @Override
    public PEPlan getPEPlan() {
        return (PEPlan)this.getParent();
    }

    public IPlanEditorControllerExtension getPlanEditorControllerExtension() {
        PEPlan plan = this.getPEPlan();
        return plan == null ? null : plan.getPlanEditorControllerExtension();
    }

    public Collection<? extends PEFigure> getPEFigures() {
        ArrayList<PEFigure> figures = new ArrayList<PEFigure>();
        for (EditPart child : this.getChildren()) {
            if (!(child instanceof PEFigure)) continue;
            figures.add((PEFigure)child);
        }
        return figures;
    }

    public PMPlanElement getPMPlanElement() {
        return (PMPlanElement)this.getPMPlanModelObject();
    }

    @Override
    protected List<IPMViewableRO> getModelChildren() {
        ArrayList<IPMViewableRO> list = new ArrayList<IPMViewableRO>();
        PMPlanElement planElement = this.getPMPlanElement();
        int i = 0;
        while (i < planElement.getFigureCount()) {
            list.add((IPMViewableRO)planElement.getFigure(i));
            ++i;
        }
        PMDecorator decorator = planElement.getDecorator();
        if (decorator != null) {
            list.add((IPMViewableRO)decorator);
        }
        return list;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("de.plans.fmca.planagent.planeditor.edit.EPPlanElementDropEditPolicy", (EditPolicy)new EPPlanElementDropEditPolicy());
        switch (this.getPEPlan().getMode()) {
            case 1: {
                break;
            }
            case 3: {
                this.installEditPolicy("planelement_edit_role", (EditPolicy)new EPOpenPlanElement());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean skipChildInSelection() {
        return this.getEditFigure() != null;
    }

    @Override
    public void activate() {
        this.getPMPlanElement().getModelChangeMgrRO().addModelChangeListener((IModelChangeListener)this);
        super.activate();
    }

    @Override
    public void deactivate() {
        this.getPMPlanElement().getModelChangeMgrRO().removeModelChangeListener((IModelChangeListener)this);
        super.deactivate();
    }

    public void modelChanged(Set<? extends IModelChangeRO> modelChanges) {
        try {
            this.refreshRecursively();
        }
        catch (Throwable e) {
            logger.error("Exeption while PEPlan refresh catched.", e);
            this.getViewer().setContents(this.getModel());
        }
    }

    @Override
    public List<IHandlePoint> getPointHandles() {
        ArrayList<IHandlePoint> pointHandles = new ArrayList<IHandlePoint>(super.getPointHandles());
        if (this.getPEPlan().getMode() == 1 && this.getViewer().getSelectedEditParts().size() == 1) {
            this.addShortcutCreationHandles(pointHandles);
        }
        return pointHandles;
    }

    protected void addShortcutCreationHandles(List<IHandlePoint> pointHandles) {
        assert (pointHandles != null);
    }

    protected void removeAllProblems() {
        this.setProblems(null);
    }

    protected void setProblems(Collection<? extends ISyntaxProblem> p_problems) {
        boolean refreshRequired = false;
        if (this.problems.size() > 0) {
            this.problems.clear();
            refreshRequired = true;
        }
        if (p_problems != null && !p_problems.isEmpty()) {
            this.problems.addAll(p_problems);
            refreshRequired = true;
        }
        if (refreshRequired) {
            HighlightHint syntaxHighlightHint = null;
            switch (this.getPEPlan().getMode()) {
                case 3: {
                    break;
                }
                case 1: {
                    if (!this.isSyntaxCheckEnabled()) break;
                    int highestCategory = -1;
                    Iterator<ISyntaxProblem> iterator = this.problems.iterator();
                    while (iterator.hasNext()) {
                        ISyntaxProblem element;
                        ISyntaxProblem problem = element = iterator.next();
                        highestCategory = Math.max(highestCategory, problem.getProblemCategory());
                    }
                    if (highestCategory == 0) {
                        syntaxHighlightHint = PROBLEM_HIGHLIGHT_HINT;
                        break;
                    }
                    if (highestCategory == 1) {
                        syntaxHighlightHint = PROBLEM_HIGHLIGHT_WARNING;
                        break;
                    }
                    if (highestCategory == 2) {
                        syntaxHighlightHint = PROBLEM_HIGHLIGHT_ERROR;
                        break;
                    }
                    if (highestCategory < 0 || highestCategory > 2) break;
                    syntaxHighlightHint = PROBLEM_HIGHLIGHT_UNKNOWN;
                    break;
                }
                default: {
                    assert (false) : "unknown editor mode";
                    break;
                }
            }
            this.setHighlightHint(HighlightLevel.SYNTAX_CHECK, syntaxHighlightHint);
        }
    }

    private void setHighlightHint(HighlightLevel highlightLevel, final HighlightHint highlightHint) {
        final PMPlanElement pmPlanElement = this.getPMPlanElement();
        IHighlightRequest highlightRequest = highlightHint == null ? null : new IHighlightRequest(){

            public String getPlanElementUID() {
                return pmPlanElement.getUid();
            }

            public IHighlightHint getHighlightHint() {
                return highlightHint;
            }
        };
        PMHighlight pmHighlight = highlightRequest == null ? null : new PMHighlight(pmPlanElement, highlightRequest);
        pmPlanElement.setHighlight(highlightLevel, pmHighlight);
        this.refresh();
    }

    public Collection<ISyntaxProblem> getSyntaxProblems() {
        return this.problems;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.setToolTip(this.getPEPlan().getViewMgr().getEditDomain().getEditorController().getPlanElementTooltip((IPlanAgentPlanElement)this));
    }

    private boolean isSyntaxCheckEnabled() {
        return this.getPEPlan().isSyntaxCheckEnabled();
    }

    public String getPlanUID() {
        return this.getPMPlanElement().getPlan().getUid();
    }

    public String getPlanName() {
        return this.getPMPlanElement().getPlan().getName();
    }

    public String getPlanElementUID() {
        return this.getPMPlanElement().getUid();
    }

    public String getPlanElementName() {
        return this.getPMPlanElement().getName();
    }

    public String getPlanElementDescription() {
        return this.getPMPlanElement().getDescription();
    }

    public String getPlanElementTypeID() {
        return this.getPMPlanElement().getType();
    }

    public String getPlanElementAspectID() {
        return this.getPMPlanElement().getAspectID();
    }

    public PEFigure getEditFigure() {
        return null;
    }

    public List<IHandle> getOutlineHandlesFor(PEPlanObject child) {
        FeedbackManager feedbackManager = this.getFeedbackManager();
        ArrayList<IHandle> handles = new ArrayList<IHandle>(1);
        handles.add(new HandleOutline((EditPart)child, this.getPEPlan().getViewMgr(), feedbackManager, (IPMPointListRO)child.getPMPointList(), child.getPMPointList().getPointCount() == child.getPMPointList().getLineCount(), 1));
        return handles;
    }

    public List<IHandle> getLineHandlesFor(PEPlanObject child) {
        FeedbackManager feedbackManager = this.getFeedbackManager();
        PMPointList pointList = child.getPMPointList();
        ArrayList<IHandle> handles = new ArrayList<IHandle>(pointList.getLineCount());
        int i = 0;
        while (i < pointList.getLineCount()) {
            PMLine pMLine = pointList.getLine(i);
            if (pMLine.getForce() != 1) {
                handles.add(new HandleLine((EditPart)child, this.getPEPlan().getViewMgr(), feedbackManager, (IPMLineRO)pMLine, 1));
            }
            ++i;
        }
        return handles;
    }

    public List<IHandle> getPointHandlesFor(PEPlanObject child) {
        ArrayList<IHandle> handles;
        FeedbackManager feedbackManager = this.getFeedbackManager();
        EditMgr pePlan_ViewMgr = this.getPEPlan().getViewMgr();
        if (child instanceof PEFigureDot) {
            handles = new ArrayList<IHandle>(1);
            handles.add(new HandlePointMovePlanObject(child, pePlan_ViewMgr, feedbackManager, 1));
        } else {
            PMPointList pointList = child.getPMPointList();
            int pointListSize = pointList.getPointCount();
            handles = new ArrayList(pointListSize);
            int i = 0;
            while (i < pointListSize) {
                PMPoint point = pointList.getPoint(i);
                handles.add(new HandlePoint((EditPart)child, pePlan_ViewMgr, feedbackManager, (IPMPointRO)point, 1));
                ++i;
            }
        }
        return handles;
    }

    private final boolean areChildrenSelectable() {
        boolean selectable;
        switch (this.getPEPlan().getMode()) {
            case 3: {
                selectable = false;
                break;
            }
            case 1: {
                selectable = true;
                break;
            }
            default: {
                assert (false) : "unknown editor mode";
                selectable = false;
            }
        }
        return selectable;
    }

    protected boolean isFigureSelectable(PEFigure figureToChek) {
        if (this.getPointHandlesFor(figureToChek).isEmpty() && this.getLineHandlesFor(figureToChek).isEmpty() && this.getOutlineHandlesFor(figureToChek).isEmpty()) {
            return false;
        }
        return this.areChildrenSelectable();
    }

    protected boolean isGraphicalSupplementSelectable(PEGraphicalSupplement graphicalSupplement) {
        if (this.getPointHandlesFor(graphicalSupplement).isEmpty() && this.getLineHandlesFor(graphicalSupplement).isEmpty() && this.getOutlineHandlesFor(graphicalSupplement).isEmpty()) {
            return false;
        }
        return this.areChildrenSelectable();
    }

    public Collection<TemplateApplicationTuple> getTemplateApplicationTuples() {
        ArrayList<TemplateApplicationTuple> tuples = new ArrayList<TemplateApplicationTuple>();
        for (PEFigure pEFigure : this.getPEFigures()) {
            tuples.addAll(pEFigure.getTemplateApplicationTuples());
        }
        return tuples;
    }

    public boolean provideAppearancesFor(PEPlanObject child) {
        return child.isSelectable();
    }

    public boolean isRenameable() {
        return true;
    }

    public Transaction getRenameTransaction(ActionParameters actionParameters) {
        return new TANOP((IPMPlanModelObjectRO)this.getPMPlanElement(), actionParameters);
    }

    public Transaction getChangeDescriptionTransaction(ActionParameters actionParameters) {
        return new TANOP((IPMPlanModelObjectRO)this.getPMPlanElement(), actionParameters);
    }

    public String toString() {
        String name = this.getPMPlanElement().getName();
        String uid = this.getPMPlanElement().getUid();
        String type = this.getPMPlanElement().getType();
        if ("".equals(name)) {
            return "PEPlanElement (" + type + ", " + uid + ")";
        }
        return "PEPlanElement (" + name + ", " + type + ", " + uid + ")";
    }

    public boolean mouseHoverStart(Point screenposition) {
        boolean success = false;
        return success;
    }

    public void mouseHoverStop() {
    }

    public void setToolTip(String txt) {
        String text = txt;
        if (text == null) {
            text = this.getPMPlanElement().getName();
            String description = this.getPMPlanElement().getDescription();
            if (description != null && description.trim().length() > 0) {
                text = String.valueOf(text) + "\n\n" + description;
            }
        }
        this.getFigure().setToolTip(this.createToolTip(text));
    }

    protected IFigure createToolTip(String text) {
        FlowPage fp;
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            fp = new FlowPage(){

                public Dimension getPreferredSize(int w, int h) {
                    Dimension d = super.getPreferredSize(-1, -1);
                    if (d.width > 300) {
                        d = super.getPreferredSize(300, -1);
                    }
                    return d;
                }
            };
            fp.setOpaque(true);
            fp.setBorder(TOOLTIP_BORDER);
            TextFlow tf = new TextFlow();
            tf.setFont(Display.getDefault().getSystemFont());
            ParagraphTextLayout paragraphTextLayout = new ParagraphTextLayout(tf, 1);
            tf.setLayoutManager((LayoutManager)paragraphTextLayout);
            fp.add((IFigure)tf);
            String potentiallyAbbreviatedText = tooltipsCache.get(text);
            if (potentiallyAbbreviatedText != null) {
                tf.setText(potentiallyAbbreviatedText);
            } else {
                tf.setText(text);
                fp.getPreferredSize();
                List fragements = tf.getFragments();
                if (fragements.size() > 30) {
                    int nrOfCharacters;
                    Object flowBoxMax = fragements.get(29);
                    if (flowBoxMax instanceof TextFragmentBox) {
                        TextFragmentBox textFragmentBoxMax = (TextFragmentBox)flowBoxMax;
                        nrOfCharacters = textFragmentBoxMax.offset + textFragmentBoxMax.length;
                    } else {
                        nrOfCharacters = 900;
                    }
                    nrOfCharacters = Math.max(0, Math.min(text.length(), nrOfCharacters));
                    String abbreviatedText = String.valueOf(text.substring(0, nrOfCharacters)) + "\n...";
                    tf.setText(abbreviatedText);
                    tooltipsCache.put(text, abbreviatedText);
                } else {
                    tooltipsCache.put(text, text);
                }
            }
        }
        catch (Throwable e) {
            if (!tooltipExceptionReported) {
                logger.error("Error while calculating tooltip", e);
                tooltipExceptionReported = true;
            }
            fp = null;
        }
        return fp;
    }
}

