/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.figures.PFManagedViewFigure;
import com.arcway.planagent.planeditor.figures.PFPlan;
import com.arcway.planagent.planeditor.handles.AbstractHandleToggler;
import com.arcway.planagent.planeditor.handles.DefaultHandleToggler;
import com.arcway.planagent.planeditor.handles.IHandleLine;
import com.arcway.planagent.planeditor.handles.IHandleOutline;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planeditor.handles.IHandleProvider;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planview.outputupdater.POOutputUpdater;
import com.arcway.planagent.planview.view.IViewPartMgr;
import com.arcway.planagent.planview.view.PVManagedViewPart;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class PEPlanEditPart
extends AbstractGraphicalEditPart
implements IHandleProvider {
    private static final ILogger logger = Logger.getLogger(PEPlanEditPart.class);
    private static final String EDITPART_LISTENER_ROLE_HANDLE_TOGGLER = "HANDLE_TOGGLER";
    public Map<String, EditPartListener> editPartListenerMap = new HashMap<String, EditPartListener>();
    private Rectangle lastReportedConstraint = null;
    protected POOutputUpdater outputUpdater = null;

    public PEPlanEditPart() {
        this.installEditPartListeners();
    }

    public abstract PEPlan getPEPlan();

    protected PEPlanEditPart getParentPEPlanEditPart() {
        return (PEPlanEditPart)this.getParent();
    }

    protected IPMViewableRO getPMPlanModelObject() {
        return (IPMViewableRO)this.getModel();
    }

    protected PFManagedViewFigure getPFManagedViewFigure() {
        return (PFManagedViewFigure)this.getFigure();
    }

    protected PVPlanViewPart getPVPlanViewPart() {
        return this.getPFManagedViewFigure().getPVManagedViewPart().getManagedViewPart();
    }

    public PFPlan getPFPlan() {
        return this.getPEPlan().getPFPlan();
    }

    protected PEPlanEditPart getPEPlanEditPart(IPMPlanModelObjectRO modelObject) {
        return (PEPlanEditPart)this.getViewer().getEditPartRegistry().get(modelObject);
    }

    public ICommandContext getCommandContext() {
        return this.getPEPlan().getCommandContext();
    }

    public IInputContext getInputContext() {
        return this.getPEPlan().getInputContext();
    }

    protected FeedbackManager getFeedbackManager() {
        return this.getPEPlan().getFeedbackManager();
    }

    protected IFigure createFigure() {
        if (logger.isDebugEnabled(60)) {
            logger.debug(60, "-- create Figure for EditPart " + this.toString());
        }
        return new PFManagedViewFigure(this.createManagedViewPart(this.getPEPlan().getViewMgr()));
    }

    public void activate() {
        if (logger.isDebugEnabled(62)) {
            logger.debug(62, "<- activate EditPart " + this.toString());
        }
        super.activate();
    }

    public void deactivate() {
        if (logger.isDebugEnabled(62)) {
            logger.debug(62, "-> deactivate EditPart " + this.toString());
        }
        super.deactivate();
    }

    private PVManagedViewPart createManagedViewPart(IViewPartMgr viewPartMgr) {
        return new PVManagedViewPart(viewPartMgr, this.createPlanViewPart());
    }

    protected PVPlanViewPart createPlanViewPart() {
        return this.outputUpdater.createPlanViewPart();
    }

    private void installEditPartListeners() {
        this.createEditPartListeners();
    }

    protected void createEditPolicies() {
    }

    protected void createEditPartListeners() {
        this.installEditPartListener(EDITPART_LISTENER_ROLE_HANDLE_TOGGLER, DefaultHandleToggler.getUniqueInstance());
    }

    protected final void installEditPartListener(String role, EditPartListener editPartListener) {
        assert (!"".equals(role)) : "Edit part listeners must be installed with role keys";
        EditPartListener old = this.getEditPartListener(role);
        if (old != null) {
            this.removeEditPartListener(old);
        }
        this.editPartListenerMap.put(role, editPartListener);
        this.addEditPartListener(editPartListener);
    }

    protected EditPartListener getEditPartListener(String role) {
        return this.editPartListenerMap.get(role);
    }

    protected EditPart getSelectionTarget() {
        return this;
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart target;
        if ("selection" == request.getType()) {
            target = this.getSelectionTarget();
            if (!target.isSelectable()) {
                target = null;
            }
        } else {
            target = super.getTargetEditPart(request);
        }
        return target;
    }

    public void refresh() {
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refresh() for PlanEditPart " + this.toString());
        }
        this.refreshRecursively();
    }

    protected void refreshRecursively() {
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refreshChildrenRecursively() for PlanEditPart " + this.toString());
        }
        this.refreshVisuals();
        this.refreshChildren();
        List allChildren = this.getChildren();
        for (EditPart child : allChildren) {
            if (child instanceof PEPlanEditPart) {
                PEPlanEditPart childPlanEditPart = (PEPlanEditPart)child;
                childPlanEditPart.refreshRecursively();
                continue;
            }
            child.refresh();
        }
        this.refreshConstraint();
        this.refreshHandles();
        this.getFigure().repaint();
    }

    protected void refreshVisuals() {
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refreshVisuals() for PlanEditPart " + this.toString());
        }
        this.outputUpdater.refreshVisuals(null);
    }

    protected void refreshChildren() {
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refreshChildren() for PlanEditPart " + this.toString());
        }
        super.refreshChildren();
    }

    protected void refreshConstraint() {
        Rectangle r;
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refreshConstraint() for PlanEditPart " + this.toString());
        }
        if ((r = this.getPFManagedViewFigure().getOuterBoundsInDraw2DFigureCoordinates()) != null) {
            boolean refresh;
            PEPlanEditPart parent = this.getParentPEPlanEditPart();
            PFManagedViewFigure thisFigure = this.getPFManagedViewFigure();
            if (this.lastReportedConstraint == null) {
                refresh = true;
            } else {
                boolean bl = refresh = !r.equals((Object)this.lastReportedConstraint);
            }
            if (refresh) {
                if (logger.isDebugEnabled(63)) {
                    logger.debug(63, "  ~>> refresh with Rectangle " + r);
                }
                parent.setLayoutConstraint((EditPart)this, (IFigure)thisFigure, r);
                parent.refreshConstraint();
                this.lastReportedConstraint = r.getCopy();
            } else if (logger.isDebugEnabled(63)) {
                logger.debug(63, "  ~~~ no refresh (still Rectangle " + this.lastReportedConstraint + ")");
            }
        }
    }

    private void refreshHandles() {
        EditPartListener editPartListener;
        int selectionState;
        if (logger.isDebugEnabled(63)) {
            logger.debug(63, "~~~~~ refreshHandles() for PlanEditPart " + this.toString());
        }
        if ((selectionState = this.getSelected()) != 0 && (editPartListener = this.getEditPartListener(EDITPART_LISTENER_ROLE_HANDLE_TOGGLER)) != null && editPartListener instanceof AbstractHandleToggler) {
            AbstractHandleToggler handleTogger = (AbstractHandleToggler)editPartListener;
            handleTogger.selectedStateChanged((EditPart)this);
        }
    }

    public IHandleProvider getHandleProvider() {
        return this;
    }

    @Override
    public List<IHandlePoint> getPointHandles() {
        return new ArrayList<IHandlePoint>(0);
    }

    @Override
    public List<IHandleLine> getLineHandles() {
        return new ArrayList<IHandleLine>(0);
    }

    @Override
    public List<IHandleOutline> getOutlineHandles() {
        return new ArrayList<IHandleOutline>(0);
    }

    public void setOutputUpdater(POOutputUpdater outputUpdater) {
        this.outputUpdater = outputUpdater;
    }

    public void setModel(Object modelObject) {
        assert (modelObject instanceof IPMViewableRO);
        super.setModel(modelObject);
    }

    protected List<IPMViewableRO> getModelChildren() {
        return new ArrayList<IPMViewableRO>(this.getPMPlanModelObject().getChildIPMViewableROs());
    }
}

