/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IInvalidPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlan;
import com.arcway.planagent.controllinginterface.planeditor.ISelectionRequest;
import com.arcway.planagent.planeditor.IProjector;
import com.arcway.planagent.planeditor.PATCHED_ScrollingGraphicalViewer;
import com.arcway.planagent.planeditor.check.ExternalSyntaxChecker;
import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.check.ISyntaxProblemListener;
import com.arcway.planagent.planeditor.check.SyntaxChecker;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.IEditorSpecialEventHandler;
import com.arcway.planagent.planeditor.edit.IZoomChangedListener;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.edit.SelectionBlinker;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.figures.PFManagedViewFigure;
import com.arcway.planagent.planeditor.figures.PFPlan;
import com.arcway.planagent.planeditor.framecom.ExternalSyntaxCheckerMgr;
import com.arcway.planagent.planeditor.inputinterpreter.EPDeletePlanElements;
import com.arcway.planagent.planeditor.inputinterpreter.EPPlanElementDropEditPolicy;
import com.arcway.planagent.planeditor.inputinterpreter.EPPlanLayoutEditPolicy;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeListener;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRO;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootListener;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringRO;
import com.arcway.planagent.planmodel.access.readonly.IPMContainmentRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMSemanticalUnitRO;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import com.arcway.planagent.planmodel.implementation.PMContainment;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.nonpermanent.PMArrow;
import com.arcway.planagent.planmodel.nonpermanent.PMDecorator;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.nonpermanent.PMMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PEPlan
extends PEPlanEditPart
implements IPlanEditorPlan,
IProjector,
IModelChangeRootListener,
IModelChangeListener,
IZoomChangedListener,
ISyntaxProblemListener {
    private static final ILogger logger = Logger.getLogger(PEPlan.class);
    private static final Color MARKER_COLOR_POINT_ANCHORINGS = new Color(128, 0, 128);
    private static final FillColor MARKER_FILLCOLOR_POINT_ANCHORINGS = FillColor.TRANSPARENT;
    private static final Color MARKER_COLOR_LINE_ANCHORINGS = new Color(0, 128, 64);
    private static final FillColor MARKER_FILLCOLOR_LINE_ANCHORINGS = FillColor.TRANSPARENT;
    private static final Color MARKER_COLOR_CONTAINMENT = Color.BLUE;
    private static final Color MARKER_COLOR_CONTAINMENT_CONTAINER = Color.DARKGREEN;
    private static final Color MARKER_COLOR_CONTAINMENT_CONTAINER_ERROR = Color.RED;
    private static final Color MARKER_COLOR_CONTAINMENT_CONTAINED = Color.DARKGREEN;
    private static final Color MARKER_COLOR_CONTAINMENT_CONTAINED_ERROR = Color.RED;
    private static final GeoVector DECORATOR_OFFSET_IN_MM = GeoVector.GeoVector_1_1;
    private static final GeoVector DECORATOR_OFFSET_IN_PLANUNITS = new GeoVector(PEPlan.DECORATOR_OFFSET_IN_MM.x / 1000.0 * 1000.0, PEPlan.DECORATOR_OFFSET_IN_MM.y / 1000.0 * 1000.0);
    private final int mode;
    private final EditMgr editMgr;
    private final ICommandContext commandContext;
    private FeedbackManager feedbackManager;
    private final IInputContext inputContext;
    private ExternalSyntaxChecker externalSyntaxChecker = null;
    private final SelectionManager selectionManager;
    private SelectionBlinker selectionBlinker = null;

    public PEPlan(int mode, EditMgr editMgr, IInputContext inputContext, ICommandContext commandContext, IEditorSpecialEventHandler specialEventHandler) {
        assert (editMgr != null) : "viewManager is null";
        assert (commandContext != null) : "commandContext is null";
        this.mode = mode;
        this.editMgr = editMgr;
        this.commandContext = commandContext;
        this.inputContext = inputContext;
        this.selectionManager = new SelectionManager();
        ExternalSyntaxCheckerMgr externalSyntaxCheckerMgr = (ExternalSyntaxCheckerMgr)SyntaxChecker.getInstance().findSyntaxChecker(ExternalSyntaxCheckerMgr.class);
        if (externalSyntaxCheckerMgr != null) {
            ICheckMgr checkMgr = editMgr.getCheckMgr();
            this.externalSyntaxChecker = new ExternalSyntaxChecker(this, checkMgr, externalSyntaxCheckerMgr);
        }
    }

    public IPlanEditorControllerExtension getPlanEditorControllerExtension() {
        return this.editMgr.getEditDomain().getEditorController();
    }

    public EditMgr getViewMgr() {
        return this.editMgr;
    }

    public ICheckMgr getCheckMgr() {
        return this.editMgr;
    }

    public PMPlan getPMPlan() {
        return (PMPlan)this.getPMPlanModelObject();
    }

    @Override
    public PEPlan getPEPlan() {
        return this;
    }

    @Override
    protected PEPlanEditPart getParentPEPlanEditPart() {
        return null;
    }

    @Override
    public PFPlan getPFPlan() {
        return (PFPlan)this.getFigure();
    }

    @Override
    protected PFManagedViewFigure getPFManagedViewFigure() {
        return null;
    }

    @Override
    public ICommandContext getCommandContext() {
        return this.commandContext;
    }

    public CommandStack getCommandStack() {
        return this.editMgr.getEditDomain().getCommandStack();
    }

    @Override
    protected FeedbackManager getFeedbackManager() {
        return this.feedbackManager;
    }

    @Override
    protected IFigure createFigure() {
        return new PFPlan(this.mode);
    }

    @Override
    protected List<IPMViewableRO> getModelChildren() {
        List<IPMViewableRO> list = super.getModelChildren();
        if (logger.isDebugEnabled(71) && this.getMode() == 1) {
            list.addAll(this.getDebuggingMarkers());
        }
        return list;
    }

    private List<IPMViewableRO> getDebuggingMarkers() {
        boolean error;
        LineMarkerAppearance lineEndMarkerAppearance;
        LineMarkerAppearance lineStartMarkerAppearance;
        LineAppearance lineAppearance;
        Line position;
        Polygon containedPolygon;
        Polygon containerPolygon;
        PMPlanElement contained;
        PMPlanElement container;
        PMContainment containment;
        int c;
        PMPlanElement planElement;
        ArrayList<IPMViewableRO> markers = new ArrayList<IPMViewableRO>();
        PMPlan plan = this.getPMPlan();
        int pe = 0;
        while (pe < plan.getPlanElementCount()) {
            planElement = plan.getPlanElement(pe);
            c = 0;
            while (c < planElement.getContainmentAsContainerCount()) {
                containment = planElement.getContainmentAsContainer(c);
                container = containment.getContainingPlanElement();
                contained = containment.getContainedPlanElement();
                containerPolygon = container.getNestingInline();
                containedPolygon = contained.getNestingOutline();
                if (containerPolygon != null && containedPolygon != null && containerPolygon.getPolygonCornerPointCount() >= 0 && containedPolygon.getPolygonCornerPointCount() >= 0) {
                    position = new Line(containerPolygon.getPolygonCorner(0).getRealPosition(), containedPolygon.getPolygonCorner(0).getRealPosition());
                    lineAppearance = new LineAppearance();
                    lineStartMarkerAppearance = new LineMarkerAppearance();
                    lineEndMarkerAppearance = new LineMarkerAppearance();
                    lineAppearance.setLineColor(MARKER_COLOR_CONTAINMENT);
                    lineAppearance.setLineThickness(0.4);
                    lineStartMarkerAppearance.setLineMarkerStyle(LineMarker.DOT);
                    lineStartMarkerAppearance.setLineMarkerSize(0.7);
                    lineEndMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                    boolean bl = error = planElement != container;
                    if (error) {
                        lineStartMarkerAppearance.setLineMarkerColor(MARKER_COLOR_CONTAINMENT_CONTAINER_ERROR);
                    } else {
                        lineStartMarkerAppearance.setLineMarkerColor(MARKER_COLOR_CONTAINMENT_CONTAINER);
                    }
                    markers.add((IPMViewableRO)new PMArrow(plan, position, (ILineAppearanceRO)lineAppearance, (ILineMarkerAppearanceRO)lineStartMarkerAppearance, (ILineMarkerAppearanceRO)lineEndMarkerAppearance));
                }
                ++c;
            }
            ++pe;
        }
        pe = 0;
        while (pe < plan.getPlanElementCount()) {
            planElement = plan.getPlanElement(pe);
            c = 0;
            while (c < planElement.getContainmentAsContainedCount()) {
                containment = planElement.getContainmentAsContained(c);
                container = containment.getContainingPlanElement();
                contained = containment.getContainedPlanElement();
                containerPolygon = container.getNestingInline();
                containedPolygon = contained.getNestingOutline();
                if (containerPolygon != null && containedPolygon != null && containerPolygon.getPolygonCornerPointCount() >= 0 && containedPolygon.getPolygonCornerPointCount() >= 0) {
                    position = new Line(containerPolygon.getPolygonCorner(0).getRealPosition(), containedPolygon.getPolygonCorner(0).getRealPosition());
                    lineAppearance = new LineAppearance();
                    lineStartMarkerAppearance = new LineMarkerAppearance();
                    lineEndMarkerAppearance = new LineMarkerAppearance();
                    lineAppearance.setLineColor(MARKER_COLOR_CONTAINMENT);
                    lineAppearance.setLineThickness(0.4);
                    lineStartMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                    lineEndMarkerAppearance.setLineMarkerStyle(LineMarker.PEAKED_ARC);
                    lineEndMarkerAppearance.setLineMarkerSize(0.5);
                    boolean bl = error = planElement != contained;
                    if (error) {
                        lineEndMarkerAppearance.setLineMarkerColor(MARKER_COLOR_CONTAINMENT_CONTAINED_ERROR);
                    } else {
                        lineEndMarkerAppearance.setLineMarkerColor(MARKER_COLOR_CONTAINMENT_CONTAINED);
                    }
                    markers.add((IPMViewableRO)new PMArrow(plan, position, (ILineAppearanceRO)lineAppearance, (ILineMarkerAppearanceRO)lineStartMarkerAppearance, (ILineMarkerAppearanceRO)lineEndMarkerAppearance));
                }
                ++c;
            }
            ++pe;
        }
        pe = 0;
        while (pe < plan.getPlanElementCount()) {
            planElement = plan.getPlanElement(pe);
            int f = 0;
            while (f < planElement.getFigureCount()) {
                PMFigure oneFigure = planElement.getFigure(f);
                PMPointList pointList = oneFigure.getPointList();
                int i = 0;
                while (i < pointList.getPointCount()) {
                    PMPoint point = pointList.getPoint(i);
                    if (point.getAnchoring() != null) {
                        com.arcway.lib.geometry.Point position2 = point.getPosition();
                        LineMarker markerStyle = LineMarker.CROSS;
                        Color color = MARKER_COLOR_POINT_ANCHORINGS;
                        FillColor fillColor = MARKER_FILLCOLOR_POINT_ANCHORINGS;
                        double size = 0.3;
                        double angle = 0.0;
                        markers.add((IPMViewableRO)new PMMarker(plan, position2, markerStyle, color, fillColor, size, angle));
                    }
                    ++i;
                }
                i = 0;
                while (i < pointList.getLineCount()) {
                    PMLine line = pointList.getLine(i);
                    if (line.getAnchoring() != null) {
                        com.arcway.lib.geometry.Point p1 = line.getPoint1st().getPosition();
                        com.arcway.lib.geometry.Point p2 = line.getPoint2nd().getPosition();
                        com.arcway.lib.geometry.Point center = p1.movePoint(new GeoVector(p1, p2).scale(0.5));
                        LineMarker markerStyle = LineMarker.CROSS;
                        Color color = MARKER_COLOR_LINE_ANCHORINGS;
                        FillColor fillColor = MARKER_FILLCOLOR_LINE_ANCHORINGS;
                        double size = 0.3;
                        double angle = 0.0;
                        markers.add((IPMViewableRO)new PMMarker(plan, center, markerStyle, color, fillColor, size, angle));
                    }
                    ++i;
                }
                ++f;
            }
            ++pe;
        }
        return markers;
    }

    @Override
    protected void createEditPolicies() {
        this.feedbackManager = new FeedbackManager(this.getViewMgr(), this.getPFPlan(), this.getLayer("Feedback Layer"));
        switch (this.getMode()) {
            case 1: {
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EPPlanLayoutEditPolicy(this.getPEPlan().getViewMgr(), this.getFeedbackManager()));
                this.installEditPolicy("COMMAND_DELETE", (EditPolicy)new EPDeletePlanElements());
                break;
            }
            case 3: {
                this.installEditPolicy("LayoutEditPolicy", null);
                break;
            }
            default: {
                assert (false) : "unknown mode";
                break;
            }
        }
        this.installEditPolicy("de.plans.fmca.planagent.planeditor.edit.EPPlanElementDropEditPolicy", (EditPolicy)new EPPlanElementDropEditPolicy());
    }

    @Override
    protected void refreshConstraint() {
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void activate() {
        this.editMgr.setPlan(this);
        this.getPMPlan().getModelChangeRootMgrRO().addModelChangeRootListener((IModelChangeRootListener)this);
        this.getPMPlan().getModelChangeMgrRO().addModelChangeListener((IModelChangeListener)this);
        this.editMgr.getZoomMgr().addZoomChangedListener(this);
        this.editMgr.getCheckMgr().registerSyntaxProblemListener(this);
        super.activate();
    }

    @Override
    public void deactivate() {
        this.getPMPlan().getModelChangeMgrRO().removeModelChangeListener((IModelChangeListener)this);
        this.getPMPlan().getModelChangeRootMgrRO().removeModelChangeRootListener((IModelChangeRootListener)this);
        this.editMgr.getCheckMgr().unregisterSyntaxProblemListener(this);
        this.editMgr.removeZoomChangedListener(this);
        this.editMgr.setPlan(null);
        super.deactivate();
    }

    public void aboutTofireModelChanges(Set<? extends IModelChangeRO> modelChanges) {
        EditPartViewer viewer = this.getViewer();
        PATCHED_ScrollingGraphicalViewer fmcaViewer = null;
        if (viewer instanceof PATCHED_ScrollingGraphicalViewer) {
            fmcaViewer = (PATCHED_ScrollingGraphicalViewer)viewer;
        }
        List selectedEditPartsOfViewer = viewer.getSelectedEditParts();
        ArrayList selectedEditParts = new ArrayList(selectedEditPartsOfViewer.size());
        selectedEditParts.addAll(selectedEditPartsOfViewer);
        for (IModelChangeRO iModelChangeRO : modelChanges) {
            Object editPartObject;
            IPMPlanModelObjectRO planModelObject = iModelChangeRO.getPlanModelObjectRO();
            if (iModelChangeRO.getType() != 3 || (editPartObject = this.getViewer().getEditPartRegistry().get(planModelObject)) == null || !(editPartObject instanceof EditPart)) continue;
            EditPart editPart = (EditPart)editPartObject;
            this.removeWithChildren(editPart, selectedEditParts);
        }
        StructuredSelection structuredSelection = new StructuredSelection(selectedEditParts);
        if (fmcaViewer != null) {
            fmcaViewer.setSelectionWithoutFiringSelectionChanged((ISelection)structuredSelection);
        } else {
            viewer.setSelection((ISelection)structuredSelection);
        }
    }

    private void removeWithChildren(EditPart editPart, Collection editParts) {
        editParts.remove(editPart);
        for (EditPart child : editPart.getChildren()) {
            this.removeWithChildren(child, editParts);
        }
    }

    public void modelChangesFired(Set<? extends IModelChangeRO> modelChanges) {
        EditPartViewer viewer = this.getViewer();
        PATCHED_ScrollingGraphicalViewer fmcaViewer = null;
        if (viewer instanceof PATCHED_ScrollingGraphicalViewer) {
            fmcaViewer = (PATCHED_ScrollingGraphicalViewer)viewer;
        }
        ArrayList<EditPart> createdEditParts = new ArrayList<EditPart>();
        for (IModelChangeRO iModelChangeRO : modelChanges) {
            Object editPartObject;
            IPMPlanModelObjectRO planModelObject = iModelChangeRO.getPlanModelObjectRO();
            if (iModelChangeRO.getType() != 1) continue;
            if (logger.isDebugEnabled(63)) {
                logger.debug(63, "     Model object created: " + planModelObject);
            }
            if ((editPartObject = this.getViewer().getEditPartRegistry().get(planModelObject)) != null && editPartObject instanceof EditPart) {
                EditPart editPart = (EditPart)editPartObject;
                if (logger.isDebugEnabled(63)) {
                    logger.debug(63, "     EditPart found: " + editPartObject);
                }
                if (editPart instanceof PEPlanObject && !((PEPlanObject)editPart).isSelectable()) continue;
                createdEditParts.add(editPart);
                continue;
            }
            if (!logger.isDebugEnabled(63)) continue;
            logger.debug(63, "     --> No EditPart found for " + planModelObject);
        }
        ArrayList<PEPlanElement> arrayList = new ArrayList<PEPlanElement>();
        for (EditPart editPart : createdEditParts) {
            if (!(editPart instanceof PEPlanElement)) continue;
            arrayList.add((PEPlanElement)editPart);
        }
        if (arrayList.size() > 1) {
            ArrayList<EditPart> tmpList = new ArrayList<EditPart>();
            tmpList.addAll(createdEditParts);
            boolean onlyControlFlowsCreated = true;
            for (PEPlanElement pePlanElement : arrayList) {
                PMPlanElement pmPlanElement = pePlanElement.getPMPlanElement();
                int j = 0;
                while (j < pmPlanElement.getFigureCount()) {
                    IAnchoringDestination anchoringDestination;
                    IPMPointRO potentialAnchorPoint;
                    IPMAnchoringPointRO anchoring;
                    IPMPointListRO pointList;
                    IPMFigureRO potentialLine = pmPlanElement.getFigureRO(j);
                    if (potentialLine instanceof IPMFigurePlaneRO) {
                        onlyControlFlowsCreated = false;
                    }
                    if ((pointList = potentialLine.getPointListRO()).getPointCount() > pointList.getLineCount() && (anchoring = (potentialAnchorPoint = pointList.getPointRO(0)).getAnchoringRO()) != null && (anchoringDestination = anchoring.getAnchoringDestination()) instanceof PMFigure) {
                        PMFigure anchoringFigure = (PMFigure)anchoringDestination;
                        boolean isNewFigure = false;
                        for (EditPart editPart : arrayList) {
                            PEPlanElement pe = (PEPlanElement)editPart;
                            PMPlanElement pm = pe.getPMPlanElement();
                            int k = 0;
                            while (k < pm.getFigureCount()) {
                                if (pm.getFigureRO(k).equals(anchoringFigure)) {
                                    isNewFigure = true;
                                }
                                ++k;
                            }
                        }
                        if (!isNewFigure && tmpList.size() > 1) {
                            tmpList.remove(pePlanElement);
                        }
                    }
                    ++j;
                }
            }
            if (!onlyControlFlowsCreated) {
                createdEditParts = tmpList;
            }
        }
        if (createdEditParts.size() > 0) {
            this.selectionManager.replaceSelection(createdEditParts, (EditPartViewer)fmcaViewer);
        } else if (fmcaViewer != null) {
            fmcaViewer.fireSelectionChanged();
        }
        boolean planElementStructureChanged = false;
        Iterator<? extends IModelChangeRO> i = modelChanges.iterator();
        while (!planElementStructureChanged && i.hasNext()) {
            IModelChangeRO modelChange = i.next();
            IPMPlanModelObjectRO planModelObject = modelChange.getPlanModelObjectRO();
            if (planModelObject instanceof IPMContainmentRO) {
                planElementStructureChanged |= true;
                continue;
            }
            if ((modelChange.getType() == 1 || modelChange.getType() == 3) && planModelObject instanceof IPMPlanElementRO) {
                planElementStructureChanged |= true;
                continue;
            }
            if (modelChange.getType() == 2 && planModelObject instanceof IPMFigureLineShapeRO) {
                planElementStructureChanged |= true;
                continue;
            }
            if (!(planModelObject instanceof IPMAnchoringRO)) continue;
            planElementStructureChanged |= true;
        }
        if (planElementStructureChanged) {
            this.getCommandContext().getInternalPlanController().notifyOfStructureChanges();
        }
        this.editMgr.getCheckMgr().triggerSyntaxChecks();
    }

    public void modelChanged(Set<? extends IModelChangeRO> modelChanges) {
        if (this.selectionBlinker != null) {
            this.selectionBlinker.terminate();
            this.selectionBlinker = null;
        }
        try {
            ArrayList<PEPlanElement> planElementsToRefresh = new ArrayList<PEPlanElement>();
            boolean refreshPlan = logger.isDebugEnabled(71);
            Iterator<? extends IModelChangeRO> i = modelChanges.iterator();
            while (!refreshPlan && i.hasNext()) {
                IModelChangeRO modelChange = i.next();
                IPMSemanticalUnitRO semanticalUnit = modelChange.getPlanModelObjectRO().getISemanticalUnitRO();
                if (semanticalUnit instanceof IPMPlanElementRO) {
                    Object editPartObject = this.getViewer().getEditPartRegistry().get(semanticalUnit);
                    if (editPartObject == null) {
                        refreshPlan = true;
                        continue;
                    }
                    if (editPartObject instanceof PEPlanElement) {
                        if (modelChange.getType() == 2 || modelChange.getPlanModelObjectRO() != semanticalUnit) {
                            planElementsToRefresh.add((PEPlanElement)editPartObject);
                            continue;
                        }
                        refreshPlan = true;
                        continue;
                    }
                    refreshPlan = true;
                    continue;
                }
                refreshPlan = true;
            }
            if (refreshPlan) {
                this.refresh();
            } else {
                for (PEPlanElement planElement : planElementsToRefresh) {
                    planElement.refresh();
                }
            }
            if (this.hasHighlightedPlanElements(HighlightLevel.SELECTION) && this.getMode() == 3) {
                this.selectionBlinker = new SelectionBlinker(Display.getCurrent(), this);
                this.selectionBlinker.start();
            }
        }
        catch (Throwable e) {
            logger.error("Exeption while PEPlan refresh catched.", e);
            this.getViewer().setContents(this.getModel());
        }
    }

    private boolean hasHighlightedPlanElements(HighlightLevel highlightLevel) {
        return !this.getHighlights(highlightLevel).isEmpty();
    }

    Collection<PMHighlight> getHighlights(HighlightLevel highlightLevel) {
        ArrayList<PMHighlight> highlights = new ArrayList<PMHighlight>();
        for (EditPart child : this.getChildren()) {
            PEPlanElement planElement;
            PMHighlight highlight;
            if (!(child instanceof PEPlanElement) || (highlight = (planElement = (PEPlanElement)child).getPMPlanElement().getHighlight(highlightLevel)) == null) continue;
            highlights.add(highlight);
        }
        return highlights;
    }

    @Override
    public void syntaxProblemListChanged(Collection<? extends ISyntaxProblem> allSyntaxProblems) {
        for (EditPart editPart : this.getChildren()) {
            if (!(editPart instanceof PEPlanElement)) continue;
            PEPlanElement pEPlanElement = (PEPlanElement)editPart;
            pEPlanElement.removeAllProblems();
        }
        HashMap<IPMPlanElementRO, ArrayList<ISyntaxProblem>> allSyntaxProblemsPartitionedByPMPlanElement = new HashMap<IPMPlanElementRO, ArrayList<ISyntaxProblem>>(allSyntaxProblems.size() * 2, 0.5f);
        for (ISyntaxProblem iSyntaxProblem : allSyntaxProblems) {
            if (iSyntaxProblem == null) continue;
            IPMPlanElementRO pMPlanElement = iSyntaxProblem.getPlanElement();
            ArrayList<ISyntaxProblem> partition = (ArrayList<ISyntaxProblem>)allSyntaxProblemsPartitionedByPMPlanElement.get(pMPlanElement);
            if (partition == null) {
                partition = new ArrayList<ISyntaxProblem>();
                allSyntaxProblemsPartitionedByPMPlanElement.put(pMPlanElement, partition);
            }
            partition.add(iSyntaxProblem);
        }
        for (Map.Entry entry : allSyntaxProblemsPartitionedByPMPlanElement.entrySet()) {
            PEPlanElement pEPlanElement = (PEPlanElement)this.getViewer().getEditPartRegistry().get(entry.getKey());
            pEPlanElement.setProblems((Collection)entry.getValue());
        }
    }

    boolean isSyntaxCheckEnabled() {
        return this.editMgr.isSyntaxCheckEnabled();
    }

    public String getPlanUID() {
        return this.getPMPlan().getUid();
    }

    public String getPlanTypeID() {
        return this.getPMPlan().getUid();
    }

    public String getPlanName() {
        return this.getPMPlan().getName();
    }

    @Override
    public void selectElements(List<? extends ISelectionRequest> selectionRequests) {
        List children = this.getChildren();
        HashMap<String, PEPlanElement> planElements = new HashMap<String, PEPlanElement>(children.size() * 2);
        for (EditPart editPart : children) {
            if (!(editPart instanceof PEPlanElement)) continue;
            PEPlanElement pEPlanElement = (PEPlanElement)editPart;
            planElements.put(pEPlanElement.getPlanElementUID(), pEPlanElement);
        }
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof PATCHED_ScrollingGraphicalViewer) {
            ((PATCHED_ScrollingGraphicalViewer)viewer).deselectAllFromMachine();
        } else {
            this.getViewer().deselectAll();
        }
        for (ISelectionRequest iSelectionRequest : selectionRequests) {
            PEPlanElement pEPlanElement;
            if (iSelectionRequest == null || (pEPlanElement = (PEPlanElement)planElements.get(iSelectionRequest.getPlanElementUID())) == null) continue;
            this.getViewer().appendSelection((EditPart)pEPlanElement);
        }
    }

    @Override
    public void setInvalidPlanElements(List<? extends IInvalidPlanElement> invalidPlanElements) {
        if (this.externalSyntaxChecker != null) {
            this.externalSyntaxChecker.setInvalidPlanElements(invalidPlanElements);
        }
    }

    public ExternalSyntaxChecker getExternalSyntaxChecker() {
        return this.externalSyntaxChecker;
    }

    @Override
    public void zoomChanged(double newZoom) {
        this.refresh();
    }

    public String toString() {
        String name = this.getPMPlan().getName();
        String uid = this.getPMPlan().getUid();
        String type = this.getPMPlan().getType();
        return "PEPlan (" + name + ", " + type + ", " + uid + ")";
    }

    @Override
    public IInputContext getInputContext() {
        return this.inputContext;
    }

    @Override
    public void updateDecorators() {
        boolean refreshNeeded = false;
        IPlanEditorControllerExtension editorController = this.getViewMgr().getEditDomain().getEditorController();
        for (Object editPart : this.getChildren()) {
            if (!(editPart instanceof PEPlanElement)) continue;
            PEPlanElement pePlanElement = (PEPlanElement)editPart;
            PMPlanElement pmPlanElement = pePlanElement.getPMPlanElement();
            Image swtDecorator = editorController.getDecorator((IPlanAgentPlanElement)pePlanElement);
            PMDecorator currentDecorator = pmPlanElement.getDecorator();
            if (swtDecorator == null) {
                if (currentDecorator == null) continue;
                pmPlanElement.setDecorator(null);
                refreshNeeded |= true;
                continue;
            }
            Point dpi = Display.getDefault().getDPI();
            org.eclipse.swt.graphics.Rectangle swtDecoratorBoundsInPixel = swtDecorator.getBounds();
            double swtDecoratorWidthInInch = (double)swtDecoratorBoundsInPixel.width / (double)dpi.x;
            double swtDecoratorHeightInInch = (double)swtDecoratorBoundsInPixel.height / (double)dpi.y;
            Dimension decoratorSizeInPlanUnits = new Dimension(swtDecoratorWidthInInch / 39.37007874015748 * 1000.0, swtDecoratorHeightInInch / 39.37007874015748 * 1000.0);
            Rectangle projectionArea = pmPlanElement.getProjectionArea();
            com.arcway.lib.geometry.Point lowerRight = projectionArea.lowerRight.movePoint(DECORATOR_OFFSET_IN_PLANUNITS.turn180());
            com.arcway.lib.geometry.Point upperLeft = lowerRight.movePoint(new GeoVector(-decoratorSizeInPlanUnits.width, -decoratorSizeInPlanUnits.height));
            Rectangle position = new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x, lowerRight.y);
            if (currentDecorator != null && currentDecorator.getImageBaseObject().equals(swtDecorator) && currentDecorator.getPosition().equalsRectangle(position)) continue;
            SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(swtDecorator, false, null);
            PMDecorator decorator = new PMDecorator(pmPlanElement, position, (IOffscreenBitmap)swtOffscreenBitmap, (Object)swtDecorator);
            pmPlanElement.setDecorator(decorator);
            refreshNeeded |= true;
        }
        if (refreshNeeded) {
            this.refresh();
        }
    }
}

