/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlanElement;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.handles.IHandleLine;
import com.arcway.planagent.planeditor.handles.IHandleOutline;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planview.view.HighlightHint;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;

public abstract class PEFigure
extends PEPlanObject
implements IPlanEditorPlanElement {
    private static final HighlightHint HIGHLIGHTHINT_PROJECTIONMODE_UNSELECTED = HighlightHint.EMPTY;
    private static final HighlightHint HIGHLIGHTHINT_PROJECTIONMODE_SELECTED = new HighlightHint(new Color(0, 122, 255).gotoWhite(0.4), 1.0, Color.BLUE.gotoWhite(0.0), 0.8, false);
    private static final HighlightHint HIGHLIGHTHINT_EDITMODE_UNSELECTED = HighlightHint.EMPTY;
    private static final HighlightHint HIGHLIGHTHINT_EDITMODE_SELECTED = HighlightHint.EMPTY;
    private EditPartListener planElementSelectionListener = null;

    public PMFigure getPMFigure() {
        return (PMFigure)this.getPMPlanObject();
    }

    public PEPlanElement getPEPlanElement() {
        return (PEPlanElement)this.getParent();
    }

    @Override
    public PEPlan getPEPlan() {
        return this.getPEPlanElement().getPEPlan();
    }

    public Collection<PEGraphicalSupplement> getPEGraphicalSupplements() {
        ArrayList<PEGraphicalSupplement> supplements = new ArrayList<PEGraphicalSupplement>();
        for (EditPart child : this.getChildren()) {
            if (!(child instanceof PEGraphicalSupplement)) continue;
            supplements.add((PEGraphicalSupplement)child);
        }
        return supplements;
    }

    @Override
    protected List<IPMViewableRO> getModelChildren() {
        ArrayList<IPMViewableRO> list = new ArrayList<IPMViewableRO>();
        PMFigure pMFigure = this.getPMFigure();
        int i = 0;
        while (i < pMFigure.getGraphicalSupplementCount()) {
            list.add((IPMViewableRO)pMFigure.getGraphicalSupplement(i));
            ++i;
        }
        return list;
    }

    @Override
    public void activate() {
        super.activate();
        if (this.highlightOnSelection()) {
            this.planElementSelectionListener = new EditPartListener.Stub(){

                public void selectedStateChanged(EditPart part) {
                    PEFigure.this.refreshVisuals();
                    PEFigure.this.getFigure().repaint();
                }
            };
            this.getParent().addEditPartListener(this.planElementSelectionListener);
        }
    }

    @Override
    public void deactivate() {
        if (this.planElementSelectionListener != null) {
            this.getParent().removeEditPartListener(this.planElementSelectionListener);
            this.planElementSelectionListener = null;
        }
        super.deactivate();
    }

    @Override
    protected void refreshVisuals() {
        HighlightHint selectionHint;
        HighlightHint modelHint = new HighlightHint();
        IPMPlanElementRO pe = this.getPMFigure().getPlanElementRO();
        if (!pe.getHighlights().isEmpty()) {
            boolean isSelected = this.getPEPlanElement().getSelected() != 0;
            boolean isEditMode = this.getPEPlan().getMode() == 1;
            Object highlightLevel = isEditMode && isSelected ? null : HighlightLevel.BLINKER;
            SortedMap modelHints = ViewCreator.createHighlightHint((SortedMap)pe.getHighlights());
            modelHint = HighlightHint.stack((SortedMap)modelHints, (HighlightLevel)highlightLevel);
        }
        HighlightHint realHint = (selectionHint = this.getHighlightHintForSelection()) == null ? selectionHint : HighlightHint.stack((IHighlightHint)modelHint, (IHighlightHint)selectionHint);
        this.outputUpdater.refreshVisuals((IHighlightHint)realHint);
    }

    private boolean isSelected() {
        return this.getPEPlanElement().getSelected() != 0;
    }

    private HighlightHint getHighlightHintForSelection() {
        return this.getDefaultHighlightHint(this.isSelected());
    }

    private boolean highlightOnSelection() {
        return this.getDefaultHighlightHint(true) != this.getDefaultHighlightHint(false);
    }

    private HighlightHint getDefaultHighlightHint(boolean selected) {
        HighlightHint defaultHighlightHint;
        switch (this.getPEPlan().getMode()) {
            case 3: {
                if (selected) {
                    defaultHighlightHint = HIGHLIGHTHINT_PROJECTIONMODE_SELECTED;
                    break;
                }
                defaultHighlightHint = HIGHLIGHTHINT_PROJECTIONMODE_UNSELECTED;
                break;
            }
            case 1: {
                if (selected) {
                    defaultHighlightHint = HIGHLIGHTHINT_EDITMODE_SELECTED;
                    break;
                }
                defaultHighlightHint = HIGHLIGHTHINT_EDITMODE_UNSELECTED;
                break;
            }
            default: {
                defaultHighlightHint = HIGHLIGHTHINT_PROJECTIONMODE_UNSELECTED;
                assert (false) : "unknown editor mode";
                break;
            }
        }
        return defaultHighlightHint;
    }

    public boolean isSelectable() {
        return this.getPEPlanElement().isFigureSelectable(this);
    }

    @Override
    public EditPart getSelectionTarget() {
        PEFigure target = this.getPEPlanElement().getEditFigure();
        if (target == null) {
            target = super.getSelectionTarget();
        }
        return target;
    }

    @Override
    public List<IHandlePoint> getPointHandles() {
        List<IHandlePoint> pointHandles = super.getPointHandles();
        pointHandles.addAll(((PEPlanElement)this.getParent()).getPointHandlesFor(this));
        return pointHandles;
    }

    @Override
    public List<IHandleLine> getLineHandles() {
        List<IHandleLine> pointHandles = super.getLineHandles();
        pointHandles.addAll(((PEPlanElement)this.getParent()).getLineHandlesFor(this));
        return pointHandles;
    }

    @Override
    public List<IHandleOutline> getOutlineHandles() {
        List<IHandleOutline> pointHandles = super.getOutlineHandles();
        pointHandles.addAll(((PEPlanElement)this.getParent()).getOutlineHandlesFor(this));
        return pointHandles;
    }

    public IPlanEditorControllerExtension getPlanEditorControllerExtension() {
        PEPlanElement planElement = this.getPEPlanElement();
        return planElement == null ? null : planElement.getPlanEditorControllerExtension();
    }

    public String getPlanElementUID() {
        return this.getPEPlanElement().getPlanElementUID();
    }

    public String getPlanElementName() {
        return this.getPEPlanElement().getPlanElementName();
    }

    public String getPlanElementDescription() {
        return this.getPEPlanElement().getPlanElementDescription();
    }

    public String getPlanElementAspectID() {
        return this.getPEPlanElement().getPlanElementAspectID();
    }

    public String getPlanElementTypeID() {
        return this.getPEPlanElement().getPlanElementTypeID();
    }

    public Collection<TemplateApplicationTuple> getTemplateApplicationTuples() {
        ArrayList<TemplateApplicationTuple> tuples = new ArrayList<TemplateApplicationTuple>();
        for (PEGraphicalSupplement supplement : this.getPEGraphicalSupplements()) {
            tuples.addAll(supplement.getTemplateApplicationTuples());
        }
        return tuples;
    }
}

