/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackCreationTool;
import com.arcway.planagent.planeditor.figures.PFDifferentLayerViewFigure;
import com.arcway.planagent.planeditor.figures.PFPlan;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class FeedbackManager {
    private static final ILogger logger = Logger.getLogger(FeedbackManager.class);
    private final EditMgr viewManager;
    private final PFPlan planFigure;
    private final IFigure feedbackLayer;
    private PFDifferentLayerViewFigure feedback = null;

    public FeedbackManager(EditMgr viewManager, PFPlan planFigure, IFigure feedbackLayer) {
        if (logger.isTraceEnabled()) {
            logger.trace("FeedbackManager(ViewMgr viewManager = " + viewManager + ", IFigure feedbackLayer = " + feedbackLayer + ") - start");
        }
        assert (viewManager != null) : "viewManager is null";
        assert (planFigure != null) : "planFigure is null";
        assert (feedbackLayer != null) : "feedbackLayer is null";
        this.viewManager = viewManager;
        this.planFigure = planFigure;
        this.feedbackLayer = feedbackLayer;
        if (logger.isTraceEnabled()) {
            logger.trace("FeedbackManager(ViewMgr, IFigure) - end");
        }
    }

    public void showTargetFeedback(Command command) {
        if (logger.isTraceEnabled()) {
            logger.trace("showTargetFeedback(Command command = " + command + ") - start");
        }
        this.removeFeedback();
        this.feedback = this.createFeedback(command);
        if (this.feedback != null) {
            Rectangle bounds = this.feedback.getOuterBoundsBeforeAddingToLayer(this.feedbackLayer);
            if (bounds == null) {
                this.feedback = null;
            } else {
                this.feedback.setBounds(bounds);
                this.feedbackLayer.add((IFigure)this.feedback);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("showTargetFeedback(Command) - end");
        }
    }

    private PFDifferentLayerViewFigure createFeedback(Command command) {
        TransactionCommand taCommand;
        if (logger.isTraceEnabled()) {
            logger.trace("createFeedback(Command command = " + command + ") - start");
        }
        PFDifferentLayerViewFigure feedbackFigure = null;
        if (command != null && command instanceof TransactionCommand && (taCommand = (TransactionCommand)command).canExecute()) {
            feedbackFigure = FeedbackCreationTool.createFigure(this.viewManager, this.planFigure, taCommand.getTransaction());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("createFeedback(Command) - end - return value = " + feedbackFigure);
        }
        return feedbackFigure;
    }

    private void removeFeedback() {
        if (logger.isTraceEnabled()) {
            logger.trace("removeFeedback() - start");
        }
        if (this.feedback != null) {
            this.feedbackLayer.remove((IFigure)this.feedback);
            this.feedback = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("removeFeedback() - end");
        }
    }

    public void eraseTargetFeedback() {
        if (logger.isTraceEnabled()) {
            logger.trace("eraseTargetFeedback() - start");
        }
        this.removeFeedback();
        if (logger.isTraceEnabled()) {
            logger.trace("eraseTargetFeedback() - end");
        }
    }
}

