/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.actions.UICopyAsEMFAction;
import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.check.ISyntaxChecker;
import com.arcway.planagent.planeditor.check.ISyntaxProblemListener;
import com.arcway.planagent.planeditor.check.SyntaxChecker;
import com.arcway.planagent.planeditor.commands.CommandExecuter;
import com.arcway.planagent.planeditor.commands.RQCreatePlanElementStructureAsCopy;
import com.arcway.planagent.planeditor.commands.RQCut;
import com.arcway.planagent.planeditor.dnd.PlanTemplateTransfer;
import com.arcway.planagent.planeditor.edit.IClipboard;
import com.arcway.planagent.planeditor.edit.IZoomChangedListener;
import com.arcway.planagent.planeditor.edit.IZoomMgr;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.framecom.FrameComUtilities;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import com.arcway.planagent.planeditor.tools.IRequestUpdateCallback;
import com.arcway.planagent.planeditor.tools.PlaceTool;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planview.view.IViewPartMgr;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import de.plans.lib.eclipse.MultipleObjectSWTTransferContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EditMgr
implements IViewPartMgr,
IZoomMgr,
IClipboard,
ICheckMgr {
    private static final ILogger logger = Logger.getLogger(EditMgr.class);
    private static final double MAX_ZOOM = 50.0;
    private static final double MIN_ZOOM = 0.1;
    private static final int MIN_VIEWPORT_DIMENSION = 5;
    public static final double DPI_X = Display.getDefault().getDPI().x;
    public static final double DPI_Y = Display.getDefault().getDPI().y;
    public static final double PIXEL_PER_METER_X = DPI_X / 0.0254;
    public static final double PIXEL_PER_METER_Y = DPI_Y / 0.0254;
    public static final double PIXEL_PER_PLANUNIT_X = PIXEL_PER_METER_X / 1000.0;
    public static final double PIXEL_PER_PLANUNIT_Y = PIXEL_PER_METER_Y / 1000.0;
    private static final GeoVector SCALING_PLAN_TO_CANVAS_IN_100_PERCENT = new GeoVector(PIXEL_PER_PLANUNIT_X, PIXEL_PER_PLANUNIT_Y);
    private static final double ADDITIONAL_BORDER_TO_PREVENT_SCROLLBARS = 2.0;
    private static final double ZOOM_SNAP = 0.25;
    private static final double ZOOM_IN_ZOOM_OUT_FACTOR = 0.75;
    private static final boolean SYNTAX_CHECK_INITIALLY_ENABLED = false;
    private TransformationAffiliate trafoCanvas2Plan;
    private TransformationAffiliate trafoPlan2Canvas;
    private FigureCanvas canvas;
    private PEPlan plan;
    private final PlaceTool pasteTool = new PlaceTool();
    private PlanEditorEditDomain editDomain;
    private Clipboard clipboard;
    private double zoom = 0.75;
    private final List<IZoomChangedListener> zoomListeners = new ArrayList<IZoomChangedListener>();
    private HashMap<ISyntaxProblem, ISyntaxChecker> problemCheckerMapping = new HashMap(0);
    private final List<ISyntaxProblemListener> problemListeners = new ArrayList<ISyntaxProblemListener>();
    private boolean syntaxCheckEnabled = false;
    private final Shell editorShell;

    public EditMgr(Shell editorShell) {
        this.editorShell = editorShell;
        this.setZoom(1.0);
    }

    public void setup(PlanEditorEditDomain editDomain) {
        this.editDomain = editDomain;
        this.clipboard = new Clipboard(editDomain.getDisplay());
        MultipleObjectTransferAgent.getInstance().getSupportedTypes();
        PlanTemplateTransfer.getInstance().getSupportedTypes();
        FileTransfer.getInstance().getSupportedTypes();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    @Override
    public double setZoom(double newZoom) {
        if (this.canvas == null) {
            this.zoom = newZoom;
            this.setTransformationPlan2Canvas(EditMgr.getZoomTransformation(newZoom));
            return newZoom;
        }
        Viewport port = this.canvas.getViewport();
        return this.setZoom(newZoom, (double)port.getSize().width / 2.0, (double)port.getSize().height / 2.0, true);
    }

    @Override
    public double setZoom(double zoom, double viewX, double viewY, boolean adjustToCenter) {
        double oldZoom = this.zoom;
        double newZoom = zoom;
        this.editorShell.setCursor(Cursors.WAIT);
        if (newZoom < 0.1) {
            newZoom = 0.1;
        }
        if (newZoom > 50.0) {
            newZoom = 50.0;
        }
        this.zoom = newZoom;
        double oldViewLocationX = 0.0;
        double oldViewLocationY = 0.0;
        if (this.canvas != null) {
            Viewport port = this.canvas.getViewport();
            port.validate();
            oldViewLocationX = port.getViewLocation().x;
            oldViewLocationY = port.getViewLocation().y;
        }
        this.setTransformationPlan2Canvas(EditMgr.getZoomTransformation(newZoom));
        this.fireZoomChanged();
        if (this.canvas != null) {
            double ny;
            double nx;
            double realzoomfactor = zoom / oldZoom;
            Viewport port = this.canvas.getViewport();
            port.validate();
            if (adjustToCenter) {
                nx = (viewX + oldViewLocationX) * realzoomfactor - (double)port.getSize().width / 2.0;
                ny = (viewY + oldViewLocationY) * realzoomfactor - (double)port.getSize().height / 2.0;
            } else {
                nx = (viewX + oldViewLocationX) * realzoomfactor - viewX;
                ny = (viewY + oldViewLocationY) * realzoomfactor - viewY;
            }
            port.setViewLocation((int)Math.round(nx), (int)Math.round(ny));
        }
        this.editorShell.setCursor(null);
        return newZoom;
    }

    @Override
    public double setCalculatedZoom(double x, double y, double width, double height, double borderInPixel) {
        double zoomYFactor;
        double zoomXFactor;
        Dimension refSize = this.canvas.getViewport().getSize();
        refSize.height -= (int)Math.ceil(2.0 * borderInPixel + 1.0E-10);
        refSize.width -= (int)Math.ceil(2.0 * borderInPixel + 1.0E-10);
        if (refSize.height < 5) {
            refSize.height = 5;
        }
        if (refSize.width < 5) {
            refSize.width = 5;
        }
        double smallerZoomFactor = (zoomXFactor = (double)refSize.width * this.zoom / width) < (zoomYFactor = (double)refSize.height * this.zoom / height) ? zoomXFactor : zoomYFactor;
        return this.setZoom(smallerZoomFactor, width / 2.0 + x, height / 2.0 + y, true);
    }

    private RootEditPart getRootEditPart() {
        RootEditPart rootEditPart = null;
        if (this.plan != null) {
            rootEditPart = this.plan.getRoot();
        }
        return rootEditPart;
    }

    public Rectangle getVisiblePlanClipInPlanCoordinates() {
        Rectangle clippingRectangleInWindowCoordinates = new Rectangle(0.0, 0.0, (double)this.getCanvas().getViewport().getHorizontalRangeModel().getExtent(), (double)this.getCanvas().getViewport().getVerticalRangeModel().getExtent());
        boolean validateViewport = false;
        com.arcway.lib.geometry.Point upperLeftInPlanCoordinates = this.transformWindowToPlanCoordinates(clippingRectangleInWindowCoordinates.upperLeft, this.plan.getRoot(), validateViewport);
        com.arcway.lib.geometry.Point lowerRightInPlanCoordinates = this.transformWindowToPlanCoordinates(clippingRectangleInWindowCoordinates.lowerRight, this.plan.getRoot(), validateViewport);
        return new Rectangle(upperLeftInPlanCoordinates, lowerRightInPlanCoordinates);
    }

    @Override
    public double setCalculatedZoom(int fitConstant) {
        RootEditPart rootEditPart = this.getRootEditPart();
        double newZoom = this.getZoom();
        if (rootEditPart != null && this.plan != null) {
            Rectangle newWindowCoordinatesInWindowCoordinates;
            Rectangle planContentBoundsInWindowCoordinates = null;
            Rectangle planFigureBounds = this.plan.getPFPlan().getContentSize();
            if (planFigureBounds != null) {
                planContentBoundsInWindowCoordinates = new Rectangle(this.transformFigureToWindowCoordinates(planFigureBounds.upperLeft, rootEditPart, true), this.transformFigureToWindowCoordinates(planFigureBounds.lowerRight, rootEditPart, true));
            }
            double borderInPixels = 0.0;
            Viewport port = this.canvas.getViewport();
            port.validate();
            Rectangle oldWindowCoordinates = new Rectangle(0.0, 0.0, (double)this.getCanvas().getViewport().getHorizontalRangeModel().getExtent(), (double)this.getCanvas().getViewport().getVerticalRangeModel().getExtent());
            if (planContentBoundsInWindowCoordinates != null && !Geo.equals((double)oldWindowCoordinates.w(), (double)0.0) && !Geo.equals((double)oldWindowCoordinates.h(), (double)0.0)) {
                switch (fitConstant) {
                    case 0: {
                        if (oldWindowCoordinates.isInside(planContentBoundsInWindowCoordinates)) {
                            newWindowCoordinatesInWindowCoordinates = null;
                            break;
                        }
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(planContentBoundsInWindowCoordinates);
                        borderInPixels = 22.0;
                        break;
                    }
                    case 1: {
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(planContentBoundsInWindowCoordinates);
                        borderInPixels = 22.0;
                        break;
                    }
                    case 2: {
                        oldWindowCoordinates = new Rectangle(0.0, 0.0, (double)this.getCanvas().getViewport().getHorizontalRangeModel().getExtent(), (double)this.getCanvas().getViewport().getVerticalRangeModel().getExtent());
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(planContentBoundsInWindowCoordinates.upperLeft.x, oldWindowCoordinates.y() + oldWindowCoordinates.h() / 2.0, planContentBoundsInWindowCoordinates.lowerRight.x, oldWindowCoordinates.y() + oldWindowCoordinates.h() / 2.0);
                        borderInPixels = 22.0;
                        break;
                    }
                    case 3: {
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(oldWindowCoordinates.x() + oldWindowCoordinates.w() / 2.0, planContentBoundsInWindowCoordinates.upperLeft.y, oldWindowCoordinates.x() + oldWindowCoordinates.w() / 2.0, planContentBoundsInWindowCoordinates.lowerRight.y);
                        borderInPixels = 22.0;
                        break;
                    }
                    case 4: {
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(planContentBoundsInWindowCoordinates.center(), oldWindowCoordinates.getDimension());
                        break;
                    }
                    default: {
                        newWindowCoordinatesInWindowCoordinates = new Rectangle(planContentBoundsInWindowCoordinates);
                        break;
                    }
                }
            } else {
                newWindowCoordinatesInWindowCoordinates = null;
            }
            if (newWindowCoordinatesInWindowCoordinates != null) {
                newZoom = this.setCalculatedZoom(newWindowCoordinatesInWindowCoordinates.upperLeft.x, newWindowCoordinatesInWindowCoordinates.upperLeft.y, newWindowCoordinatesInWindowCoordinates.w(), newWindowCoordinatesInWindowCoordinates.h(), borderInPixels);
            }
        }
        return newZoom;
    }

    @Override
    public void addZoomChangedListener(IZoomChangedListener listener) {
        assert (listener != null) : "listener is null";
        this.zoomListeners.add(listener);
    }

    @Override
    public void removeZoomChangedListener(IZoomChangedListener listener) {
        assert (listener != null) : "listener is null";
        if (!this.zoomListeners.contains(listener)) {
            logger.warn("listener to remove (" + listener + ") is not registerd");
        }
        this.zoomListeners.remove(listener);
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    private void fireZoomChanged() {
        int i = 0;
        while (i < this.zoomListeners.size()) {
            this.zoomListeners.get(i).zoomChanged(this.zoom);
            ++i;
        }
    }

    public IZoomMgr getZoomMgr() {
        return this;
    }

    protected static TransformationAffiliate getZoomTransformation(double zoom) {
        GeoVector scale = SCALING_PLAN_TO_CANVAS_IN_100_PERCENT.scale(zoom);
        return TransformationAffiliate.newTransformationScaling((GeoVector)scale);
    }

    public TransformationAffiliate getTransformationCanvas2Plan() {
        return this.trafoCanvas2Plan;
    }

    public TransformationAffiliate getTransformationPlan2Canvas() {
        return this.trafoPlan2Canvas;
    }

    public int getHitTestingToleranceInCanvasCoordinates() {
        return 3;
    }

    private void setTransformationPlan2Canvas(TransformationAffiliate trafoPlan2Canvas) {
        this.trafoCanvas2Plan = trafoPlan2Canvas.getInverse();
        this.trafoPlan2Canvas = trafoPlan2Canvas;
    }

    public FigureCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(FigureCanvas canvas) {
        this.canvas = canvas;
    }

    public void setPlan(PEPlan plan) {
        this.plan = plan;
    }

    public GeoVector getScrollOffset(boolean validateViewPort) {
        if (this.canvas != null) {
            Viewport viewport = this.canvas.getViewport();
            if (validateViewPort) {
                viewport.validate();
            }
            return new GeoVector((double)viewport.getHorizontalRangeModel().getValue(), (double)viewport.getVerticalRangeModel().getValue());
        }
        logger.info("getScrollOffset() - scroll offset requested, but no canvas configured");
        return GeoVector.NULL;
    }

    public com.arcway.lib.geometry.Point transformWindowToPlanCoordinates(com.arcway.lib.geometry.Point point, RootEditPart rootEditPart, boolean validateViewport) {
        GeoVector scrollOffset = this.getScrollOffset(validateViewport);
        com.arcway.lib.geometry.Point pointInCanvasCoordinates = new com.arcway.lib.geometry.Point(point.x + scrollOffset.x, point.y + scrollOffset.y);
        double draw2dZoom = 1.0;
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ZoomManager zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
            draw2dZoom = zoomManager.getZoom();
        }
        com.arcway.lib.geometry.Point pointInFigureCoordinates = new com.arcway.lib.geometry.Point(pointInCanvasCoordinates.x / draw2dZoom, pointInCanvasCoordinates.y / draw2dZoom);
        return pointInFigureCoordinates.transform((Transformation)this.getTransformationCanvas2Plan());
    }

    public com.arcway.lib.geometry.Point transformPlanToWindowCoordinates(com.arcway.lib.geometry.Point point, RootEditPart rootEditPart, boolean validateViewPort) {
        com.arcway.lib.geometry.Point pointInFigureCoordinates = point.transform((Transformation)this.getTransformationPlan2Canvas());
        return this.transformFigureToWindowCoordinates(pointInFigureCoordinates, rootEditPart, validateViewPort);
    }

    private com.arcway.lib.geometry.Point transformFigureToWindowCoordinates(com.arcway.lib.geometry.Point pointInFigureCoordinates, RootEditPart rootEditPart, boolean validateViewPort) {
        double draw2dZoom = 1.0;
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ZoomManager zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
            draw2dZoom = zoomManager.getZoom();
        }
        com.arcway.lib.geometry.Point pointInCanvasCoordinates = new com.arcway.lib.geometry.Point(pointInFigureCoordinates.x * draw2dZoom, pointInFigureCoordinates.y * draw2dZoom);
        GeoVector scrollOffset = this.getScrollOffset(validateViewPort);
        com.arcway.lib.geometry.Point pointInWindowCoordinates = new com.arcway.lib.geometry.Point(pointInCanvasCoordinates.x - scrollOffset.x, pointInCanvasCoordinates.y - scrollOffset.y);
        return pointInWindowCoordinates;
    }

    @Override
    public void copy(List<PEPlanEditPart> elements) {
        try {
            ArrayList<MultipleObjectTransferContent> nativeContents = new ArrayList<MultipleObjectTransferContent>();
            List<PMPlanElement> models = IIUtilities.getRelatedPMPlanElements(elements, null);
            PMPlan planCopy = this.plan.getPMPlan().getCut(models);
            nativeContents.add(new MultipleObjectTransferContent((Object)planCopy, (AbstractTransferAgentForMultipleObjectTransfer)PlanTemplateTransfer.getInstance()));
            StringBuilder planElementNamesBuilder = new StringBuilder();
            if (models != null) {
                for (IPMPlanElementRO iPMPlanElementRO : models) {
                    String name = iPMPlanElementRO.getName();
                    if (name == null || (name = name.trim()).length() <= 0) continue;
                    planElementNamesBuilder.append(StringUtil.CRLF);
                    planElementNamesBuilder.append(name);
                }
            }
            List list = FrameComUtilities.transformModelsToIPlanElements(models);
            Collection frameNativeContents = this.editDomain.getEditorController().getNativeContentToAdd(list);
            nativeContents.addAll(frameNativeContents);
            Object[] copyObjects = new Object[nativeContents.size() + 3];
            Transfer[] transferObjects = new Transfer[nativeContents.size() + 3];
            copyObjects[0] = nativeContents;
            transferObjects[0] = MultipleObjectTransferAgent.getInstance();
            MultipleObjectSWTTransferContent emfContent = UICopyAsEMFAction.copyAsEMF(this.editorShell, (GraphicalViewer)this.plan.getViewer(), new IEditorContent(){

                public IPlanInfo getPlanInfo() {
                    return EditMgr.this.editDomain.getInternalPlanController().getPlanInfo();
                }

                public IPMPlanRO getPlanModel() {
                    return EditMgr.this.plan.getPMPlan();
                }
            });
            if (emfContent != null) {
                copyObjects[1] = emfContent.getObjectToTransfer();
                transferObjects[1] = emfContent.getTransferAgent();
            }
            copyObjects[2] = String.valueOf(Messages.getString("EditMgr.copyHint1")) + this.plan.getPlanName() + StringUtil.CRLF + Messages.getString("EditMgr.copyHint2") + planElementNamesBuilder.toString() + StringUtil.CRLF;
            transferObjects[2] = TextTransfer.getInstance();
            int i = 3;
            for (MultipleObjectTransferContent content : nativeContents) {
                copyObjects[i] = content.getObjectToTransfer();
                transferObjects[i] = content.getTransferAgent();
                ++i;
            }
            this.clipboard.setContents(copyObjects, transferObjects);
        }
        catch (EXPlanCreationException e) {
            logger.warn("Could not create plan copy", (Throwable)e);
        }
    }

    @Override
    public void cut(List elements) {
        this.copy(elements);
        if (this.plan.getMode() != 1) {
            return;
        }
        RQCut cut = new RQCut(elements, 6);
        Command cmd = this.plan.getCommand(cut);
        CommandExecuter.execute(this.editDomain.getCommandStack(), cmd);
    }

    @Override
    public void paste() {
        if (this.plan.getMode() != 1) {
            return;
        }
        final Collection<MultipleObjectTransferContent> nativeContents = this.getNativeClipboardContent();
        final PMPlan planToPaste = (PMPlan)this.getPlanFromNativeContents(nativeContents);
        if (planToPaste == null || planToPaste.getOuterBounds() == null) {
            return;
        }
        IRequestUpdateCallback planPlacer = new IRequestUpdateCallback(){
            RQCreatePlanElementStructureAsCopy request;

            @Override
            public Request updateRequest(Point point) {
                if (this.request == null) {
                    this.request = new RQCreatePlanElementStructureAsCopy(3);
                    if (logger.isDebugEnabled(74)) {
                        logger.debug(74, "EditMgr - create request, request = " + (Object)((Object)this.request) + ", plan = " + planToPaste);
                    }
                    this.request.setPlan(planToPaste);
                    this.request.setNativeContent(nativeContents);
                    org.eclipse.swt.graphics.Point swtPoint = new org.eclipse.swt.graphics.Point(point.x, point.y);
                    this.request.setPosition(swtPoint);
                } else {
                    org.eclipse.swt.graphics.Point swtPoint = new org.eclipse.swt.graphics.Point(point.x, point.y);
                    this.request.setPosition(swtPoint);
                }
                return this.request;
            }
        };
        this.pasteTool.setPlanPlacer(planPlacer);
        this.editDomain.setActiveTool(this.pasteTool);
        this.pasteTool.triggerTools(this.getRootEditPart().getViewer());
    }

    @Override
    public boolean containsPastableObjects() {
        if (this.plan.getMode() != 1) {
            return false;
        }
        Collection<MultipleObjectTransferContent> nativeContents = this.getNativeClipboardContent();
        PMPlan planFromNativeContent = (PMPlan)this.getPlanFromNativeContents(nativeContents);
        return planFromNativeContent != null && planFromNativeContent.getOuterBounds() != null;
    }

    private Collection<MultipleObjectTransferContent> getNativeClipboardContent() {
        Collection<Object> multiContent = (List)this.clipboard.getContents((Transfer)MultipleObjectTransferAgent.getInstance());
        if (multiContent == null) {
            PlanTemplateTransfer transfer = PlanTemplateTransfer.getInstance();
            PMPlan planContent = (PMPlan)this.clipboard.getContents((Transfer)transfer);
            multiContent = planContent != null ? Collections.singleton(new MultipleObjectTransferContent((Object)planContent, (AbstractTransferAgentForMultipleObjectTransfer)PlanTemplateTransfer.getInstance())) : Collections.emptyList();
        }
        return multiContent;
    }

    private IPMPlanRO getPlanFromNativeContents(Collection<MultipleObjectTransferContent> nativeContents) {
        IPMPlanRO planFromNativeContent = null;
        Iterator<MultipleObjectTransferContent> i = nativeContents.iterator();
        while (planFromNativeContent == null && i.hasNext()) {
            MultipleObjectTransferContent nativeContent = i.next();
            if (!(nativeContent.getTransferAgent() instanceof PlanTemplateTransfer)) continue;
            planFromNativeContent = (IPMPlanRO)nativeContent.getObjectToTransfer();
        }
        return planFromNativeContent;
    }

    public IClipboard getClipboard() {
        return this;
    }

    public ICheckMgr getCheckMgr() {
        return this;
    }

    @Override
    public void registerSyntaxProblemListener(ISyntaxProblemListener listener) {
        assert (listener != null);
        this.problemListeners.add(listener);
    }

    @Override
    public void unregisterSyntaxProblemListener(ISyntaxProblemListener listener) {
        if (this.problemListeners == null) {
            return;
        }
        this.problemListeners.remove(listener);
    }

    private void notifyProblemListeners() {
        int i = 0;
        while (i < this.problemListeners.size()) {
            ISyntaxProblemListener listener = this.problemListeners.get(i);
            listener.syntaxProblemListChanged(this.problemCheckerMapping.keySet());
            ++i;
        }
    }

    @Override
    public void triggerSyntaxChecks() {
        if (this.plan != null && this.plan.isActive()) {
            this.problemCheckerMapping = SyntaxChecker.getInstance().checkSyntax(this.plan);
        }
        this.notifyProblemListeners();
    }

    @Override
    public void triggerSyntaxChecks(ISyntaxChecker changeHint) {
        this.triggerSyntaxChecks();
    }

    @Override
    public Collection<ISyntaxProblem> getAllSyntaxProblems() {
        return this.problemCheckerMapping.keySet();
    }

    @Override
    public IAction getActionForSyntaxProblem(PEPlan problematicPlan, ISyntaxProblem problem, ContextMenuContext context) {
        if (!this.problemCheckerMapping.containsKey(problem)) {
            throw new IllegalArgumentException("The given problem " + problem + " was not found. (Most likely it is old and was not taken from a recent list of problems.)");
        }
        ISyntaxChecker theChecker = this.problemCheckerMapping.get(problem);
        return theChecker.getActionForProblem(problematicPlan, problem, context);
    }

    public PlanEditorEditDomain getEditDomain() {
        return this.editDomain;
    }

    @Override
    public double zoomIn() {
        return this.setZoom(this.getZoomIncreased());
    }

    @Override
    public double zoomIn(double viewX, double viewY) {
        return this.setZoom(this.getZoomIncreased(), viewX, viewY, false);
    }

    @Override
    public double zoomOut() {
        return this.setZoom(this.getZoomDecreased());
    }

    private double getZoomIncreased() {
        double newAbsolutelyChangedZoom = this.getZoom() + 0.25;
        double newRelativelyChangedZoom = this.getZoom() / 0.75;
        newRelativelyChangedZoom = newRelativelyChangedZoom - newRelativelyChangedZoom % 0.25 + 0.25;
        return Math.max(newRelativelyChangedZoom, newAbsolutelyChangedZoom);
    }

    private double getZoomDecreased() {
        double newAbsolutelyChangedZoom = this.getZoom() - 0.25;
        double newRelativelyChangedZoom = this.getZoom() * 0.75;
        newRelativelyChangedZoom -= newRelativelyChangedZoom % 0.25;
        return Math.min(newRelativelyChangedZoom, newAbsolutelyChangedZoom);
    }

    @Override
    public boolean isSyntaxCheckEnabled() {
        return this.syntaxCheckEnabled;
    }

    @Override
    public void setSyntaxCheckEnabled(boolean enabled) {
        if (this.syntaxCheckEnabled != enabled) {
            this.syntaxCheckEnabled = enabled;
            this.notifyProblemListeners();
        }
    }
}

