/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.planeditor.IHelpContextIDs;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialog;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialogSettings;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsSVGDialogSettings;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import de.plans.lib.svg.SVGPrinter;
import java.io.File;
import java.util.Map;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SaveAsSVGDialog
extends AbstractSaveAsDialog {
    private static final String TITLE = Messages.getString("SaveAsSVGDialog.Image_setup");
    private static final String MESSAGE = Messages.getString("SaveAsSVGDialog.Configure_the_settings_for_the_target_image");
    protected static final int NR_OF_SVG_ITEMS = 11;
    private final SaveAsSVGDialogSettings settingsCopy;
    private final SaveAsSVGDialogSettings settings;

    public SaveAsSVGDialog(Shell parent, InternalDialogSettings internalSettings, SaveAsSVGDialogSettings settings, IEditorContent editorContent) {
        super(parent, internalSettings, editorContent);
        this.settingsCopy = new SaveAsSVGDialogSettings(settings);
        this.settings = settings;
        this.errors = new String[11][2];
        this.warnings = new String[11];
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpContextIDs.EDITOR_SVGEXPORTDIALOG);
        return super.createDialogArea(parent);
    }

    @Override
    protected AbstractSaveAsDialogSettings getSaveAsDialogSettings() {
        return this.settingsCopy;
    }

    @Override
    protected String getFileExtension() {
        return "svg";
    }

    @Override
    protected String saveAs() {
        SVGPrinter printer = (SVGPrinter)this.createPrinter();
        PrintingFailure failure = this.print((IPrinter)printer);
        if (failure == null) {
            this.getShell().setCursor(Cursors.WAIT);
            File file = this.settingsCopy.getFile();
            String justTheFileName = file.getName();
            File absolutePath = file.getParentFile();
            try {
                printer.saveSVGDirectly(absolutePath, justTheFileName);
            }
            catch (EXEmptyResult e) {
                failure = new PrintingFailure((Throwable)e);
            }
            this.getShell().setCursor(Cursors.ARROW);
        }
        this.disposePrinter((IPrinter)printer);
        String errorMsg = null;
        if (failure != null) {
            errorMsg = Messages.getString("SaveAsSVGDialog.Print_Failure_Text");
        }
        return errorMsg;
    }

    @Override
    protected Group addCustomGroup(Composite leftArea) {
        return null;
    }

    @Override
    protected String getExtendedErrorMessage(int index) {
        String toReturn = super.getExtendedErrorMessage(index);
        return toReturn;
    }

    @Override
    protected String getStdMessage() {
        return MESSAGE;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    public IPrinter createPrinter() {
        double wInMM = this.settingsCopy.getWidth();
        double hInMM = this.settingsCopy.getHeight();
        Map classIDMap = null;
        IPlanInfo planInfo = this.getEditorContent().getPlanInfo();
        if (planInfo != null) {
            classIDMap = planInfo.getDefaultElementRoles();
        }
        return new SVGPrinter(PageDescription.createPrintInfoInMM((double)wInMM, (double)hInMM, (Insets)this.settingsCopy.getPageSetup().getMargin()), false, classIDMap, null, null);
    }

    @Override
    public void disposePrinter(IPrinter printer) {
        ((SVGPrinter)printer).disposeImages();
    }

    @Override
    protected AbstractPreviewDialogSettings getSettings() {
        return this.settingsCopy;
    }

    @Override
    protected void readWidgetValues() {
        super.readWidgetValues();
    }

    @Override
    protected void updateSettings() {
        super.updateSettings();
        this.settingsCopy.setDimensions(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
    }

    @Override
    protected void writeWidgetValues() {
        super.writeWidgetValues();
    }

    @Override
    protected FrameViewConfig getFrameViewConfig(PageInfo pageInfo) {
        FrameViewConfig frameViewConfig = FrameViewConfig.createFrame((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
        return frameViewConfig;
    }

    @Override
    protected int limitPreviewPageWidth(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected int limitPreviewPageHeight(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected boolean printerDefinesPrintingArea() {
        return false;
    }

    @Override
    public void okPressed() {
        this.settings.copyFrom(this.settingsCopy);
        super.okPressed();
    }

    @Override
    protected boolean isAlignmentAreaToBeEnabled() {
        return false;
    }
}

