/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.IVariablePageSizeDeviceDriver;
import com.arcway.lib.graphics.print.PageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.graphics.print.VariablePageSizePrinter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialog;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialogSettings;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsMetafileDialogSettings;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class SaveAsMetafileDialog
extends AbstractSaveAsDialog {
    private static final ILogger logger = Logger.getLogger(SaveAsMetafileDialog.class);
    protected static final int NR_OF_METAFILE_ITEMS = 11;
    private final SaveAsMetafileDialogSettings settingsCopy;
    private final SaveAsMetafileDialogSettings settings;

    protected abstract String getHelpContextID();

    public SaveAsMetafileDialog(Shell parent, InternalDialogSettings internalSettings, SaveAsMetafileDialogSettings settings, IEditorContent editorContent) {
        super(parent, internalSettings, editorContent);
        this.settingsCopy = settings.getCopy();
        this.settings = settings;
        this.errors = new String[11][2];
        this.warnings = new String[11];
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextID());
        return super.createDialogArea(parent);
    }

    @Override
    protected AbstractSaveAsDialogSettings getSaveAsDialogSettings() {
        return this.settingsCopy;
    }

    @Override
    protected abstract String getFileExtension();

    @Override
    protected String saveAs() {
        VariablePageSizePrinter printer = (VariablePageSizePrinter)this.createPrinter();
        PrintingFailure failure = this.print((IPrinter)printer);
        if (failure == null) {
            this.getShell().setCursor(Cursors.WAIT);
            File file = this.settingsCopy.getFile();
            try {
                IDeviceDriverMetafile deviceDriverWMF = (IDeviceDriverMetafile)printer.getVariablePageSizeDeviceDriver();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                deviceDriverWMF.saveImageDirectly((OutputStream)byteArrayOutputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                boolean noWriteErrorOccured = false;
                try {
                    byteArrayOutputStream.writeTo(fileOutputStream);
                    noWriteErrorOccured = true;
                }
                finally {
                    if (noWriteErrorOccured) {
                        fileOutputStream.close();
                    } else {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception e) {
                            logger.debug("Problem wile closing Metafile Image File stream (probably caused by a previous error)", (Throwable)e);
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                failure = new PrintingFailure((Throwable)e);
            }
            catch (IOException e) {
                failure = new PrintingFailure((Throwable)e);
            }
            catch (EXEmptyResult e) {
                failure = new PrintingFailure((Throwable)e);
            }
            catch (PrintingFailure e) {
                failure = e;
            }
            this.getShell().setCursor(Cursors.ARROW);
        }
        this.disposePrinter((IPrinter)printer);
        String errorMsg = null;
        if (failure != null) {
            errorMsg = Messages.getString(this.getPrintFailureMessageID());
        }
        return errorMsg;
    }

    protected abstract String getPrintFailureMessageID();

    @Override
    protected Group addCustomGroup(Composite leftArea) {
        return null;
    }

    @Override
    protected String getExtendedErrorMessage(int index) {
        String toReturn = super.getExtendedErrorMessage(index);
        return toReturn;
    }

    protected abstract IDeviceDriverMetafile createDeviceDriver();

    @Override
    public IPrinter createPrinter() {
        double wInMM = this.settingsCopy.getDimension().w();
        double hInMM = this.settingsCopy.getDimension().h();
        IPageDescription pageDescription = PageDescription.createPrintInfoInMM((double)wInMM, (double)hInMM, (Insets)this.settingsCopy.getPageSetup().getMargin());
        IDeviceDriverMetafile deviceDriver = this.createDeviceDriver();
        return new VariablePageSizePrinter((IVariablePageSizeDeviceDriver)deviceDriver, pageDescription);
    }

    @Override
    public void disposePrinter(IPrinter printer) {
        VariablePageSizePrinter variablePageSizePrinter = (VariablePageSizePrinter)printer;
        IDeviceDriverMetafile deviceDriverWMF = (IDeviceDriverMetafile)variablePageSizePrinter.getVariablePageSizeDeviceDriver();
        variablePageSizePrinter.dispose();
        deviceDriverWMF.dispose();
        deviceDriverWMF = null;
    }

    @Override
    protected AbstractPreviewDialogSettings getSettings() {
        return this.settingsCopy;
    }

    @Override
    protected void readWidgetValues() {
        super.readWidgetValues();
    }

    @Override
    protected void updateSettings() {
        super.updateSettings();
        this.settingsCopy.setDimension(new Rectangle(0.0, 0.0, this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension()));
    }

    @Override
    protected void writeWidgetValues() {
        super.writeWidgetValues();
    }

    @Override
    protected FrameViewConfig getFrameViewConfig(PageInfo pageInfo) {
        FrameViewConfig frameViewConfig = FrameViewConfig.createFrame((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
        return frameViewConfig;
    }

    @Override
    protected int limitPreviewPageWidth(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected int limitPreviewPageHeight(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected boolean printerDefinesPrintingArea() {
        return false;
    }

    @Override
    public void okPressed() {
        this.settings.copyFrom(this.settingsCopy);
        super.okPressed();
    }

    @Override
    protected boolean isAlignmentAreaToBeEnabled() {
        return false;
    }
}

