/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.planagent.planeditor.Messages;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PrintPreviewCanvas
extends Canvas {
    public static final int PREVIEW_DISTANCE = 4;
    public static final int PREVIEW_HEIGHT = 360;
    public static final int PREVIEW_WIDTH = 360;
    private static final int PREVIEW_DUMMY = 0;
    private static final int PREVIEW_NO = 1;
    private static final int PREVIEW_STD = 2;
    private static final int PREVIEW_ERROR = 3;
    private static final int PREVIEW_PANIC = 4;
    private static final String DUMMY_PREVIEW = Messages.getString("PrintPreviewCanvas.Preview_is_only_available_for_up_to_24_pages");
    private static final String NO_PREVIEW = Messages.getString("PrintPreviewCanvas.Preview_is_not_activated");
    private static final String ERROR_PREVIEW = Messages.getString("PrintPreviewCanvas.Preview_is_not_available_for_invalid_settings");
    private static final String PANIC_PREVIEW = Messages.getString("PrintPreviewCanvas.Preview_error");
    private int previewMode = 2;
    private int rows;
    private Image[] images;
    private final Color lightGray = new Color((Device)Display.getCurrent(), 150, 150, 150);
    private final Color darkGray = new Color((Device)Display.getCurrent(), 100, 100, 100);
    private final Color black = new Color((Device)Display.getCurrent(), 0, 0, 0);

    public PrintPreviewCanvas(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PrintPreviewCanvas.this.widgetDisposed(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PrintPreviewCanvas.this.paintControl(e);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PrintPreviewCanvas.this.resize();
            }
        });
    }

    private void resize() {
        Point extent = this.computeSize(-1, -1, false);
        this.setBounds(8, 18, extent.x, extent.y);
    }

    private void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int x = 1;
        int y = 1;
        int imageWidth = 0;
        int ImageHeight = 0;
        if (this.images != null && this.images.length > 0 && this.previewMode == 2) {
            Image image0 = this.images[0];
            int totalWidth = (image0.getBounds().width + 4) * (this.images.length / this.rows);
            int totalHeight = (image0.getBounds().height + 4) * this.rows;
            x = (360 - totalWidth) / 2;
            y = (360 - totalHeight) / 2;
            imageWidth = image0.getBounds().width;
            ImageHeight = image0.getBounds().height;
            int r = 0;
            while (r < this.rows) {
                int i = r;
                while (i < this.images.length) {
                    gc.setForeground(this.lightGray);
                    gc.drawRectangle(x - 1, y - 1, imageWidth + 1, ImageHeight + 1);
                    gc.setForeground(this.darkGray);
                    gc.drawLine(x + imageWidth + 1, y + 2, x + imageWidth + 1, y + ImageHeight + 1);
                    gc.drawLine(x + 2, y + ImageHeight + 1, x + imageWidth + 1, y + ImageHeight + 1);
                    gc.drawImage(this.images[i], x, y);
                    x = x + imageWidth + 4;
                    i += this.rows;
                }
                x = (360 - totalWidth) / 2;
                y = y + ImageHeight + 4;
                ++r;
            }
        } else if (this.previewMode == 0 || this.previewMode == 1 || this.previewMode == 3 || this.previewMode == 4) {
            imageWidth = 357;
            ImageHeight = 337;
            gc.setForeground(this.black);
            if (this.previewMode == 1) {
                gc.drawString(NO_PREVIEW, x, y);
            } else if (this.previewMode == 0) {
                gc.drawString(DUMMY_PREVIEW, x, y);
            } else if (this.previewMode == 3) {
                gc.drawString(ERROR_PREVIEW, x, y);
            } else if (this.previewMode == 4) {
                gc.drawString(PANIC_PREVIEW, x, y);
            }
            y = 20;
            gc.setForeground(this.lightGray);
            gc.drawRectangle(x, y, imageWidth, ImageHeight);
            gc.setForeground(this.darkGray);
            gc.drawLine(x, y, x + imageWidth, y + ImageHeight);
            if (this.previewMode == 3) {
                gc.drawLine(x + imageWidth, y, x, y + ImageHeight);
            }
            gc.drawLine(x + imageWidth + 1, y + 2, x + imageWidth + 1, y + ImageHeight + 1);
            gc.drawLine(x + 2, y + ImageHeight + 1, x + imageWidth + 1, y + ImageHeight + 1);
        }
    }

    private void widgetDisposed(DisposeEvent e) {
        this.lightGray.dispose();
        this.darkGray.dispose();
        this.black.dispose();
        this.disposeImages();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(360, 360);
    }

    public void setImages(List imageList) {
        assert (imageList != null) : "imageList is null";
        this.disposeImages();
        if (!imageList.isEmpty()) {
            this.previewMode = 2;
            this.images = new Image[imageList.size()];
            int i = 0;
            while (i < imageList.size()) {
                this.images[i] = ((SWTOffscreenBitmap)((com.arcway.lib.graphics.image.Image)imageList.get(i)).getOffscreenBitmap()).getWrappedSWTImage();
                ++i;
            }
            this.resize();
            this.redraw();
        }
    }

    private void disposeImages() {
        if (this.images != null && this.images.length > 0) {
            Image[] imageArray = this.images;
            int n = this.images.length;
            int n2 = 0;
            while (n2 < n) {
                Image element = imageArray[n2];
                element.dispose();
                ++n2;
            }
            this.images = null;
        }
    }

    public void setRows(int i) {
        this.rows = i;
    }

    public void setDummyImage() {
        this.disposeImages();
        this.previewMode = 0;
        this.redraw();
    }

    public void setNoImage() {
        this.disposeImages();
        this.previewMode = 1;
        this.redraw();
    }

    public void setErrorImage() {
        this.disposeImages();
        this.previewMode = 3;
        this.redraw();
    }

    public void setPanicImage() {
        this.disposeImages();
        this.previewMode = 4;
        this.redraw();
    }
}

