/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PrintPlotterHelpCanvas
extends Canvas {
    private static final Image IMG_HH = ResourceLoader.getImageDescriptor((String)"hh.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()).createImage();
    private static final Image IMG_HV = ResourceLoader.getImageDescriptor((String)"hv.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()).createImage();
    private static final Image IMG_VH = ResourceLoader.getImageDescriptor((String)"vh.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()).createImage();
    private static final Image IMG_VV = ResourceLoader.getImageDescriptor((String)"vv.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()).createImage();
    public static final int PREVIEW_SIZE = Math.max(PrintPlotterHelpCanvas.IMG_HH.getImageData().width, PrintPlotterHelpCanvas.IMG_HH.getImageData().height);
    private static final int TRACTOR_WIDTH = 10;
    private static final int PREVIEW_SPACE = 30;
    private boolean rotation;
    private boolean portrait;
    private Image previewImage;
    private final Color lightGray = new Color((Device)Display.getCurrent(), 150, 150, 150);
    private final Color darkGray = new Color((Device)Display.getCurrent(), 100, 100, 100);
    private final Color black = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private final Color tractorBackground = new Color((Device)Display.getCurrent(), 130, 200, 240);
    private final Color tractorForeground = new Color((Device)Display.getCurrent(), 30, 30, 155);

    public PrintPlotterHelpCanvas(Composite parent, Image previewImage, int style, boolean rotation, boolean portrait) {
        super(parent, style);
        this.portrait = portrait;
        this.rotation = rotation;
        this.previewImage = previewImage;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PrintPlotterHelpCanvas.this.widgetDisposed(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PrintPlotterHelpCanvas.this.paintControl(e);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PrintPlotterHelpCanvas.this.resize();
            }
        });
        this.updateImage();
    }

    private void updateImage() {
        if (this.portrait) {
            // empty if block
        }
    }

    private void resize() {
        Point extent = this.computeSize(-1, -1, false);
        this.setBounds(this.getBounds().x, this.getBounds().y, extent.x, extent.y);
    }

    private void paintControl(PaintEvent e) {
        if (this.previewImage != null) {
            Image previewImageSWT = this.previewImage;
            int imageWidth = previewImageSWT.getBounds().width;
            int imageHeight = previewImageSWT.getBounds().height;
            int x = (this.getBounds().width - imageWidth) / 2;
            int y = (this.getBounds().height - imageHeight) / 2;
            GC gc = e.gc;
            gc.setForeground(this.lightGray);
            gc.drawRectangle(x - 1, y - 1, imageWidth + 1, imageHeight + 1);
            gc.setForeground(this.darkGray);
            gc.drawLine(x + imageWidth + 1, y + 2, x + imageWidth + 1, y + imageHeight + 1);
            gc.drawLine(x + 2, y + imageHeight + 1, x + imageWidth + 1, y + imageHeight + 1);
            gc.drawImage(previewImageSWT, x, y);
            if (!this.rotation) {
                this.drawTractorVertical(gc, x - 10, y - 1, 10, imageHeight + 2);
                this.drawTractorVertical(gc, x + imageWidth, y - 1, 10, imageHeight + 2);
            } else {
                this.drawTractorHorizontal(gc, x - 1, y - 10, imageWidth + 2, 10);
                this.drawTractorHorizontal(gc, x - 1, y + imageHeight, imageWidth + 2, 10);
            }
        }
    }

    private void drawTractorVertical(GC gc, int x, int y, int width, int height) {
        Rectangle oldClipping = gc.getClipping();
        gc.setClipping(x, y, width, height);
        gc.setBackground(this.tractorBackground);
        gc.fillRectangle(x, y, width, height);
        gc.setForeground(this.black);
        gc.drawLine(x, y, x, y + height);
        gc.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        gc.setBackground(this.lightGray);
        int bubbleWidth = 5;
        int bubbleDistance = 12;
        int bubbleX = x + (width - bubbleWidth) / 2;
        int bubbleY = y;
        while (bubbleY < y + height) {
            gc.fillOval(bubbleX, bubbleY, bubbleWidth, bubbleWidth);
            gc.drawOval(bubbleX, bubbleY, bubbleWidth, bubbleWidth);
            bubbleY += bubbleDistance;
        }
        gc.setClipping(oldClipping);
    }

    private void drawTractorHorizontal(GC gc, int x, int y, int width, int height) {
        Rectangle oldClipping = gc.getClipping();
        gc.setClipping(x, y, width, height);
        gc.setBackground(this.tractorBackground);
        gc.fillRectangle(x, y, width, height);
        gc.setForeground(this.black);
        gc.drawLine(x, y, x + width - 1, y);
        gc.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        gc.setBackground(this.lightGray);
        int bubbleWidth = 5;
        int bubbleDistance = 12;
        int bubbleY = y + (height - bubbleWidth) / 2;
        int bubbleX = x;
        while (bubbleX < x + width) {
            gc.fillOval(bubbleX, bubbleY, bubbleWidth, bubbleWidth);
            gc.drawOval(bubbleX, bubbleY, bubbleWidth, bubbleWidth);
            bubbleX += bubbleDistance;
        }
        gc.setClipping(oldClipping);
    }

    private void widgetDisposed(DisposeEvent e) {
        this.lightGray.dispose();
        this.darkGray.dispose();
        this.black.dispose();
        this.tractorBackground.dispose();
        this.tractorForeground.dispose();
        if (this.previewImage != null) {
            this.previewImage.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(PREVIEW_SIZE + 30, PREVIEW_SIZE + 30);
    }

    public void setNewValues(Image previewImage, boolean rotation, boolean portrait) {
        if (this.previewImage != null) {
            this.previewImage.dispose();
        }
        this.rotation = rotation;
        this.portrait = portrait;
        this.previewImage = previewImage;
        this.updateImage();
        this.redraw();
    }
}

