/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.eclipse.graphics.print.ISWTPrinterRequiringDispose;
import com.arcway.lib.eclipse.graphics.print.SWTPrinterWithImagePrintFallback;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.planeditor.IHelpContextIDs;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialog;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.DoublePattern;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.PlotterHelpDialog;
import com.arcway.planagent.planeditor.dialogs.PrintDialogSettings;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class PrintDialog
extends AbstractPreviewDialog {
    private static final int printButtonID = -12;
    private static final int ITEM_FIT_V = 9;
    private static final int ITEM_FIT_H = 10;
    private static final int ITEM_ZOOM = 11;
    private static final int REAL_NR_OF_ITEMS = 12;
    private static final String ZOOM_GROUP = Messages.getString("PageSetupDialog.Zoom_1");
    private static final String ZOOM_ADJUST = Messages.getString("PageSetupDialog.Zoom_2");
    private static final String ZOOM_FIT_WIDTH = Messages.getString("PageSetupDialog.Fit_to_width");
    private static final String ZOOM_FIT_HEIGHT = Messages.getString("PageSetupDialog.Fit_to_height");
    private static final String ZOOM_FIT_BOTH = Messages.getString("PageSetupDialog.Fit_to_both");
    private static final String ZOOM_PAGES_H = Messages.getString("PageSetupDialog.pages_across");
    private static final String ZOOM_PAGES_V = Messages.getString("PageSetupDialog.pages_down");
    private static final String[] ZOOM_LEVELS = new String[]{"25%", "50%", "75%", "100%", "150%", "200%", "250%", "300%", "400%"};
    private static final String[] ZOOM_FIT_LEVELS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private Combo comboFitVertical;
    private Combo comboFitHorizontal;
    private Combo comboAdjustZoom;
    private ModifyListener comboAdjustZoomModifyListener;
    private ModifyListener comboFitHorizontalModifyListener;
    private ModifyListener comboFitVerticalModifyListener;
    private Button radioFitBoth;
    private Button radioFitVertical;
    private Button radioFitHorizontal;
    private Button radioAdjustZoom;
    private Label printerInformation;
    private final DoublePattern zoomPattern = new DoublePattern(1.0, 6400.0, false);
    private final DoublePattern fitPattern = new DoublePattern(1.0, 100.0, true);
    private final PrintDialogSettings settingsCopy;
    private final PrintDialogSettings settings;

    public PrintDialog(Shell parentShell, InternalDialogSettings internalSettings, PrintDialogSettings settings, IEditorContent editorContent) {
        super(parentShell, internalSettings, editorContent);
        this.settingsCopy = new PrintDialogSettings(settings);
        this.settings = settings;
        this.errors = new String[12][2];
        this.warnings = new String[12];
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)IHelpContextIDs.EDITOR_PRINTDIALOG);
        return super.createDialogArea(parent);
    }

    @Override
    protected Group addCustomGroup(Composite leftArea) {
        Group zoomGroup = new Group(leftArea, 0);
        zoomGroup.setText(ZOOM_GROUP);
        GridData gridData = new GridData(768);
        zoomGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        zoomGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.radioAdjustZoom = new Button((Composite)zoomGroup, 16);
        this.radioAdjustZoom.setText(ZOOM_ADJUST);
        this.radioAdjustZoom.setLayoutData((Object)gridData);
        this.radioAdjustZoom.setSelection(this.settingsCopy.getMode() == 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboAdjustZoom = new Combo((Composite)zoomGroup, 4);
        this.comboAdjustZoom.setItems(ZOOM_LEVELS);
        this.comboAdjustZoom.setText(LocalisationUtils.roundLocalized((double)(this.settingsCopy.getPageSetup().getZoom() * 100.0), (int)0, (boolean)false));
        this.comboAdjustZoom.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioFitHorizontal = new Button((Composite)zoomGroup, 16);
        this.radioFitHorizontal.setText(ZOOM_FIT_WIDTH);
        this.radioFitHorizontal.setLayoutData((Object)gridData);
        this.radioFitHorizontal.setSelection(this.settingsCopy.getMode() == 1);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioFitVertical = new Button((Composite)zoomGroup, 16);
        this.radioFitVertical.setText(ZOOM_FIT_HEIGHT);
        this.radioFitVertical.setLayoutData((Object)gridData);
        this.radioFitVertical.setSelection(this.settingsCopy.getMode() == 2);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioFitBoth = new Button((Composite)zoomGroup, 16);
        this.radioFitBoth.setText(ZOOM_FIT_BOTH);
        this.radioFitBoth.setLayoutData((Object)gridData);
        this.radioFitBoth.setSelection(this.settingsCopy.getMode() == 3);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 2;
        Label labelFitHorizontal = new Label((Composite)zoomGroup, 16384);
        labelFitHorizontal.setText(ZOOM_PAGES_H);
        labelFitHorizontal.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboFitHorizontal = new Combo((Composite)zoomGroup, 4);
        this.comboFitHorizontal.setItems(ZOOM_FIT_LEVELS);
        this.comboFitHorizontal.setText(LocalisationUtils.roundLocalized((double)this.settingsCopy.getPageSetup().getPageCountX(), (int)0, (boolean)false));
        this.comboFitHorizontal.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 2;
        Label labelFitVertical = new Label((Composite)zoomGroup, 16384);
        labelFitVertical.setText(ZOOM_PAGES_V);
        labelFitVertical.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboFitVertical = new Combo((Composite)zoomGroup, 4);
        this.comboFitVertical.setItems(ZOOM_FIT_LEVELS);
        this.comboFitVertical.setText(LocalisationUtils.roundLocalized((double)this.settingsCopy.getPageSetup().getPageCountY(), (int)0, (boolean)false));
        this.comboFitVertical.setLayoutData((Object)gridData);
        this.radioAdjustZoom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PrintDialog.this.radioAdjustZoom.getSelection()) {
                    PrintDialog.this.toggleWidgets();
                    PrintDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioFitHorizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PrintDialog.this.radioFitHorizontal.getSelection()) {
                    PrintDialog.this.toggleWidgets();
                    PrintDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioFitVertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PrintDialog.this.radioFitVertical.getSelection()) {
                    PrintDialog.this.toggleWidgets();
                    PrintDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioFitBoth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PrintDialog.this.radioFitBoth.getSelection()) {
                    PrintDialog.this.toggleWidgets();
                    PrintDialog.this.frameViewConfigChanged();
                }
            }
        });
        return zoomGroup;
    }

    @Override
    protected Group addCustomBottomGroup(Composite globalArea) {
        Group customGroup = new Group(globalArea, 0);
        customGroup.setText(Messages.getString("PageSetupDialog.Printing_options"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        customGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        customGroup.setLayout((Layout)gridLayout);
        Button changeSettingsButton = new Button((Composite)customGroup, 8);
        changeSettingsButton.setText(Messages.getString("PageSetupDialog.Change_Printer_Settings"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        changeSettingsButton.setLayoutData((Object)gridData);
        this.printerInformation = new Label((Composite)customGroup, 0);
        this.updatePrinterLabel();
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 1;
        this.printerInformation.setLayoutData((Object)gridData);
        changeSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterData pData;
                String osName;
                org.eclipse.swt.printing.PrintDialog pd = new org.eclipse.swt.printing.PrintDialog(PrintDialog.this.getShell());
                PrinterData currentPrinterData = PrintDialog.this.settingsCopy.getPrinterData();
                if (currentPrinterData != null && !(osName = System.getProperty("os.name")).contains("Vista")) {
                    pd.setPrinterData(PrintDialog.this.settingsCopy.getPrinterData());
                }
                if ((pData = pd.open()) != null) {
                    PrintDialog.this.settingsCopy.setPrinterData(pData);
                    PrintDialog.this.updatePrinterLabel();
                    PrintDialog.this.printerChanged();
                }
            }
        });
        Button helpButton = new Button((Composite)customGroup, 8);
        helpButton.setText(Messages.getString("PageSetupDialog.PlotterHelp"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        helpButton.setLayoutData((Object)gridData);
        helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean open = true;
                if (PrintDialog.this.settingsCopy.isSetMarginsAutomatically()) {
                    open = MessageDialog.openConfirm((Shell)PrintDialog.this.getShell(), (String)Messages.getString("PrintDialog.warningDialogTitle"), (String)(String.valueOf(Messages.getString("PrintDialog.warningDialogText1")) + MARGIN_AUTOMATICALLY + Messages.getString("PrintDialog.warningDialogText2")));
                }
                if (open) {
                    PlotterHelpDialog pd = new PlotterHelpDialog(PrintDialog.this.getShell(), PrintDialog.this, PrintDialog.this.getSettings().getPageSetup().getMargin(), PrintDialog.this.getCurrentPageSize());
                    pd.open();
                }
            }
        });
        return customGroup;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -12, Messages.getString("PageSetupDialog.Print"), true);
        this.getButton(-12).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPrinter printer = PrintDialog.this.createPrinter();
                PrintingFailure failure = PrintDialog.this.print(printer);
                PrintDialog.this.disposePrinter(printer);
                if (failure == null) {
                    PrintDialog.this.okPressed();
                } else {
                    MessageDialog mDialog = new MessageDialog(PrintDialog.this.getShell(), Messages.getString("SaveAsImageDialog.Print_Error"), null, Messages.getString("SaveAsImageDialog.Print_Failure_Text"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
            }
        });
        super.createButtonsForButtonBar(parent);
        this.getShell().setDefaultButton(this.getButton(-12));
    }

    @Override
    protected String getExtendedErrorMessage(int index) {
        String toReturn;
        switch (index) {
            case 11: {
                toReturn = Messages.getString("PageSetupDialog.You_have_entered_an_invalid_value_into_the_zoom_input_field");
                break;
            }
            case 10: {
                toReturn = Messages.getString("PageSetupDialog.You_have_entered_an_invalid_value_into_the_fit_horizontal_field");
                break;
            }
            case 9: {
                toReturn = Messages.getString("PageSetupDialog.You_have_entered_an_invalid_value_into_the_fit_vertical_field");
                break;
            }
            default: {
                toReturn = Messages.getString("AbstractPreviewDialog.An_error_occurred._Please_check_your_settings_and_try_again");
            }
        }
        return toReturn;
    }

    @Override
    protected String getStdMessage() {
        return Messages.getString("PageSetupDialog.Configure_the_page_settings_for_printing");
    }

    @Override
    protected String getTitle() {
        return Messages.getString("PageSetupDialog.Page_Setup");
    }

    @Override
    public void create() {
        super.create();
        this.toggleWidgets();
    }

    private void toggleWidgets() {
        if (this.radioAdjustZoom.getSelection()) {
            this.comboAdjustZoom.setEnabled(true);
            this.comboFitHorizontal.setEnabled(false);
            this.comboFitVertical.setEnabled(false);
        } else if (this.radioFitHorizontal.getSelection()) {
            this.comboAdjustZoom.setEnabled(false);
            this.comboFitHorizontal.setEnabled(true);
            this.comboFitVertical.setEnabled(false);
        } else if (this.radioFitVertical.getSelection()) {
            this.comboAdjustZoom.setEnabled(false);
            this.comboFitHorizontal.setEnabled(false);
            this.comboFitVertical.setEnabled(true);
        } else if (this.radioFitBoth.getSelection()) {
            this.comboAdjustZoom.setEnabled(false);
            this.comboFitHorizontal.setEnabled(true);
            this.comboFitVertical.setEnabled(true);
        }
        if (!this.comboAdjustZoom.isEnabled() && this.comboAdjustZoomModifyListener != null) {
            this.comboAdjustZoom.removeModifyListener(this.comboAdjustZoomModifyListener);
            this.comboAdjustZoomModifyListener = null;
        } else if (this.comboAdjustZoom.isEnabled() && this.comboAdjustZoomModifyListener == null) {
            this.comboAdjustZoomModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PrintDialog.this.frameViewConfigChanged();
                }
            };
            this.comboAdjustZoom.addModifyListener(this.comboAdjustZoomModifyListener);
        }
        if (!this.comboFitHorizontal.isEnabled() && this.comboFitHorizontalModifyListener != null) {
            this.comboFitHorizontal.removeModifyListener(this.comboFitHorizontalModifyListener);
            this.comboFitHorizontalModifyListener = null;
        } else if (this.comboFitHorizontal.isEnabled() && this.comboFitHorizontalModifyListener == null) {
            this.comboFitHorizontalModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PrintDialog.this.frameViewConfigChanged();
                }
            };
            this.comboFitHorizontal.addModifyListener(this.comboFitHorizontalModifyListener);
        }
        if (!this.comboFitVertical.isEnabled() && this.comboFitVerticalModifyListener != null) {
            this.comboFitVertical.removeModifyListener(this.comboFitVerticalModifyListener);
            this.comboFitVerticalModifyListener = null;
        } else if (this.comboFitVertical.isEnabled() && this.comboFitVerticalModifyListener == null) {
            this.comboFitVerticalModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PrintDialog.this.frameViewConfigChanged();
                }
            };
            this.comboFitVertical.addModifyListener(this.comboFitVerticalModifyListener);
        }
    }

    private void updatePrinterLabel() {
        String printerDescription;
        PrinterData printerData = this.settingsCopy.getPrinterData();
        if (printerData == null) {
            printerDescription = Messages.getString("PrintDialog.noPrinterChosen");
        } else {
            printerDescription = printerData.name;
            if (printerData.copyCount > 1) {
                printerDescription = String.valueOf(printerDescription) + Messages.getString("PrintDialog.copyCountStart") + printerData.copyCount + Messages.getString("PrintDialog.copyCountEnd");
            }
        }
        this.printerInformation.setText(printerDescription);
        this.printerInformation.getParent().layout();
    }

    @Override
    public IPrinter createPrinter() {
        return SWTPrinterWithImagePrintFallback.createSWTPrinter((PrinterData)this.settingsCopy.getPrinterData());
    }

    @Override
    public void disposePrinter(IPrinter printer) {
        if (printer instanceof ISWTPrinterRequiringDispose) {
            ((ISWTPrinterRequiringDispose)printer).dispose();
        }
    }

    @Override
    protected AbstractPreviewDialogSettings getSettings() {
        return this.settingsCopy;
    }

    @Override
    protected void readWidgetValues() {
        super.readWidgetValues();
        this.removeErrors(11);
        this.removeErrors(10);
        this.removeErrors(9);
        if (this.radioAdjustZoom.getSelection()) {
            this.settingsCopy.setMode(0);
            Double parsedZoom = this.parseInput(this.comboAdjustZoom.getText(), this.zoomPattern, 11);
            if (parsedZoom != null) {
                this.settingsCopy.getPageSetup().setZoom(parsedZoom / 100.0);
                this.settingsCopy.getPageSetup().setPageCountX(0);
                this.settingsCopy.getPageSetup().setPageCountY(0);
                this.settingsCopy.getPageSetup().setFitHorizontally(false);
                this.settingsCopy.getPageSetup().setFitVertically(false);
            }
        } else if (this.radioFitHorizontal.getSelection()) {
            this.settingsCopy.setMode(1);
            Double parsedFitH = this.parseInput(this.comboFitHorizontal.getText(), this.fitPattern, 10);
            if (parsedFitH != null) {
                this.settingsCopy.getPageSetup().setPageCountX(parsedFitH.intValue());
                this.settingsCopy.getPageSetup().setPageCountY(0);
                this.settingsCopy.getPageSetup().setFitHorizontally(true);
                this.settingsCopy.getPageSetup().setFitVertically(false);
            }
        } else if (this.radioFitVertical.getSelection()) {
            Double parsedFitV = this.parseInput(this.comboFitVertical.getText(), this.fitPattern, 9);
            this.settingsCopy.setMode(2);
            if (parsedFitV != null) {
                this.settingsCopy.getPageSetup().setPageCountX(0);
                this.settingsCopy.getPageSetup().setPageCountY(parsedFitV.intValue());
                this.settingsCopy.getPageSetup().setFitHorizontally(false);
                this.settingsCopy.getPageSetup().setFitVertically(true);
            }
        } else if (this.radioFitBoth.getSelection()) {
            this.settingsCopy.setMode(3);
            Double parsedFitH = this.parseInput(this.comboFitHorizontal.getText(), this.fitPattern, 10);
            Double parsedFitV = this.parseInput(this.comboFitVertical.getText(), this.fitPattern, 9);
            if (parsedFitH != null && parsedFitV != null) {
                this.settingsCopy.getPageSetup().setPageCountX(parsedFitH.intValue());
                this.settingsCopy.getPageSetup().setPageCountY(parsedFitV.intValue());
                this.settingsCopy.getPageSetup().setFitHorizontally(true);
                this.settingsCopy.getPageSetup().setFitVertically(true);
            }
        }
    }

    @Override
    protected void updateSettings() {
        super.updateSettings();
    }

    @Override
    protected void writeWidgetValues() {
        super.writeWidgetValues();
        this.checkErrors(this.settingsCopy.getPageSetup().getZoom() * 100.0, this.zoomPattern, 11);
        this.checkErrors(this.settingsCopy.getPageSetup().getPageCountX(), this.fitPattern, 10);
        this.checkErrors(this.settingsCopy.getPageSetup().getPageCountY(), this.fitPattern, 9);
        switch (this.settingsCopy.getMode()) {
            case 0: {
                this.comboFitHorizontal.setText(Integer.valueOf(this.settingsCopy.getPageSetup().getPageCountX()).toString());
                this.comboFitVertical.setText(Integer.valueOf(this.settingsCopy.getPageSetup().getPageCountY()).toString());
                break;
            }
            case 1: {
                this.comboFitVertical.setText(Integer.valueOf(this.settingsCopy.getPageSetup().getPageCountY()).toString());
                this.comboAdjustZoom.setText(String.valueOf(Integer.valueOf((int)(this.settingsCopy.getPageSetup().getZoom() * 100.0)).toString()) + "%");
                break;
            }
            case 2: {
                this.comboFitHorizontal.setText(Integer.valueOf(this.settingsCopy.getPageSetup().getPageCountX()).toString());
                this.comboAdjustZoom.setText(String.valueOf(Integer.valueOf(new Double(this.settingsCopy.getPageSetup().getZoom() * 100.0).intValue()).toString()) + "%");
                break;
            }
            case 3: {
                this.comboAdjustZoom.setText(String.valueOf(Integer.valueOf(new Double(this.settingsCopy.getPageSetup().getZoom() * 100.0).intValue()).toString()) + "%");
                break;
            }
        }
    }

    @Override
    protected FrameViewConfig getFrameViewConfig(PageInfo pageInfo) {
        FrameViewConfig frameViewConfig;
        switch (this.settingsCopy.getMode()) {
            case 0: {
                frameViewConfig = FrameViewConfig.createFrameExpandedToPageBorders((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)this.settingsCopy.getPageSetup().getZoom(), (PageInfo)pageInfo);
                break;
            }
            case 1: {
                int pagesX = this.settingsCopy.getPageSetup().getPageCountX();
                frameViewConfig = FrameViewConfig.createFrameWithFixedWidthExpandedToPageBorders((int)pagesX, (Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (PageInfo)pageInfo);
                break;
            }
            case 2: {
                int pagesY = this.settingsCopy.getPageSetup().getPageCountY();
                frameViewConfig = FrameViewConfig.createFrameWithFixedHeightExpandedToPageBorders((int)pagesY, (Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (PageInfo)pageInfo);
                break;
            }
            case 3: {
                int pagesX = this.settingsCopy.getPageSetup().getPageCountX();
                int pagesY = this.settingsCopy.getPageSetup().getPageCountY();
                frameViewConfig = FrameViewConfig.createFrameWithFixedSizeExpandedToPageBorders((int)pagesX, (int)pagesY, (Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (PageInfo)pageInfo);
                break;
            }
            default: {
                frameViewConfig = null;
            }
        }
        return frameViewConfig;
    }

    @Override
    protected int limitPreviewPageWidth(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected int limitPreviewPageHeight(int wishInPixels) {
        return wishInPixels;
    }

    @Override
    protected boolean printerDefinesPrintingArea() {
        return true;
    }

    @Override
    protected void enableOkButton(boolean enable) {
        this.getButton(-12).setEnabled(enable);
        super.enableOkButton(enable);
    }

    @Override
    public void okPressed() {
        this.settings.copyFrom(this.settingsCopy);
        super.okPressed();
    }
}

