/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.eclipse.graphics.print.SWTPrinter;
import com.arcway.lib.geometry.Insets;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.PrintDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsEMFDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsMetafileDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsPNGDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsSVGDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsWMFDialogSettings;
import de.plans.lib.util.Logger;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class DialogSettingsStorage {
    private static final Logger logger = Logger.getLogger(DialogSettingsStorage.class);
    private static final double DEFAULT_INSETS = 20.0;
    private final InternalDialogSettings internalDialogSettings = new InternalDialogSettings(false);
    private final SaveAsPNGDialogSettings saveAsImageDialogSettings = new SaveAsPNGDialogSettings();
    private final SaveAsSVGDialogSettings saveAsSVGDialogSettings = new SaveAsSVGDialogSettings();
    private final SaveAsWMFDialogSettings saveAsWMFDialogSettings = new SaveAsWMFDialogSettings();
    private final SaveAsEMFDialogSettings saveAsEMFDialogSettings = new SaveAsEMFDialogSettings();
    private final PrintDialogSettings printPreviewDialogSettings = this.configurePrinterDefaults();

    public InternalDialogSettings getInternalDialogSettings() {
        return this.internalDialogSettings;
    }

    public PrintDialogSettings getPrintPreviewDialogSettings() {
        return this.printPreviewDialogSettings;
    }

    public SaveAsPNGDialogSettings getSaveAsImageDialogSettings() {
        return this.saveAsImageDialogSettings;
    }

    public SaveAsSVGDialogSettings getSaveAsSVGDialogSettings() {
        return this.saveAsSVGDialogSettings;
    }

    public SaveAsMetafileDialogSettings getSaveAsWMFDialogSettings() {
        return this.saveAsWMFDialogSettings;
    }

    public SaveAsMetafileDialogSettings getSaveAsEMFDialogSettings() {
        return this.saveAsEMFDialogSettings;
    }

    private PrintDialogSettings configurePrinterDefaults() {
        Insets insets;
        PrinterData defaultPrinterData = Printer.getDefaultPrinterData();
        if (defaultPrinterData != null) {
            Printer printer = null;
            try {
                printer = new Printer(defaultPrinterData);
                if (printer.isDisposed()) {
                    logger.error((Object)("printer was disposed after creation: data = " + defaultPrinterData + ", printer = " + printer));
                    defaultPrinterData = null;
                } else {
                    printer.dispose();
                }
            }
            catch (Throwable e) {
                logger.error((Object)("execption while evaluating default printer: data = " + defaultPrinterData + ", printer = " + printer), e);
                defaultPrinterData = null;
            }
        }
        if (defaultPrinterData != null) {
            SWTPrinter dummyPrinter = new SWTPrinter(defaultPrinterData);
            double h = dummyPrinter.getDrawingArea().y() - dummyPrinter.getPageSize().y();
            double li = dummyPrinter.getPageSize().y() + dummyPrinter.getPageSize().h() - (dummyPrinter.getDrawingArea().y() + dummyPrinter.getDrawingArea().h());
            if (li > h) {
                h = li;
            }
            double v = dummyPrinter.getDrawingArea().x() - dummyPrinter.getPageSize().x();
            double ri = dummyPrinter.getPageSize().x() + dummyPrinter.getPageSize().w() - (dummyPrinter.getDrawingArea().x() + dummyPrinter.getDrawingArea().w());
            if (ri > v) {
                v = ri;
            }
            dummyPrinter.dispose();
            insets = new Insets(h, h, v, v);
        } else {
            insets = new Insets(20.0);
        }
        return new PrintDialogSettings(defaultPrinterData, insets);
    }
}

