/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.io.FileHelper;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialog;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialogSettings;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractSaveAsDialog
extends AbstractPreviewDialog {
    private static final int ITEM_FILE_PATH = 8;
    private static final int ITEM_FILE_EXTENSION = 9;
    private static final int ITEM_FILE_OVERWRITE = 10;
    protected static final int NR_OF_SAVE_AS_ITEMS = 11;
    private static final String WARNING_FILE_OVERWRITE = Messages.getString("SaveAsDialog.Caution__This_file_already_exists_and_will_be_overwritten");
    private Text fileTextField;

    public AbstractSaveAsDialog(Shell parent, InternalDialogSettings internalSettings, IEditorContent editorContent) {
        super(parent, internalSettings, editorContent);
        this.errors = new String[11][2];
        this.warnings = new String[11];
    }

    protected abstract AbstractSaveAsDialogSettings getSaveAsDialogSettings();

    protected abstract String getFileExtension();

    protected abstract String saveAs();

    private void chooseFile() {
        FileChooserDialog fileDialog;
        File result;
        String startPathString = this.fileTextField.getText().trim();
        File startPath = null;
        if (startPathString.length() > 0) {
            startPath = new File(startPathString);
        }
        if ((result = (fileDialog = new FileChooserDialog(new String[]{"*." + this.getFileExtension(), "*.*"}, startPath, this.getShell())).openForSave()) != null) {
            result = FileHelper.addExtensionIfMissing((File)result, (String)this.getFileExtension());
            this.fileTextField.setText(result.getAbsolutePath());
            this.processFilenameInput();
        }
    }

    @Override
    protected void okPressed() {
        String failure = this.saveAs();
        if (failure == null) {
            super.okPressed();
        } else {
            MessageDialog mDialog = new MessageDialog(this.getShell(), Messages.getString("SaveAsDialog.Print_Error"), null, failure, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }
    }

    private void installFilenamModifyListener() {
        ModifyListener fileModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractSaveAsDialog.this.processFilenameInput();
                AbstractSaveAsDialog.this.refresh();
            }
        };
        this.fileTextField.addModifyListener(fileModifyListener);
    }

    @Override
    protected Group addCustomBottomGroup(Composite globalArea) {
        File previousPath;
        Group customGroup = new Group(globalArea, 0);
        customGroup.setText(Messages.getString("SaveAsDialog.Target_file_Group"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        customGroup.setLayoutData((Object)gridData);
        customGroup.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        Label textLabel = new Label((Composite)customGroup, 0);
        textLabel.setText(Messages.getString("SaveAsDialog.Target_file"));
        textLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        String pathToUse = null;
        if (!ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled") && (previousPath = this.getSaveAsDialogSettings().getFile()) != null) {
            pathToUse = previousPath.getAbsolutePath();
        }
        this.fileTextField = new Text((Composite)customGroup, 2052);
        if (pathToUse != null) {
            this.fileTextField.setText(pathToUse);
        }
        this.fileTextField.setLayoutData((Object)new GridData(768));
        this.fileTextField.setLayoutData((Object)gridData);
        this.fileTextField.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        Button fileChooserButton = new Button((Composite)customGroup, 0);
        fileChooserButton.setLayoutData((Object)new GridData(128));
        fileChooserButton.setText(Messages.getString("SaveAsDialog.Browse..."));
        fileChooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSaveAsDialog.this.chooseFile();
            }
        });
        fileChooserButton.setLayoutData((Object)gridData);
        this.installFilenamModifyListener();
        return customGroup;
    }

    private void processFilenameInput() {
        block6: {
            if (this.fileTextField != null) {
                this.getSaveAsDialogSettings().setFile(new File(this.fileTextField.getText()));
                this.errors[8][0] = null;
                this.errors[9][0] = null;
                File file = new File(this.fileTextField.getText());
                try {
                    if (file.exists()) {
                        this.warnings[10] = WARNING_FILE_OVERWRITE;
                        break block6;
                    }
                    if (file.getParentFile() == null || !file.getParentFile().isDirectory()) {
                        this.errors[8][0] = this.getExtendedErrorMessage(8);
                        break block6;
                    }
                    this.warnings[10] = null;
                }
                catch (Throwable exception) {
                    this.errors[8][0] = this.getExtendedErrorMessage(8);
                }
            } else {
                this.errors[9][0] = this.getExtendedErrorMessage(9);
            }
        }
    }

    @Override
    protected String getExtendedErrorMessage(int index) {
        String toReturn;
        switch (index) {
            case 8: {
                toReturn = Messages.getString("SaveAsDialog.You_must_enter_a_valid_file_path");
                break;
            }
            case 9: {
                toReturn = String.valueOf(Messages.getString("SaveAsDialog.Please_enter_an_png_File1")) + this.getFileExtension() + Messages.getString("SaveAsDialog.Please_enter_an_png_File1");
                break;
            }
            default: {
                toReturn = Messages.getString("AbstractPreviewDialog.An_error_occurred._Please_check_your_settings_and_try_again");
            }
        }
        return toReturn;
    }

    @Override
    protected AbstractPreviewDialogSettings getSettings() {
        return this.getSaveAsDialogSettings();
    }

    @Override
    protected void readWidgetValues() {
        super.readWidgetValues();
    }

    @Override
    protected void updateSettings() {
        super.updateSettings();
        this.processFilenameInput();
    }

    @Override
    protected void writeWidgetValues() {
        super.writeWidgetValues();
    }
}

