/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.Messages;

public abstract class AbstractPreviewDialogSettings {
    private PageSetup pageSetup;
    private boolean includeProjections = true;
    private boolean includeHighlights = false;
    private boolean includeComments = true;
    private boolean includeInformation = true;
    private double innerMargins = 10.0;
    private boolean setMarginsAutomatically = true;

    public AbstractPreviewDialogSettings(AbstractPreviewDialogSettings copyFrom) {
        this.copyFrom(copyFrom);
    }

    public AbstractPreviewDialogSettings() {
    }

    public void copyFrom(AbstractPreviewDialogSettings copyFrom) {
        this.includeHighlights = copyFrom.includeHighlights;
        this.includeComments = copyFrom.includeComments;
        this.includeInformation = copyFrom.includeInformation;
        this.includeProjections = copyFrom.includeProjections;
        this.setMarginsAutomatically = copyFrom.setMarginsAutomatically;
        this.pageSetup = new PageSetup(copyFrom.getPageSetup());
        this.innerMargins = copyFrom.getInnerMarginsAsDouble();
    }

    public static PageSetup createDefaultPrintingHints(Insets insets) {
        return new PageSetup(1, 1, new Alignment(2, 16), 1.0, true, true, new Insets(insets));
    }

    public static String getAlignmentString(int id) {
        String toReturn = "";
        switch (id) {
            case 16: {
                toReturn = Messages.getString("PreviewDialogSettings.center");
                break;
            }
            case 8: {
                toReturn = Messages.getString("PreviewDialogSettings.top");
                break;
            }
            case 32: {
                toReturn = Messages.getString("PreviewDialogSettings.bottom");
                break;
            }
            case 2: {
                toReturn = Messages.getString("PreviewDialogSettings.center");
                break;
            }
            case 1: {
                toReturn = Messages.getString("PreviewDialogSettings.left");
                break;
            }
            case 4: {
                toReturn = Messages.getString("PreviewDialogSettings.right");
                break;
            }
            default: {
                toReturn = Messages.getString("PreviewDialogSettings.unknown");
            }
        }
        return toReturn;
    }

    public PageSetup getPageSetup() {
        return this.pageSetup;
    }

    public Insets getInnerMargins() {
        return new Insets(this.innerMargins);
    }

    public double getInnerMarginsAsDouble() {
        return this.innerMargins;
    }

    public void setInnerMargins(double innerMargins) {
        this.innerMargins = innerMargins;
    }

    public void setPageSetup(PageSetup pageSetup) {
        this.pageSetup = pageSetup;
    }

    public void setIncludeProjections(boolean b) {
        this.includeProjections = b;
    }

    public void setIncludeComments(boolean b) {
        this.includeComments = b;
    }

    public void setIncludeHighlights(boolean b) {
        this.includeHighlights = b;
    }

    public void setIncludeInformation(boolean b) {
        this.includeInformation = b;
    }

    public boolean isIncludeHighlights() {
        return this.includeHighlights;
    }

    public boolean isIncludeComments() {
        return this.includeComments;
    }

    public boolean isIncludeInformation() {
        return this.includeInformation;
    }

    public boolean isIncludeProjections() {
        return this.includeProjections;
    }

    public boolean isSetMarginsAutomatically() {
        return this.setMarginsAutomatically;
    }

    public void setSetMarginsAutomatically(boolean b) {
        this.setMarginsAutomatically = b;
    }
}

