/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.snap.ISnappablePoint;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class SnappablePoint
implements ISnappablePoint {
    private Point point;
    private Points objectPoints;
    private ISnappablePoint.GridSnapType gridSnapTypeX;
    private ISnappablePoint.GridSnapType gridSnapTypeY;

    public static Collection<SnappablePoint> gatherPoints(Collection<? extends IPMPlanObjectRO> planObjectList) {
        ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>();
        boolean takeAnchoredPointsAlso = false;
        while (true) {
            for (IPMPlanObjectRO iPMPlanObjectRO : planObjectList) {
                IPMPointListRO pointList = iPMPlanObjectRO.getPointListRO();
                int i = 0;
                while (i < pointList.getPointCount()) {
                    IPMPointRO point = pointList.getPointRO(i);
                    if (takeAnchoredPointsAlso || point.getAnchoringRO() == null) {
                        SnappablePoint gridablePoint = new SnappablePoint(point);
                        points.add(gridablePoint);
                    }
                    ++i;
                }
            }
            if (takeAnchoredPointsAlso || points.size() > 0) break;
            takeAnchoredPointsAlso = true;
        }
        return points;
    }

    public static Collection<? extends ISnappablePoint> gatherPoints(IPMLineRO line) {
        ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>(2);
        points.add(new SnappablePoint(line.getPoint1stRO()));
        points.add(new SnappablePoint(line.getPoint2ndRO()));
        return points;
    }

    public static Collection<SnappablePoint> gatherPoints(IPMPointRO point) {
        Set<SnappablePoint> points = Collections.singleton(new SnappablePoint(point));
        return points;
    }

    public static Collection<? extends ISnappablePoint> gatherPoints(Points points, int lineForceStart, IPMPlanObjectRO.PlanObjectEditType planObjectType) {
        int currentLineForce = lineForceStart;
        ArrayList<SnappablePoint> snappablePoints = new ArrayList<SnappablePoint>(points.size());
        int i = 0;
        while (i < points.size()) {
            Point currentPoint = points.get(i);
            SnappablePoint snappablePoint = new SnappablePoint();
            ISnappablePoint.GridSnapType gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
            ISnappablePoint.GridSnapType gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
            if (i == 0) {
                if (currentLineForce == 2) {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                } else if (currentLineForce == 3) {
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                }
            }
            if (currentLineForce == 2) {
                currentLineForce = 3;
            } else if (currentLineForce == 3) {
                currentLineForce = 2;
            }
            if (i == points.size() - 1) {
                if (currentLineForce == 2) {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                } else if (currentLineForce == 3) {
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                }
            }
            snappablePoint.init(currentPoint, Points.NO_POINTS, planObjectType, gridSnapTypeXForHalfEdgeBehavior, gridSnapTypeYForHalfEdgeBehavior);
            snappablePoints.add(snappablePoint);
            ++i;
        }
        return snappablePoints;
    }

    private SnappablePoint() {
    }

    private SnappablePoint(IPMPointRO modelPoint) {
        IPMLineRO line2nd;
        assert (modelPoint != null);
        ISnappablePoint.GridSnapType gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
        ISnappablePoint.GridSnapType gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
        IPMLineRO line1st = modelPoint.getLine1stRO();
        if (line1st != null) {
            int lineForce1st = line1st.getForce();
            switch (lineForce1st) {
                case 2: {
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    break;
                }
                case 3: {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    break;
                }
                default: {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                }
            }
        }
        if ((line2nd = modelPoint.getLine2ndRO()) != null) {
            int lineForce2nd = line2nd.getForce();
            switch (lineForce2nd) {
                case 2: {
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    break;
                }
                case 3: {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    break;
                }
                default: {
                    gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                    gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                }
            }
        }
        if (line1st == null && line2nd == null) {
            gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
            gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
        }
        this.init(modelPoint.getPosition(), modelPoint.getPlanObjectRO(), gridSnapTypeXForHalfEdgeBehavior, gridSnapTypeYForHalfEdgeBehavior);
    }

    public static SnappablePoint createForEndPointCreation(Point point, IPMLineRO line) {
        ISnappablePoint.GridSnapType gridSnapTypeYForHalfEdgeBehavior;
        ISnappablePoint.GridSnapType gridSnapTypeXForHalfEdgeBehavior;
        assert (point != null);
        assert (line != null);
        switch (line.getForce()) {
            case 3: {
                gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                break;
            }
            case 2: {
                gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
                break;
            }
            default: {
                gridSnapTypeXForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
                gridSnapTypeYForHalfEdgeBehavior = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
            }
        }
        SnappablePoint snappablePoint = new SnappablePoint();
        snappablePoint.init(point, line.getPlanObjectRO(), gridSnapTypeXForHalfEdgeBehavior, gridSnapTypeYForHalfEdgeBehavior);
        return snappablePoint;
    }

    public static SnappablePoint createForMiddlePointCreation(Point point, IPMPlanObjectRO planObject) {
        assert (point != null);
        assert (planObject != null);
        SnappablePoint snappablePoint = new SnappablePoint();
        snappablePoint.init(point, planObject, ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF, ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF);
        return snappablePoint;
    }

    private void init(Point initPoint, IPMPlanObjectRO planObject, ISnappablePoint.GridSnapType gridSnapTypeXForHalfEdgeBehavior, ISnappablePoint.GridSnapType gridSnapTypeYForHalfEdgeBehavior) {
        IPMPointListRO pointList = planObject.getPointListRO();
        IPMPlanObjectRO.PlanObjectEditType editType = planObject.getPlanObjectEditType();
        this.init(initPoint, pointList.getPoints(), editType, gridSnapTypeXForHalfEdgeBehavior, gridSnapTypeYForHalfEdgeBehavior);
    }

    private void init(Point initPoint, Points initPoints, IPMPlanObjectRO.PlanObjectEditType editType, ISnappablePoint.GridSnapType gridSnapTypeXForHalfEdgeBehavior, ISnappablePoint.GridSnapType gridSnapTypeYForHalfEdgeBehavior) {
        this.point = Point.getAsPoint((Point)initPoint);
        this.objectPoints = initPoints;
        if (editType == IPMPlanObjectRO.FIGURE_EDIT_TYPE_FREE) {
            this.gridSnapTypeX = ISnappablePoint.GRID_SNAP_TYPE_FREE;
            this.gridSnapTypeY = ISnappablePoint.GRID_SNAP_TYPE_FREE;
        } else if (editType == IPMPlanObjectRO.FIGURE_EDIT_TYPE_FULL_EDGE) {
            this.gridSnapTypeX = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
            this.gridSnapTypeY = ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF;
        } else if (editType == IPMPlanObjectRO.FIGURE_EDIT_TYPE_HALF_EDGE) {
            this.gridSnapTypeX = gridSnapTypeXForHalfEdgeBehavior;
            this.gridSnapTypeY = gridSnapTypeYForHalfEdgeBehavior;
        } else if (editType == IPMPlanObjectRO.FIGURE_EDIT_TYPE_HALF_NODE) {
            this.gridSnapTypeX = ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF;
            this.gridSnapTypeY = ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF;
        } else if (editType == IPMPlanObjectRO.FIGURE_EDIT_TYPE_FULL_NODE) {
            this.gridSnapTypeX = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
            this.gridSnapTypeY = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
        } else {
            this.gridSnapTypeX = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
            this.gridSnapTypeY = ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL;
        }
    }

    public double getX() {
        return this.point.x;
    }

    public double getY() {
        return this.point.y;
    }

    public ISnappablePoint.GridSnapType getGridSnapTypeX() {
        return this.gridSnapTypeX;
    }

    public ISnappablePoint.GridSnapType getGridSnapTypeY() {
        return this.gridSnapTypeY;
    }

    public Points getObjectPoints() {
        return this.objectPoints;
    }
}

