/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.transactions.TAMoveGraphicalSupplements;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.List;

public class CMMoveGraphicalSupplementStructure
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMMoveGraphicalSupplementStructure.class);
    private static final String COMMAND_LABEL_SINGULAR = Messages.getString("CMMoveGraphicalSupplementStructure.Move_Graphical_Supplement");
    private static final String COMMAND_LABEL_PLURAL = Messages.getString("CMMoveGraphicalSupplementStructure.Move_Graphical_Supplememts");

    public CMMoveGraphicalSupplementStructure(List pmSupplements, GeoVector transl, ICommandContext commandContext) {
        super(commandContext);
        GeoVector translation = transl;
        if (logger.isTraceEnabled()) {
            logger.trace("CMMoveGraphicalSupplementStructure(List pmSupplements = " + pmSupplements + ", GeoVector translation = " + translation + ") - start");
        }
        assert (pmSupplements != null) : "pmSupplements is null";
        assert (translation != null) : "translation is null";
        Collection<SnappablePoint> points = SnappablePoint.gatherPoints(pmSupplements);
        translation = commandContext.getGrid().snapObjectTranslation(points, translation);
        if (pmSupplements.size() > 0) {
            TAMoveGraphicalSupplements transaction = new TAMoveGraphicalSupplements(pmSupplements, this.getActionParameters(), translation);
            if (pmSupplements.size() > 1) {
                super.construct(COMMAND_LABEL_PLURAL, (Transaction)transaction);
            } else {
                super.construct(COMMAND_LABEL_SINGULAR, (Transaction)transaction);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(64, "CMMoveGraphicalSupplementStructure(List, GeoVector) - end");
        }
    }
}

