/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.transactions.TAMoveFigures;
import com.arcway.planagent.planmodel.transactions.Transaction;
import de.plans.lib.util.Logger;
import java.util.Collection;
import java.util.List;

public class CMMoveFigureStructure
extends TransactionCommand {
    private static final Logger logger = Logger.getLogger(CMMoveFigureStructure.class);
    private static final String COMMAND_LABEL_SINGULAR = Messages.getString("CMMoveFigureStructure.Move_Figure");
    private static final String COMMAND_LABEL_PLURAL = Messages.getString("CMMoveFigureStructure.Move_Figures");

    public CMMoveFigureStructure(List pmFigures, GeoVector translation, boolean moveChildrenAlso, ICommandContext commandContext) {
        super(commandContext);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("CMMoveFigureStructure(List pmFigures = " + pmFigures + ", GeoVector translation = " + translation + ") - start"));
        }
        assert (pmFigures != null) : "pmFigures is null";
        assert (translation != null) : "translation is null";
        if (moveChildrenAlso) {
            this.addContainedFigures(pmFigures);
        }
        Collection<SnappablePoint> points = SnappablePoint.gatherPoints(pmFigures);
        translation = commandContext.getGrid().snapObjectTranslation(points, translation);
        if (pmFigures.size() > 0) {
            TAMoveFigures transaction = new TAMoveFigures(pmFigures, this.getActionParameters(), translation);
            if (pmFigures.size() > 1) {
                super.construct(COMMAND_LABEL_PLURAL, (Transaction)transaction);
            } else {
                super.construct(COMMAND_LABEL_SINGULAR, (Transaction)transaction);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(64, (Object)"CMMoveFigureStructure(List, GeoVector) - end");
        }
    }
}

