/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.framecom.FrameComUtilities;
import com.arcway.planagent.planmodel.transactions.TADeletePlanElementStructure;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.List;

public class CMDeletePlanElements
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMDeletePlanElements.class);
    private static final String COMMAND_LABEL = Messages.getString("CMDeletePlanElements.Deletion_of_Plan_Elements");

    public CMDeletePlanElements(List pmPlanElements, int deletionMode, ICommandContext commandContext) {
        super(commandContext);
        if (logger.isDebugEnabled()) {
            logger.debug(64, "CMDeletePlanElements(List pmPlanElements = " + pmPlanElements + ") - start");
        }
        assert (pmPlanElements != null);
        if (!pmPlanElements.isEmpty()) {
            TADeletePlanElementStructure transaction = new TADeletePlanElementStructure(pmPlanElements, this.getActionParameters());
            super.construct(COMMAND_LABEL, (Transaction)transaction);
            List iPlanElements = FrameComUtilities.transformModelsToIPlanElements(pmPlanElements);
            this.getEditorController().deletePlanElementsRequest(iPlanElements, (IPlanEditorCommand)this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(64, "CMDeletePlanElements() - end");
        }
    }
}

