/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.framecom.FrameComUtilities;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.transactions.TACreatePlanElementStructureByShortcutHandle;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMCreatePlanElementStructureByShortcutHandle
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMCreatePlanElementStructureByShortcutHandle.class);
    private static final String COMMAND_LABEL = Messages.getString("CMCreatePlanElementStructure.Creation_of_Plan_Element(s)");

    public CMCreatePlanElementStructureByShortcutHandle(IPMPlanRW planToInsert, GeoVector transl, IPMPlanRW targetPlan, List uidMappings, Collection nativeContent, ICommandContext commandContext, GeoVector distanceToDestinationInTargetPlan, List<IPMPlanElementRO> peToMove, boolean snap) {
        super(commandContext);
        GeoVector newDistanceToDestinationInTargetPlan;
        GeoVector translation = transl;
        if (logger.isTraceEnabled()) {
            logger.trace("CMCreatePlanElementStructure(IPMPlanRO planToInsert = " + planToInsert + ", GeoVector translation = " + translation + ", IPMPlanRW targetPlan = " + targetPlan + ") - start");
        }
        assert (planToInsert != null) : "planToInsert is null";
        assert (targetPlan != null) : "targetPlan is null";
        assert (translation != null) : "translation is null";
        if (snap) {
            GeoVector distanceToDestinationInTargetPlanSnapped;
            GeoVector completeTranslationUnsnapped = GeoVector.add((GeoVector)translation, (GeoVector)distanceToDestinationInTargetPlan);
            ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>();
            int i = 0;
            while (i < peToMove.size()) {
                Collection figures = peToMove.get(i).getEditIPMFiguresRO();
                points.addAll(SnappablePoint.gatherPoints(figures));
                ++i;
            }
            GeoVector completeTranslationSnapped = commandContext.getGrid().snapObjectTranslation(points, completeTranslationUnsnapped);
            newDistanceToDestinationInTargetPlan = distanceToDestinationInTargetPlanSnapped = GeoVector.add((GeoVector)completeTranslationSnapped, (GeoVector)translation.turn180());
        } else {
            newDistanceToDestinationInTargetPlan = distanceToDestinationInTargetPlan;
        }
        TACreatePlanElementStructureByShortcutHandle transaction = new TACreatePlanElementStructureByShortcutHandle(planToInsert, translation, targetPlan, this.getActionParameters(), newDistanceToDestinationInTargetPlan, peToMove);
        String fromWhere = Messages.getString("CMCreatePlanElementStructure.by_drawing");
        super.construct(String.valueOf(COMMAND_LABEL) + fromWhere, (Transaction)transaction);
        if (transaction.isValid()) {
            boolean stateSaved = transaction.getState();
            transaction.setState(true);
            List createdPlanElements = transaction.getCreatedPlanElements();
            List iPlanElements = FrameComUtilities.transformModelsToIPlanElements(createdPlanElements);
            this.getEditorController().createPlanElementsRequest(iPlanElements, (Collection)uidMappings, nativeContent, (IPlanEditorCommand)this);
            transaction.setState(stateSaved);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("CMCreatePlanElementStructure(IPMPlanRO, GeoVector, IPMPlanRW) - end");
        }
    }

    @Override
    protected boolean canUndoNow() {
        return true;
    }
}

