/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.framecom.FrameComUtilities;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.transactions.TACreatePlanElementStructureAsCopy;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMCreatePlanElementStructureAsCopy
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMCreatePlanElementStructureAsCopy.class);
    private static final String COMMAND_LABEL = Messages.getString("CMCreatePlanElementStructure.Creation_of_Plan_Element(s)");

    public CMCreatePlanElementStructureAsCopy(IPMPlanRW planToInsert, GeoVector transl, IPMPlanRW targetPlan, List uidMappings, Collection nativeContent, int creationMode, ICommandContext commandContext) {
        super(commandContext);
        GeoVector translation = transl;
        if (logger.isTraceEnabled()) {
            logger.trace("CMCreatePlanElementStructureAsCopy(IPMPlanRO planToInsert = " + planToInsert + ", GeoVector translation = " + translation + ", IPMPlanRW targetPlan = " + targetPlan + ") - start");
        }
        assert (planToInsert != null) : "planToInsert is null";
        assert (targetPlan != null) : "targetPlan is null";
        assert (translation != null) : "translation is null";
        ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>();
        int i = 0;
        while (i < planToInsert.getPlanElementCount()) {
            Collection figures = planToInsert.getPlanElementRW(i).getEditIPMFiguresRW();
            points.addAll(SnappablePoint.gatherPoints(figures));
            ++i;
        }
        translation = commandContext.getGrid().snapObjectTranslation(points, translation);
        TACreatePlanElementStructureAsCopy transaction = new TACreatePlanElementStructureAsCopy(planToInsert, translation, targetPlan, this.getActionParameters());
        String fromWhere = "";
        switch (creationMode) {
            case 1: {
                fromWhere = Messages.getString("CMCreatePlanElementStructureAsCopy.from_Palette");
                break;
            }
            case 3: {
                fromWhere = Messages.getString("CMCreatePlanElementStructureAsCopy.from_Clipboard");
                break;
            }
            case 4: {
                fromWhere = Messages.getString("CMCreatePlanElementStructureAsCopy.as_duplicate(s)");
                break;
            }
            case 2: {
                fromWhere = Messages.getString("CMCreatePlanElementStructure.by_drawing");
            }
        }
        super.construct(String.valueOf(COMMAND_LABEL) + fromWhere, (Transaction)transaction);
        if (transaction.isValid()) {
            boolean stateSaved = transaction.getState();
            transaction.setState(true);
            List createdPlanElements = transaction.getCreatedPlanElements();
            List iPlanElements = FrameComUtilities.transformModelsToIPlanElements(createdPlanElements);
            this.getEditorController().createPlanElementsRequest(iPlanElements, (Collection)uidMappings, nativeContent, (IPlanEditorCommand)this);
            transaction.setState(stateSaved);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("CMCreatePlanElementStructureAsCopy(IPMPlanRO, GeoVector, IPMPlanRW) - end");
        }
    }

    @Override
    protected boolean canUndoNow() {
        return true;
    }

    protected TACreatePlanElementStructureAsCopy getCreateTransaction() {
        return (TACreatePlanElementStructureAsCopy)this.getTransaction();
    }
}

