/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.PlanElementGeometryAnalysis;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.transactions.TAAlignPlanElementStructure;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CMAlignPlanElementStructure
extends TransactionCommand {
    private static final String COMMAND_LABEL_SINGULAR = Messages.getString("CMAlignPlanElementStructure.Align_Plan_Element");
    private static final String COMMAND_LABEL_PLURAL = Messages.getString("CMAlignPlanElementStructure.Align_Plan_Elements");

    public CMAlignPlanElementStructure(List<IPMPlanElementRO> pmPlanElements, IPMPlanElementRO masterElement, int alignment, double wishedPosition, ICommandContext commandContext) {
        super(commandContext);
        assert (pmPlanElements != null);
        if (pmPlanElements.size() > 0) {
            HashMap<IPMPlanElementRO, GeoVector> planElement2Distance = new HashMap<IPMPlanElementRO, GeoVector>(pmPlanElements.size() * 2);
            for (IPMPlanElementRO planElement : pmPlanElements) {
                if (planElement.equals(masterElement)) continue;
                GeoVector wishedDistance = PlanElementGeometryAnalysis.getDistance(planElement, alignment, wishedPosition);
                IPMPlanRO plan = planElement.getPlanRO();
                Set planElementWithUnselectedContainees = plan.getAllContained(Collections.singleton(planElement));
                planElementWithUnselectedContainees.removeAll(pmPlanElements);
                planElementWithUnselectedContainees.add(planElement);
                ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>();
                for (IPMPlanElementRO planElementOrUnselectedContainee : planElementWithUnselectedContainees) {
                    Collection figures = planElementOrUnselectedContainee.getEditIPMFiguresRO();
                    points.addAll(SnappablePoint.gatherPoints(figures));
                }
                GeoVector snappedDistance = commandContext.getGrid().snapObjectTranslation(points, wishedDistance);
                if (snappedDistance.isZero()) continue;
                for (IPMPlanElementRO planElementOrUnselectedContainee : planElementWithUnselectedContainees) {
                    planElement2Distance.put(planElementOrUnselectedContainee, snappedDistance);
                }
            }
            TAAlignPlanElementStructure transaction = planElement2Distance.isEmpty() ? null : new TAAlignPlanElementStructure(planElement2Distance, this.getActionParameters());
            if (pmPlanElements.size() == 1) {
                super.construct(COMMAND_LABEL_SINGULAR, (Transaction)transaction);
            } else {
                super.construct(COMMAND_LABEL_PLURAL, (Transaction)transaction);
            }
        }
    }
}

