/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.check;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.IInvalidPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.check.ProblemFrameBadContainment;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.framecom.ExternalSyntaxCheckerMgr;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.action.IAction;

public class ExternalSyntaxChecker {
    private static final ILogger logger = Logger.getLogger(ExternalSyntaxChecker.class);
    private Collection<? extends IInvalidPlanElement> invalidPlanElements = Collections.emptyList();
    private final PEPlan plan;
    private final ICheckMgr checkMgr;
    private final ExternalSyntaxCheckerMgr externalCheckMgr;

    public ExternalSyntaxChecker(PEPlan plan, ICheckMgr checkMgr, ExternalSyntaxCheckerMgr externalCheckMgr) {
        this.plan = plan;
        this.checkMgr = checkMgr;
        this.externalCheckMgr = externalCheckMgr;
    }

    public void setInvalidPlanElements(Collection<? extends IInvalidPlanElement> invalidPlanElements) {
        this.invalidPlanElements = invalidPlanElements == null ? Collections.emptyList() : invalidPlanElements;
        this.checkMgr.triggerSyntaxChecks(this.externalCheckMgr);
    }

    public Collection<? extends ISyntaxProblem> checkSyntax() {
        ArrayList<ProblemFrameBadContainment> problems = new ArrayList<ProblemFrameBadContainment>();
        for (IInvalidPlanElement iInvalidPlanElement : this.invalidPlanElements) {
            IPMPlanElementRO pe = this.plan.getPMPlan().getPlanElementRO(iInvalidPlanElement.getPlanElementUID());
            if (pe != null) {
                problems.add(new ProblemFrameBadContainment(pe));
                continue;
            }
            logger.error("Frame reported IInvalidPlanElement with unknown UID " + iInvalidPlanElement.getPlanElementUID() + " (on plan " + iInvalidPlanElement.getPlanUID() + ")");
        }
        return problems;
    }

    public IAction getActionForProblem(ISyntaxProblem problem, ContextMenuContext context) {
        String peUID = problem.getPlanElement().getUid();
        for (IInvalidPlanElement iInvalidPlanElement : this.invalidPlanElements) {
            if (!iInvalidPlanElement.getPlanElementUID().equals(peUID)) continue;
            return iInvalidPlanElement.getAction();
        }
        return null;
    }
}

