/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.java.Assert;
import com.arcway.planagent.planeditor.edit.IZoomChangedListener;
import com.arcway.planagent.planeditor.edit.IZoomMgr;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.gef.SharedMessages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class ZoomComboContributionItem
extends ContributionItem
implements IZoomChangedListener {
    public static final String FIT_HEIGHT = SharedMessages.FitHeightAction_Label;
    public static final String FIT_WIDTH = SharedMessages.FitWidthAction_Label;
    public static final String FIT_ALL = SharedMessages.FitAllAction_Label;
    private Combo combo;
    private final String[] initStrings;
    private ToolItem toolitem;
    private IZoomMgr zoomMgr;
    private final IPartService service;
    private IPartListener partListener;

    public ZoomComboContributionItem(IPartService partService) {
        super("org.eclipse.gef.zoom_widget");
        this.service = partService;
        this.initStrings = new String[]{"100%"};
        Assert.checkArgumentBeeingNotNull((Object)partService);
        this.partListener = new IPartListener(){
            IEditorPart lastActiveEditor = null;

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    this.lastActiveEditor = (IEditorPart)part;
                    if (this.lastActiveEditor.getAdapter(IZoomMgr.class) != null) {
                        ZoomComboContributionItem.this.setZoomManager((IZoomMgr)this.lastActiveEditor.getAdapter(IZoomMgr.class));
                    } else {
                        ZoomComboContributionItem.this.setZoomManager(null);
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == this.lastActiveEditor) {
                    ZoomComboContributionItem.this.setZoomManager(null);
                }
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    void refresh() {
        block7: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (this.zoomMgr == null) {
                    this.combo.setEnabled(false);
                    this.combo.removeAll();
                } else {
                    this.combo.setItems(this.getZoomLevelsAsText());
                    String zoom = this.convertToText(this.getZoomManager().getZoom());
                    int index = this.combo.indexOf(zoom);
                    if (index != -1) {
                        this.combo.select(index);
                    } else {
                        this.combo.setText(zoom);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block7;
                throw exception;
            }
        }
    }

    private String convertToText(double d) {
        String toReturn = LocalisationUtils.roundLocalizedWithoutGrouping((double)(d * 100.0), (int)0, (boolean)false);
        toReturn = toReturn.concat("%");
        return toReturn;
    }

    private String[] getZoomLevelsAsText() {
        String[] levels = new String[]{"50%", "75%", "100%", "150%", "200%", "250%", "300%", "400%", FIT_ALL, FIT_WIDTH, FIT_HEIGHT};
        return levels;
    }

    protected int computeWidth(Control control) {
        int width = control.computeSize((int)-1, (int)-1, (boolean)true).x;
        if (SWT.getPlatform().equals("win32")) {
            width += FigureUtilities.getTextWidth((String)"8", (Font)control.getFont());
        }
        return width;
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ZoomComboContributionItem.this.combo = null;
            }
        });
        this.combo.setItems(this.initStrings);
        this.toolitem.setWidth(this.computeWidth((Control)this.combo));
        this.refresh();
        return this.combo;
    }

    public void dispose() {
        if (this.partListener != null) {
            this.service.removePartListener(this.partListener);
            this.partListener = null;
        }
        if (this.zoomMgr != null) {
            this.zoomMgr = null;
        }
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.checkArgument((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public IZoomMgr getZoomManager() {
        return this.zoomMgr;
    }

    public void setZoomManager(IZoomMgr newZoomMgr) {
        if (this.zoomMgr == newZoomMgr) {
            return;
        }
        if (this.zoomMgr != null) {
            this.zoomMgr.removeZoomChangedListener(this);
        }
        this.zoomMgr = newZoomMgr;
        if (this.zoomMgr != null) {
            this.zoomMgr.addZoomChangedListener(this);
        }
        this.refresh();
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.zoomMgr != null) {
            this.setTextZoom(this.combo.getText());
        }
    }

    private void handleWidgetSelected(SelectionEvent event) {
        if (this.zoomMgr != null) {
            this.setTextZoom(this.combo.getText());
        }
    }

    @Override
    public void zoomChanged(double zoom) {
        this.refresh();
    }

    private void setTextZoom(String zoomString) {
        if (this.zoomMgr != null) {
            if (zoomString.equals(FIT_HEIGHT) && this.zoomMgr != null) {
                this.zoomMgr.setCalculatedZoom(3);
            } else if (zoomString.equals(FIT_ALL) && this.zoomMgr != null) {
                this.zoomMgr.setCalculatedZoom(1);
            } else if (zoomString.equals(FIT_WIDTH) && this.zoomMgr != null) {
                this.zoomMgr.setCalculatedZoom(2);
            } else {
                try {
                    if (zoomString.charAt(zoomString.length() - 1) == '%') {
                        zoomString = zoomString.substring(0, zoomString.length() - 1);
                    }
                    this.zoomMgr.setZoom(Double.parseDouble(zoomString) / 100.0);
                }
                catch (Exception e) {
                    Display.getCurrent().beep();
                }
            }
        }
    }
}

