/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.edit.IZoomMgr;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class UIZoomAction
extends AbstractUIAction {
    public static final int ZOOM_IN = -1;
    public static final int ZOOM_OUT = -2;
    public static final int ZOOM_FIT = -3;
    public final String id = "de.plans.fmca.planagent.planeditor.actions.zoominaction";
    private IPartListener partListener;
    private final IPartService partService;
    private IZoomMgr zoomMgr;
    private int zoomMode;

    public UIZoomAction(IPartService service, int mode) {
        super((IWorkbenchPart)((IWorkbenchPage)service).getActiveEditor());
        this.partService = service;
        this.initMode(mode);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part.getAdapter(IZoomMgr.class) != null) {
                    UIZoomAction.this.setZoomManager((IZoomMgr)part.getAdapter(IZoomMgr.class));
                } else {
                    UIZoomAction.this.setZoomManager(null);
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
                UIZoomAction.this.setZoomManager(null);
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        this.partService.addPartListener(this.partListener);
    }

    protected boolean calculateEnabled() {
        return this.zoomMgr != null;
    }

    protected void init() {
        this.setId("de.plans.fmca.planagent.planeditor.actions.zoominaction");
    }

    public void run() {
        if (this.zoomMgr != null) {
            if (this.zoomMode == -1) {
                this.zoomMgr.zoomIn();
            } else if (this.zoomMode == -2) {
                this.zoomMgr.zoomOut();
            } else if (this.zoomMode == -3) {
                this.zoomMgr.setCalculatedZoom(1);
            } else if (this.zoomMode > 0) {
                this.zoomMgr.setZoom((double)this.zoomMode / 100.0);
            }
        }
    }

    public void setZoomManager(IZoomMgr newZoomMgr) {
        if (this.zoomMgr == newZoomMgr) {
            return;
        }
        this.zoomMgr = newZoomMgr;
        this.refresh();
    }

    public void dispose() {
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
        }
        this.partListener = null;
    }

    private void initMode(int mode) {
        this.zoomMode = mode;
        this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"lens.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        if (this.zoomMode == -1) {
            this.setText(Messages.getString("UIZoomInOutAction.Zoom_In"));
            this.setAccelerator(SWT.MOD1 + 43);
        } else if (this.zoomMode == -2) {
            this.setText(Messages.getString("UIZoomInOutAction.Zoom_Out"));
            this.setAccelerator(SWT.MOD1 + 45);
        } else if (this.zoomMode == -3) {
            this.setText(Messages.getString("UIZoomInOutAction.Zoom_Fit"));
            this.setAccelerator(SWT.MOD1 + 48);
        } else if (this.zoomMode > 0) {
            this.setText(String.valueOf(Messages.getString("UIZoomInOutAction.Zoom_Value1")) + this.zoomMode + Messages.getString("UIZoomInOutAction.Zoom_Value2"));
            this.setAccelerator(SWT.MOD1 + Integer.toString(this.zoomMode).charAt(0));
        }
    }
}

