/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.actions.AbstractUIPlanElementAction;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import de.plans.lib.eclipse.ResourceLoader;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IAction;

public class UISyntaxProblemAction
extends AbstractUIPlanElementAction {
    public static final String ID = "de.plans.fmca.planagent.actions.uisyntaxerroraction";
    private final ContextMenuContext context;
    private final PEPlanElement planElement;
    private final ISyntaxProblem syntaxProblem;

    public UISyntaxProblemAction(ISyntaxProblem problem, PEPlanElement element, ContextMenuContext context) {
        super(context);
        this.syntaxProblem = problem;
        this.planElement = element;
        this.context = context;
        this.setText(this.syntaxProblem.getShortDescription());
        this.setToolTipText(this.syntaxProblem.getDescription());
        this.setId(ID);
        this.update();
        if (problem.getProblemCategory() == 2) {
            this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"syntaxerror.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        } else if (problem.getProblemCategory() == 1) {
            this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"syntaxwarning.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        } else if (problem.getProblemCategory() == 0) {
            this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"syntaxinfo.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        }
    }

    protected void init() {
        super.init();
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    @Override
    public void run() {
        if (this.planElement != null) {
            IAction action = this.planElement.getPEPlan().getViewMgr().getActionForSyntaxProblem(this.planElement.getPEPlan(), this.syntaxProblem, this.context);
            action.run();
        }
    }

    @Override
    protected Command getCommand(List<PEPlanElement> list) {
        return null;
    }

    @Override
    protected Class<? extends IPMPlanElementRO> getIPlanElementROType() {
        return null;
    }

    @Override
    protected boolean isVisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isVisibleInProjectionMode() {
        return true;
    }

    public String getPreferedMenuGroup() {
        return null;
    }
}

