/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.IModeChangedListener;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.check.ISyntaxProblemListener;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import de.plans.lib.eclipse.ResourceLoader;
import java.util.Collection;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Disposable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class UISyntaxCheckSwitcherToolbarAction
extends Action
implements Disposable,
ISyntaxProblemListener,
IModeChangedListener {
    private static final String id = "de.plans.fmca.planagent.planeditor.actions.syntaxcheckswitcheraction";
    private final IPartService partService;
    private IPartListener partListener = null;
    private PlanEditor currentPlanEditor = null;

    public UISyntaxCheckSwitcherToolbarAction(IPartService partService) {
        this.partService = partService;
        this.setId(id);
        this.setText(Messages.getString("UISyntaxCheckSwitcherAction.syntaxCheck"));
        this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"syntaxwarning.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        this.setAccelerator(SWT.MOD1 | 0x49);
        this.updateButtonState();
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                UISyntaxCheckSwitcherToolbarAction.this.setPart(part);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                UISyntaxCheckSwitcherToolbarAction.this.setPart(null);
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    private void setPart(IWorkbenchPart part) {
        IEditorPart editorPart;
        Object planEditorObject;
        PlanEditor planEditor;
        if (this.currentPlanEditor != null) {
            this.currentPlanEditor.removeModeChangeListener(this);
            ICheckMgr checkMgr = (ICheckMgr)this.currentPlanEditor.getAdapter(ICheckMgr.class);
            if (checkMgr != null) {
                checkMgr.unregisterSyntaxProblemListener(this);
            }
            this.currentPlanEditor = null;
        }
        if (part != null && part instanceof IEditorPart && (planEditor = (PlanEditor)(planEditorObject = (editorPart = (IEditorPart)part).getAdapter(PlanEditor.class))) != null) {
            this.currentPlanEditor = planEditor;
            this.currentPlanEditor.addModeChangeListener(this);
            ICheckMgr checkMgr = (ICheckMgr)this.currentPlanEditor.getAdapter(ICheckMgr.class);
            if (checkMgr != null) {
                checkMgr.registerSyntaxProblemListener(this);
            }
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        ICheckMgr checkMgr = this.currentPlanEditor == null ? null : (ICheckMgr)this.currentPlanEditor.getAdapter(ICheckMgr.class);
        boolean syntaxCheckEnabled = checkMgr != null ? checkMgr.isSyntaxCheckEnabled() : false;
        boolean isActive = syntaxCheckEnabled;
        boolean isEnbled = false;
        if (this.currentPlanEditor != null && checkMgr != null) {
            isEnbled = this.currentPlanEditor.getWorkingMode() == 1;
        }
        this.setChecked(isActive);
        this.setEnabled(isEnbled);
        if (isActive) {
            this.setToolTipText(Messages.getString("UISyntaxCheckSwitcherAction.disableSyntaxCheck"));
        } else {
            this.setToolTipText(Messages.getString("UISyntaxCheckSwitcherAction.EnableSyntaxCheck"));
        }
    }

    public void run() {
        ICheckMgr checkMgr = (ICheckMgr)this.currentPlanEditor.getAdapter(ICheckMgr.class);
        if (checkMgr != null) {
            checkMgr.setSyntaxCheckEnabled(!checkMgr.isSyntaxCheckEnabled());
        }
    }

    public void dispose() {
        this.setPart(null);
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
            this.partListener = null;
        }
    }

    @Override
    public void modeChanged(int newMode) {
        this.updateButtonState();
    }

    @Override
    public void syntaxProblemListChanged(Collection<? extends ISyntaxProblem> allSyntaxProblems) {
        this.updateButtonState();
    }
}

