/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractUIAppearanceButtonWithMenu;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.CILineColor;
import com.arcway.planagent.planeditor.actions.CILineColorConstantsAndMaps;
import com.arcway.planagent.planeditor.actions.LineColorDecoration;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;

public class UILineColor
extends AbstractUIAppearanceButtonWithMenu {
    private final CILineColor lineColorContributionItem;

    public UILineColor(IWorkbenchPage workbenchPage) {
        super(workbenchPage, LineColorDecoration.getInstance(), Messages.getString("UILineColor.Line_Color"), CILineColorConstantsAndMaps.INIT_COLOR);
        this.lineColorContributionItem = new CILineColor(workbenchPage);
    }

    @Override
    protected Menu fillMenu(MenuManager menuManager, Control parent) {
        Menu menu = menuManager.createContextMenu(parent);
        menuManager.add((IContributionItem)this.lineColorContributionItem);
        this.lineColorContributionItem.fill(menu, -1);
        return menu;
    }

    @Override
    public void selectionChanged(AppearanceUtil.SelectionInfoProvider selectionInfoProvider) {
        this.refresh(selectionInfoProvider);
    }

    @Override
    protected void updateStateFromSelection(AppearanceUtil.SelectionInfoProvider selectionInfoProvider) {
        Set<Object> selectedStates = selectionInfoProvider.getSelectedStates();
        if (!selectedStates.isEmpty()) {
            Color selectedColor = null;
            boolean allStatesAreTheSame = true;
            for (Color color : selectedStates) {
                if (selectedColor == null) {
                    selectedColor = color;
                    continue;
                }
                if (color.equalsColor(selectedColor)) continue;
                allStatesAreTheSame = false;
                break;
            }
            if (allStatesAreTheSame) {
                super.setState(selectionInfoProvider, selectedColor);
            } else {
                super.setState(selectionInfoProvider, CILineColorConstantsAndMaps.INIT_COLOR);
            }
        }
    }
}

