/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IInputProcessor;
import com.arcway.planagent.planeditor.tools.IToolChangedListener;
import com.arcway.planagent.planeditor.tools.IToolStateChangedListener;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class UIDeselectAllAction
extends AbstractUIAction
implements ISelectionChangedListener,
IToolChangedListener,
IToolStateChangedListener {
    private static final String ID = "de.plans.fmca.planagent.planeditor.actions.deselectall";
    private PlanEditorEditDomain editDomain;
    private GenericTool genericTool;
    private GraphicalViewer viewer;

    public UIDeselectAllAction(IWorkbenchPart part) {
        super(part);
        this.setWorkbenchPart(part);
    }

    @Override
    protected void setWorkbenchPart(IWorkbenchPart part) {
        Object newEditDomainObject;
        Object viewerObject;
        GraphicalViewer newViewer = null;
        if (part != null && (viewerObject = part.getAdapter(GraphicalViewer.class)) != null && viewerObject instanceof GraphicalViewer) {
            newViewer = (GraphicalViewer)viewerObject;
        }
        this.setViewer(newViewer);
        PlanEditorEditDomain newEditDomain = null;
        if (part != null && (newEditDomainObject = part.getAdapter(PlanEditorEditDomain.class)) != null && newEditDomainObject instanceof PlanEditorEditDomain) {
            newEditDomain = (PlanEditorEditDomain)newEditDomainObject;
        }
        this.setEditDomain(newEditDomain);
        super.setWorkbenchPart(part);
    }

    private void setViewer(GraphicalViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.viewer = null;
        }
        if (viewer != null) {
            this.viewer = viewer;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.updateEnabled();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateEnabled();
    }

    private void setEditDomain(PlanEditorEditDomain editDomain) {
        this.setGenericTool(null);
        if (this.editDomain != null) {
            this.editDomain.removeToolChangedListener(this);
            this.editDomain = null;
        }
        if (editDomain != null) {
            this.editDomain = editDomain;
            this.editDomain.addToolChangedListener(this);
            this.toolChanged(editDomain.getActiveTool());
        } else {
            this.toolChanged(null);
        }
    }

    @Override
    public void toolChanged(Tool activeTool) {
        GenericTool activeGenericTool = null;
        if (activeTool != null && activeTool instanceof GenericTool) {
            activeGenericTool = (GenericTool)activeTool;
        }
        this.setGenericTool(activeGenericTool);
    }

    private void setGenericTool(GenericTool genericTool) {
        if (this.genericTool != null) {
            this.genericTool.removeToolStateChangedListener(this);
            this.genericTool = null;
        }
        if (genericTool != null) {
            this.genericTool = genericTool;
            this.genericTool.addToolStateChangedListener(this);
            this.toolStateChanged(this.genericTool.getActiveInputProcessor());
        } else {
            this.toolStateChanged(null);
        }
    }

    @Override
    public void toolStateChanged(IInputProcessor inputProcessor) {
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.calculateEnabled());
    }

    protected boolean calculateEnabled() {
        ISelection selection;
        boolean enabled = false;
        if (this.viewer != null && (selection = this.viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                enabled = structuredSelection.getFirstElement() != this.viewer.getContents();
            } else if (structuredSelection.size() > 1) {
                enabled = true;
            }
        }
        if (this.genericTool != null) {
            enabled &= this.genericTool.getActiveInputProcessor() == null;
        }
        return enabled;
    }

    protected void init() {
        this.setId(ID);
        this.setText(Messages.getString("UIDeselectAllAction.DeselectAll"));
        this.setAccelerator(27);
        this.setEnabled(true);
    }

    public void run() {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection());
        }
    }
}

