/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.dialogs.IPrinterCreator;
import com.arcway.planagent.planeditor.dialogs.SaveAsPNGDialogSettings;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class UICopyAsImageAction
extends AbstractUIAction
implements IAction,
IPrinterCreator {
    private static final ILogger logger = Logger.getLogger(UICopyAsImageAction.class);
    private static File clipboardFile = null;
    private static final double MAX_PAGE_SIZE = 160.0;
    private static final double RESOLUTION = 300.0;
    protected static final Insets PAGE_INSETS = new Insets(0.5);
    protected static final Insets FRAME_INSETS = new Insets(10.0);
    protected static final double MIN_LEGEND_DISTANCE = 10.0;
    private static final String ID = "de.plans.fmca.planagent.planeditor.actions.uicopyasimage";
    private IWorkbenchPart part;
    private IPartListener partListener;
    private final IPartService partService;
    private IEditorContent editorContent;
    private Collection selectedPlanElements;
    PVView pVViewCache;
    private SaveAsPNGDialogSettings settingsCopy;

    private static synchronized File getClipboardFile(String planName) throws IOException {
        if (clipboardFile == null) {
            String fileName = FileHelper.convertStringToPortableFileName((String)planName);
            clipboardFile = File.createTempFile(fileName, ".png");
            clipboardFile.deleteOnExit();
        }
        return clipboardFile;
    }

    public UICopyAsImageAction(IPartService service) {
        super((IWorkbenchPart)((IWorkbenchPage)service).getActiveEditor());
        this.partService = service;
        this.part = this.partService.getActivePart();
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                UICopyAsImageAction.super.setWorkbenchPart(part);
                UICopyAsImageAction.this.part = part;
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                UICopyAsImageAction.this.part = null;
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.partService.addPartListener(this.partListener);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void dispose() {
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
        }
        this.partListener = null;
    }

    protected void init() {
        this.setId(ID);
        this.setText(Messages.getString("UICopyAsImageAction.Copy_As_Image"));
        this.setAccelerator(131139);
        this.setEnabled(true);
    }

    public void run() {
        GraphicalViewer viewer = null;
        PMPlan plan = null;
        if (this.part != null) {
            if (this.part.getAdapter(GraphicalViewer.class) != null) {
                viewer = (GraphicalViewer)this.part.getAdapter(GraphicalViewer.class);
            }
            if (this.part.getAdapter(PMPlan.class) != null) {
                plan = (PMPlan)this.part.getAdapter(PMPlan.class);
            }
        }
        if (viewer != null && plan != null) {
            PMPlan planToExportTemp;
            List selectedEditParts = viewer.getSelectedEditParts();
            this.selectedPlanElements = new HashSet(plan.getPlanElementCount());
            for (EditPart editPart : selectedEditParts) {
                if (editPart instanceof PEPlanElement) {
                    PEPlanElement pePlanElement = (PEPlanElement)editPart;
                    this.selectedPlanElements.add(pePlanElement.getPMPlanElement());
                    continue;
                }
                if (editPart instanceof PEFigure) {
                    PEFigure peFigure = (PEFigure)editPart;
                    this.selectedPlanElements.add(peFigure.getPMFigure().getPlanElement());
                    continue;
                }
                if (!(editPart instanceof PEGraphicalSupplement)) continue;
                PEGraphicalSupplement peGraphicalSupplement = (PEGraphicalSupplement)editPart;
                this.selectedPlanElements.add(peGraphicalSupplement.getPMPlanObject().getPlanElementRO());
            }
            if (this.selectedPlanElements.isEmpty()) {
                this.selectedPlanElements = null;
            }
            if (this.selectedPlanElements != null) {
                try {
                    planToExportTemp = plan.getCut(this.selectedPlanElements);
                    this.project((IPMPlanRO)planToExportTemp, new ArrayList(this.getAllProjectionRequests((IPMPlanRO)plan)));
                    this.highlightPlanElements((IPMPlanRO)planToExportTemp, HighlightLevel.BUSINESS, this.getAllHighlightRequests(HighlightLevel.BUSINESS, (IPMPlanRO)plan));
                }
                catch (EXPlanCreationException e) {
                    planToExportTemp = plan;
                }
            } else {
                planToExportTemp = plan;
            }
            final PMPlan planToExport = planToExportTemp;
            this.editorContent = new IEditorContent(){

                public IPlanInfo getPlanInfo() {
                    return ((PlanEditor)UICopyAsImageAction.this.getWorkbenchPart().getAdapter(PlanEditor.class)).getContent().getPlanInfo();
                }

                public IPMPlanRO getPlanModel() {
                    return planToExport;
                }
            };
            this.settingsCopy = new SaveAsPNGDialogSettings();
            this.settingsCopy.setBackgroundTransparent(this.selectedPlanElements != null);
            this.settingsCopy.setIncludeInformation(this.selectedPlanElements == null);
            this.settingsCopy.setIncludeHighlights(this.selectedPlanElements == null);
            this.settingsCopy.setIncludeProjections(true);
            this.settingsCopy.setSetMarginsAutomatically(false);
            this.settingsCopy.setPageSetup(new PageSetup(1, 1, new Alignment(2, 16), 1.0, true, true, PAGE_INSETS));
            this.settingsCopy.setHorizontalDPI(300.0);
            this.settingsCopy.setVerticalDPI(300.0);
            double zoom = 1.0;
            Rectangle planSize = this.getView().getOuterBoundsWithoutChildren();
            if (planSize != null) {
                double maxLength = Math.max((planSize = planSize.expand(PAGE_INSETS)).w(), planSize.h());
                if (maxLength > 160.0 && maxLength > 1.0E-10) {
                    zoom = 160.0 / maxLength;
                }
                this.settingsCopy.setWidthPxl((int)Math.round(planSize.w() * zoom * 0.03937007874015748 * 300.0));
                this.settingsCopy.setHeightPxl((int)Math.round(planSize.h() * zoom * 0.03937007874015748 * 300.0));
            } else {
                this.settingsCopy.setWidthPxl((int)Math.round(1889.7637795275589));
                this.settingsCopy.setHeightPxl((int)Math.round(1889.7637795275589));
            }
            this.settingsCopy.setMode(3);
            try {
                String planName = planToExport.getName();
                File file = UICopyAsImageAction.getClipboardFile(planName);
                this.saveAs(file);
                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                String fileName = file.getAbsolutePath();
                String[] fileNames = new String[]{fileName};
                ImageData imageData = ((SWTImageData)SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread().loadImageData((IStreamResource)new FileResource(file))).getWrappedSWTImageData();
                clipboard.setContents(new Object[]{imageData, fileNames}, new Transfer[]{ImageTransfer.getInstance(), FileTransfer.getInstance()});
                clipboard.dispose();
                this.pVViewCache = null;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected String saveAs(File file) {
        ImagePrinter printer = (ImagePrinter)this.createPrinter();
        long start = 0L;
        long middle = 0L;
        long end = 0L;
        if (logger.isDebugEnabled(73)) {
            start = System.currentTimeMillis();
        }
        PrintingFailure failure = this.print((IPrinter)printer);
        if (logger.isDebugEnabled(73)) {
            middle = System.currentTimeMillis();
        }
        if (failure == null) {
            this.getShell().setCursor(Cursors.WAIT);
            try {
                printer.saveImageDirectly(file, ImageCoDec.PNG);
            }
            catch (PrintingFailure e) {
                failure = e;
            }
            catch (EXEmptyResult e) {
                failure = new PrintingFailure((Throwable)e);
            }
            this.getShell().setCursor(Cursors.ARROW);
        }
        if (logger.isDebugEnabled(73)) {
            end = System.currentTimeMillis();
            logger.debug(73, "Draw plan: " + (middle - start) + "ms");
            logger.debug(73, "Save png:  " + (end - middle) + "ms");
        }
        this.disposePrinter((IPrinter)printer);
        String errorMsg = null;
        if (failure != null) {
            errorMsg = failure.getCause() instanceof EXImageTooBig ? Messages.getString("SaveAsImageDialog.Image_Too_Big") : Messages.getString("SaveAsImageDialog.Print_Failure_Text");
        }
        return errorMsg;
    }

    @Override
    public IPrinter createPrinter() {
        double wInMM = 25.4 * (double)this.settingsCopy.getWidthPxl() / this.settingsCopy.getHorizontalDPI();
        double hInMM = 25.4 * (double)this.settingsCopy.getHeightPxl() / this.settingsCopy.getVerticalDPI();
        Color backgroundColor = this.settingsCopy.isBackgroundTransparent() ? Color.TRANSPARENT : Color.WHITE;
        return new ImagePrinter(ImagePrinterPageDescription.createImageInfoInMM((double)wInMM, (double)hInMM, (Insets)new Insets(0.0, 0.0, 0.0, 0.0), (double)this.settingsCopy.getHorizontalDPI(), (double)this.settingsCopy.getVerticalDPI(), (Color)backgroundColor));
    }

    @Override
    public void disposePrinter(IPrinter printer) {
        ((ImagePrinter)printer).disposeImages();
    }

    protected final PrintingFailure print(IPrinter printer) {
        PrintingFailure failure = null;
        Shell shell = this.getShell();
        shell.setCursor(Cursors.WAIT);
        PrintProcessor pp = new PrintProcessor();
        try {
            pp.print(printer, this.getView(), this.settingsCopy.getPageSetup(), this.editorContent.getPlanInfo().getPlanName());
        }
        catch (PrintingFailure f) {
            failure = f;
        }
        shell.setCursor(Cursors.ARROW);
        return failure;
    }

    private PVView getView() {
        if (this.pVViewCache == null) {
            ViewCreator creator = new ViewCreator();
            FrameViewConfig frameViewConfig = null;
            if (this.settingsCopy.isIncludeInformation()) {
                UICopyAsImageAction printerCreator = this;
                IPrinter printer = printerCreator.createPrinter();
                boolean marginsAreOuterBorder = this.settingsCopy.isSetMarginsAutomatically();
                PageInfo pageInfo = new PageInfo(printer, this.settingsCopy.getPageSetup().getMargin(), marginsAreOuterBorder);
                printerCreator.disposePrinter(printer);
                frameViewConfig = this.getFrameViewConfig(pageInfo);
            }
            this.pVViewCache = creator.createPVView(this.editorContent, null, this.settingsCopy.isIncludeComments(), (HighlightLevel)(this.settingsCopy.isIncludeHighlights() ? HighlightLevel.BUSINESS : null), this.settingsCopy.isIncludeProjections(), frameViewConfig);
        }
        return this.pVViewCache;
    }

    protected FrameViewConfig getFrameViewConfig(PageInfo pageInfo) {
        FrameViewConfig frameViewConfig;
        switch (this.settingsCopy.getMode()) {
            case 0: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)FRAME_INSETS, (double)10.0, (double)1.0);
                break;
            }
            case 1: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)FRAME_INSETS, (double)10.0, (double)1.0);
                break;
            }
            case 2: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)FRAME_INSETS, (double)10.0, (double)1.0);
                break;
            }
            case 3: {
                frameViewConfig = FrameViewConfig.createFrameExpandedToPageBorders((Insets)FRAME_INSETS, (double)10.0, (double)1.0, (PageInfo)pageInfo);
                break;
            }
            default: {
                frameViewConfig = null;
            }
        }
        return frameViewConfig;
    }

    protected final Set getAllHighlightRequests(HighlightLevel highlightLevel, IPMPlanRO plan) {
        HashSet<IHighlightRequest> highlightRequests = new HashSet<IHighlightRequest>();
        int i = 0;
        while (i < plan.getPlanElementCount()) {
            IPMPlanElementRO planElement = plan.getPlanElementRO(i);
            PMHighlight highlight = planElement.getHighlight(highlightLevel);
            if (highlight != null) {
                IHighlightRequest highlightRequest = highlight.getHighlightRequest();
                highlightRequests.add(highlightRequest);
            }
            ++i;
        }
        return highlightRequests;
    }

    protected final Set getAllProjectionRequests(IPMPlanRO plan) {
        Collection projections = plan.getProjections();
        HashSet<IProjectionRequest> projectionRequests = new HashSet<IProjectionRequest>(projections.size());
        for (PMProjection projection : projections) {
            IProjectionRequest projectionRequest = projection.getProjectionRequest();
            projectionRequests.add(projectionRequest);
        }
        return projectionRequests;
    }

    public void highlightPlanElements(IPMPlanRO plan, HighlightLevel highlightLevel, Collection highlightRequests) {
        IModelChangeRW modelChange;
        IPMPlanModelObjectFactoryRW planModelObjectFactory;
        PMHighlight highlight;
        IPMPlanElementRO pe;
        assert (highlightRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set oldRequests = this.getAllHighlightRequests(highlightLevel, plan);
        HashSet newRequests = new HashSet(highlightRequests);
        HashSet addedRequests = new HashSet(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet removedRequests = new HashSet(oldRequests);
        removedRequests.removeAll(newRequests);
        for (IHighlightRequest request : removedRequests) {
            pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            highlight = pe.getHighlight(highlightLevel);
            pe.setHighlight(highlightLevel, null);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 3);
            modelChanges.add(modelChange);
        }
        for (IHighlightRequest request : addedRequests) {
            pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            highlight = new PMHighlight((PMPlanElement)pe, request);
            pe.setHighlight(highlightLevel, highlight);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 1);
            modelChanges.add(modelChange);
        }
    }

    public void project(IPMPlanRO plan, List projectionRequests) {
        assert (projectionRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set oldRequests = this.getAllProjectionRequests(plan);
        HashSet newRequests = new HashSet(projectionRequests);
        HashSet addedRequests = new HashSet(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet removedRequests = new HashSet(oldRequests);
        removedRequests.removeAll(newRequests);
        List oldLegends = plan.getLegends();
        ArrayList<PMLegend> newLegends = new ArrayList<PMLegend>();
        ArrayList<PMProjection> projections = new ArrayList<PMProjection>(plan.getProjections());
        for (PMLegend legend : oldLegends) {
            IPMPlanModelObjectFactoryRW planModelObjectFactory = legend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)legend, 3);
            modelChanges.add(modelChange);
        }
        for (IProjectionRequest request : removedRequests) {
            boolean found = false;
            Iterator j = projections.iterator();
            while (!found && j.hasNext()) {
                PMProjection projection = (PMProjection)j.next();
                if (!projection.getPMPlanElement().getUid().equals(request.getPlanElementUID())) continue;
                j.remove();
                found = true;
                IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 3);
                modelChanges.add(modelChange);
            }
        }
        for (IProjectionRequest request : addedRequests) {
            if (request.getPlanElementUID() == null) {
                PMLegend legend = new PMLegend((PMPlan)plan, request);
                newLegends.add(legend);
                IPMPlanModelObjectFactoryRW planModelObjectFactory = legend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)legend, 1);
                modelChanges.add(modelChange);
                continue;
            }
            IPMPlanElementRO pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            PMProjection projection = new PMProjection((PMPlanElement)pe, request);
            projections.add(projection);
            IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 1);
            modelChanges.add(modelChange);
        }
        plan.setProjections(projections);
        plan.setLegends(newLegends);
    }
}

