/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planeditor.PlanEditorFacade;
import com.arcway.planagent.planeditor.actions.AbstractUIPlanElementAction;
import com.arcway.planagent.planeditor.actions.UICopyAsEMFAction;
import com.arcway.planagent.planeditor.edit.IClipboard;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class UIClipboardAction
extends AbstractUIPlanElementAction {
    public static final int CUT = 1;
    public static final int COPY = 2;
    public static final int PASTE = 3;
    private final int clipboardMode;
    private final String message;

    protected UIClipboardAction(IWorkbenchPart part, int mode) {
        super(part);
        assert (part != null) : "WorkbenchPart is null";
        this.clipboardMode = mode;
        this.init();
        ISharedImages sharedImages = this.getWorkbenchPart().getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        if (this.clipboardMode == 1) {
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else if (this.clipboardMode == 2) {
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        } else if (this.clipboardMode == 3) {
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        }
        this.message = this.getText();
    }

    protected boolean calculateEnabled() {
        boolean toReturn = false;
        if (this.clipboardMode == 1) {
            if (!this.getSelectedPlanElements().isEmpty()) {
                int workingMode = ((PlanEditor)((PlanEditorFacade)this.getWorkbenchPart()).getPlanAgentExtension()).getWorkingMode();
                toReturn = workingMode != 3;
            }
        } else if (this.clipboardMode == 2) {
            toReturn = true;
        } else if (this.clipboardMode == 3) {
            int workingMode = ((PlanEditor)((PlanEditorFacade)this.getWorkbenchPart()).getPlanAgentExtension()).getWorkingMode();
            toReturn = workingMode != 3;
        }
        return toReturn;
    }

    protected void init() {
        if (this.clipboardMode == 1) {
            this.setId(ActionFactory.CUT.getId());
        } else if (this.clipboardMode == 2) {
            this.setId(ActionFactory.COPY.getId());
        } else if (this.clipboardMode == 3) {
            this.setId(ActionFactory.PASTE.getId());
        }
    }

    @Override
    public void run() {
        IClipboard clipboard = (IClipboard)this.getWorkbenchPart().getAdapter(IClipboard.class);
        if (clipboard != null) {
            List<PEPlanEditPart> selectedPlanElements = this.getSelectedPlanElements();
            this.getShell().setCursor(Cursors.WAIT);
            if (this.clipboardMode == 1 && !selectedPlanElements.isEmpty()) {
                clipboard.cut(selectedPlanElements);
            } else if (this.clipboardMode == 2 && !selectedPlanElements.isEmpty()) {
                clipboard.copy(selectedPlanElements);
            } else if (this.clipboardMode == 2 && selectedPlanElements.isEmpty()) {
                UICopyAsEMFAction.copyAsEMF(this.getWorkbenchPart());
            } else if (this.clipboardMode == 3) {
                clipboard.paste();
            }
            this.getShell().setCursor(Cursors.ARROW);
        }
    }

    @Override
    protected Command getCommand(List<PEPlanElement> list) {
        return null;
    }

    protected Class getIPlanElementROType() {
        return null;
    }

    @Override
    protected boolean isVisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isVisibleInProjectionMode() {
        return this.clipboardMode == 2;
    }

    public String getPreferedMenuGroup() {
        return null;
    }
}

