/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IColorProvider;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UIChangeFillColorAppearanceAction
extends UIChangeAppearanceAction
implements IColorProvider {
    private final FillColor initialColor;
    private final Map<IWorkbenchPage, FillColor> workbenchPage2fillColor = new HashMap<IWorkbenchPage, FillColor>();

    public UIChangeFillColorAppearanceAction(String actionID, String text, FillColor state, IAppearanceButtonDecoration buttonType) {
        super(null, actionID, text, state, buttonType);
        this.initialColor = state;
    }

    public void init(IWorkbenchPage workbenchPage) {
        super.setWorkbenchPage(workbenchPage);
    }

    @Override
    public void run() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        if (workbenchPage != null) {
            Shell activeShell = workbenchPage.getWorkbenchWindow().getShell();
            ColorDialog dlg = new ColorDialog(activeShell);
            Color dialogColor = new Color(this.getColor());
            dlg.setRGB(new RGB(dialogColor.r, dialogColor.g, dialogColor.b));
            dlg.setText(Messages.getString("UISetColor.Please_choose_a_color"));
            RGB result = dlg.open();
            if (result != null) {
                FillColor newFillColor = new FillColor(result.red, result.green, result.blue);
                super.setState(newFillColor);
                super.run();
                this.setColor(newFillColor.foregroundColor);
            }
        }
    }

    @Override
    public Color getColor() {
        Color color = this.initialColor.foregroundColor;
        if (this.workbenchPage2fillColor.containsKey(this.getWorkbenchPage())) {
            color = this.workbenchPage2fillColor.get((Object)this.getWorkbenchPage()).foregroundColor;
        }
        return color;
    }

    @Override
    public void setColor(Color color) {
        this.workbenchPage2fillColor.put(this.getWorkbenchPage(), new FillColor(color));
    }
}

