/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IColorProvider;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UIChangeColorAppearanceAction
extends UIChangeAppearanceAction
implements IColorProvider {
    private final Color initialColor;
    private final Map<IWorkbenchPage, Color> workbenchPage2Color = new HashMap<IWorkbenchPage, Color>();

    public UIChangeColorAppearanceAction(String actionID, String text, Color state, IAppearanceButtonDecoration buttonType) {
        super(null, actionID, text, state, buttonType);
        this.initialColor = state;
    }

    public void init(IWorkbenchPage workbenchPage) {
        super.setWorkbenchPage(workbenchPage);
    }

    @Override
    public void run() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        if (workbenchPage != null) {
            Shell activeShell = workbenchPage.getWorkbenchWindow().getShell();
            ColorDialog dlg = new ColorDialog(activeShell);
            Color dialogColor = this.getColor();
            dlg.setRGB(new RGB(dialogColor.r, dialogColor.g, dialogColor.b));
            dlg.setText(Messages.getString("UISetColor.Please_choose_a_color"));
            RGB result = dlg.open();
            if (result != null) {
                dialogColor = new Color(result.red, result.green, result.blue);
                super.setState(dialogColor);
                super.run();
                this.setColor(dialogColor);
            }
        }
    }

    @Override
    public Color getColor() {
        Color color = this.initialColor;
        if (this.workbenchPage2Color.containsKey(this.getWorkbenchPage())) {
            color = this.workbenchPage2Color.get(this.getWorkbenchPage());
        }
        return color;
    }

    @Override
    public void setColor(Color color) {
        this.workbenchPage2Color.put(this.getWorkbenchPage(), color);
    }
}

