/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.ActionParameterStorage;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.IActionParameterListener;
import com.arcway.planagent.planeditor.IModeChangedListener;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Disposable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class UIBendingSwitcherToolbarAction
extends Action
implements Disposable,
IActionParameterListener,
IModeChangedListener {
    private static final String id = "de.plans.fmca.planagent.planeditor.actions.bendingswitcheraction";
    private final IPartService partService;
    private IPartListener partListener = null;
    private PlanEditor currentPlanEditor = null;

    public UIBendingSwitcherToolbarAction(IPartService partService) {
        this.partService = partService;
        this.setId(id);
        this.setText(Messages.getString("UIBendingSwitcherAction.edgeBending"));
        this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"bending.gif", (Plugin)FMCAPlanEditorPlugin.getDefault()));
        this.setAccelerator(SWT.MOD1 | 0x52);
        ActionParameterStorage.getInstance().addParameterListener(this);
        this.updateButtonState();
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                UIBendingSwitcherToolbarAction.this.setPart(part);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                UIBendingSwitcherToolbarAction.this.setPart(null);
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    private void setPart(IWorkbenchPart part) {
        IEditorPart editorPart;
        Object planEditorObject;
        PlanEditor planEditor;
        if (this.currentPlanEditor != null) {
            this.currentPlanEditor.removeModeChangeListener(this);
            this.currentPlanEditor = null;
        }
        if (part != null && part instanceof IEditorPart && (planEditor = (PlanEditor)(planEditorObject = (editorPart = (IEditorPart)part).getAdapter(PlanEditor.class))) != null) {
            this.currentPlanEditor = planEditor;
            this.currentPlanEditor.addModeChangeListener(this);
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        boolean isActive = ActionParameterStorage.getInstance().isBendingActive();
        boolean isEnbled = false;
        if (this.currentPlanEditor != null) {
            isEnbled = this.currentPlanEditor.getWorkingMode() == 1;
        }
        this.setChecked(isActive);
        this.setEnabled(isEnbled);
        if (isActive) {
            this.setToolTipText(Messages.getString("UIBendingSwitcherAction.disableEdgeBending"));
        } else {
            this.setToolTipText(Messages.getString("UIBendingSwitcherAction.EnableEdgeBending"));
        }
    }

    public void run() {
        ActionParameterStorage.getInstance().setIsBendingActive(!ActionParameterStorage.getInstance().isBendingActive());
    }

    public void dispose() {
        ActionParameterStorage.getInstance().removeParameterListener(this);
        this.setPart(null);
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
            this.partListener = null;
        }
    }

    @Override
    public void actionParameterChanged(ActionParameters actionParameter) {
        this.updateButtonState();
    }

    @Override
    public void modeChanged(int newMode) {
        this.updateButtonState();
    }
}

