/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractUIPlanElementAction;
import com.arcway.planagent.planeditor.commands.CMAlignPlanElementStructure;
import com.arcway.planagent.planeditor.commands.PlanElementGeometryAnalysis;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import de.plans.lib.eclipse.ResourceLoader;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class UIAlignPlanElementsAction
extends AbstractUIPlanElementAction {
    private static final String ID_H_LEFT = "h_left";
    private static final String ID_H_CENTER = "h_center";
    private static final String ID_H_RIGHT = "h_right";
    private static final String ID_V_TOP = "v_top";
    private static final String ID_V_CENTER = "v_center";
    private static final String ID_V_BOTTOM = "v_bottom";
    private final int alignment;

    public static final String getID(int alignment) {
        return UIAlignPlanElementsAction.getGEFActionID(alignment);
    }

    public static final String getID(String infix) {
        int alignment = UIAlignPlanElementsAction.getAlignment(infix);
        return UIAlignPlanElementsAction.getID(alignment);
    }

    static final String getMessage(int alignment) {
        return Messages.getString("UIAlignPlanElementsAction." + UIAlignPlanElementsAction.getInfix(alignment));
    }

    static final String getToolTip(int alignment) {
        return Messages.getString("UIAlignPlanElementsAction." + UIAlignPlanElementsAction.getInfix(alignment) + "_desc");
    }

    public static final ImageDescriptor getImageDescriptor(int alignment) {
        return ResourceLoader.getImageDescriptor((String)("align_" + UIAlignPlanElementsAction.getInfix(alignment) + ".png"), (Plugin)FMCAPlanEditorPlugin.getDefault());
    }

    private static String getInfix(int alignment) {
        String infix;
        switch (alignment) {
            case 1: {
                infix = ID_H_LEFT;
                break;
            }
            case 2: {
                infix = ID_H_CENTER;
                break;
            }
            case 4: {
                infix = ID_H_RIGHT;
                break;
            }
            case 8: {
                infix = ID_V_TOP;
                break;
            }
            case 16: {
                infix = ID_V_CENTER;
                break;
            }
            case 32: {
                infix = ID_V_BOTTOM;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return infix;
    }

    private static int getAlignment(String infix) {
        int alignment;
        if (infix.equals(ID_H_LEFT)) {
            alignment = 1;
        } else if (infix.equals(ID_H_CENTER)) {
            alignment = 2;
        } else if (infix.equals(ID_H_RIGHT)) {
            alignment = 4;
        } else if (infix.equals(ID_V_TOP)) {
            alignment = 8;
        } else if (infix.equals(ID_V_CENTER)) {
            alignment = 16;
        } else if (infix.equals(ID_V_BOTTOM)) {
            alignment = 32;
        } else {
            throw new IllegalArgumentException();
        }
        return alignment;
    }

    private static String getGEFActionID(int alignment) {
        String gefActionID;
        switch (alignment) {
            case 1: {
                gefActionID = "org.eclipse.gef.align_left";
                break;
            }
            case 2: {
                gefActionID = "org.eclipse.gef.align_center";
                break;
            }
            case 4: {
                gefActionID = "org.eclipse.gef.align_right";
                break;
            }
            case 8: {
                gefActionID = "org.eclipse.gef.align_top";
                break;
            }
            case 16: {
                gefActionID = "org.eclipse.gef.align_middle";
                break;
            }
            case 32: {
                gefActionID = "org.eclipse.gef.align_bottom";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return gefActionID;
    }

    public UIAlignPlanElementsAction(IWorkbenchPart part, int alignment) {
        super(part);
        this.alignment = alignment;
        this.initAfterAlignmentWasSet();
    }

    public UIAlignPlanElementsAction(IPartService service, int alignment) {
        super((IWorkbenchPart)((IWorkbenchPage)service).getActiveEditor());
        this.alignment = alignment;
        this.initAfterAlignmentWasSet();
    }

    public UIAlignPlanElementsAction(ContextMenuContext context, int alignment) {
        super(context);
        this.alignment = alignment;
        this.initAfterAlignmentWasSet();
    }

    protected void initAfterAlignmentWasSet() {
        this.setText(UIAlignPlanElementsAction.getMessage(this.alignment));
        this.setToolTipText(UIAlignPlanElementsAction.getToolTip(this.alignment));
        this.setId(UIAlignPlanElementsAction.getID(this.alignment));
        this.setImageDescriptor(UIAlignPlanElementsAction.getImageDescriptor(this.alignment));
    }

    protected boolean calculateEnabled() {
        if (this.getWorkbenchPart() != null) {
            Command cmd = this.getCommand();
            if (cmd == null) {
                return false;
            }
            return cmd.canExecute();
        }
        return false;
    }

    @Override
    protected Command getCommand(List<PEPlanElement> pePlanElements) {
        List<PMPlanElement> pmPlanElementsAsObjects;
        PEPlanElement master = UIAlignPlanElementsAction.getMasterPlanElement(pePlanElements);
        if (pePlanElements.size() < 2 || master == null) {
            return null;
        }
        List<PMPlanElement> pmPlanElements = pmPlanElementsAsObjects = IIUtilities.getRelatedPMPlanElements(pePlanElements, null);
        PMPlanElement planElement = master.getPMPlanElement();
        double wishedPosition = PlanElementGeometryAnalysis.getBoundary((IPMPlanElementRO)planElement, this.alignment);
        return new CMAlignPlanElementStructure(pmPlanElements, (IPMPlanElementRO)planElement, this.alignment, wishedPosition, super.getCommandContext());
    }

    public static PEPlanElement getMasterPlanElement(List<PEPlanElement> pePlanElements) {
        PEPlanElement masterPlanElement = pePlanElements.isEmpty() ? null : pePlanElements.get(pePlanElements.size() - 1);
        return masterPlanElement;
    }

    @Override
    protected Class<? extends IPMPlanElementRO> getIPlanElementROType() {
        return null;
    }

    @Override
    protected boolean isVisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isVisibleInProjectionMode() {
        return false;
    }

    public String getPreferedMenuGroup() {
        return null;
    }
}

